/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashSet;
import java.util.Set;
import net.optifine.Config;
import net.optifine.DynamicLights;

public class DynamicLight {
    private bum entity = null;
    private double offsetY = 0.0;
    private double lastPosX = -2.147483648E9;
    private double lastPosY = -2.147483648E9;
    private double lastPosZ = -2.147483648E9;
    private int lastLightLevel = 0;
    private long timeCheckMs = 0L;
    private Set<ji> setLitChunkPos = new HashSet();

    public DynamicLight(bum entity) {
        this.entity = entity;
        this.offsetY = entity.cS();
    }

    public void update(glv renderGlobal) {
        if (Config.isDynamicLightsFast()) {
            long timeNowMs = System.currentTimeMillis();
            if (timeNowMs < this.timeCheckMs + 500L) {
                return;
            }
            this.timeCheckMs = timeNowMs;
        }
        double posX = this.entity.dA() - 0.5;
        double posY = this.entity.dC() - 0.5 + this.offsetY;
        double posZ = this.entity.dG() - 0.5;
        int lightLevel = DynamicLights.getLightLevel((bum)this.entity);
        double dx = posX - this.lastPosX;
        double dy = posY - this.lastPosY;
        double dz = posZ - this.lastPosZ;
        double delta = 0.1;
        if (Math.abs(dx) <= delta && Math.abs(dy) <= delta && Math.abs(dz) <= delta && this.lastLightLevel == lightLevel) {
            return;
        }
        this.lastPosX = posX;
        this.lastPosY = posY;
        this.lastPosZ = posZ;
        this.lastLightLevel = lightLevel;
        HashSet setNewPos = new HashSet();
        if (lightLevel > 0) {
            jn dirX = (ayz.a((double)posX) & 0xF) >= 8 ? jn.f : jn.e;
            jn dirY = (ayz.a((double)posY) & 0xF) >= 8 ? jn.b : jn.a;
            jn dirZ = (ayz.a((double)posZ) & 0xF) >= 8 ? jn.d : jn.c;
            long chunkPos = this.getChunkPos(posX, posY, posZ);
            gpn.b chunk = renderGlobal.getRenderChunk(chunkPos);
            long chunkPosX = this.getChunkPos(chunk, chunkPos, dirX);
            gpn.b chunkX = renderGlobal.getRenderChunk(chunkPosX);
            long chunkPosZ = this.getChunkPos(chunk, chunkPos, dirZ);
            gpn.b chunkZ = renderGlobal.getRenderChunk(chunkPosZ);
            long chunkPosXZ = this.getChunkPos(chunkX, chunkPosX, dirZ);
            gpn.b chunkXZ = renderGlobal.getRenderChunk(chunkPosXZ);
            long chunkPosY = this.getChunkPos(chunk, chunkPos, dirY);
            gpn.b chunkY = renderGlobal.getRenderChunk(chunkPosY);
            long chunkPosYX = this.getChunkPos(chunkY, chunkPosY, dirX);
            gpn.b chunkYX = renderGlobal.getRenderChunk(chunkPosYX);
            long chunkPosYZ = this.getChunkPos(chunkY, chunkPosY, dirZ);
            gpn.b chunkYZ = renderGlobal.getRenderChunk(chunkPosYZ);
            long chunkPosYXZ = this.getChunkPos(chunkYX, chunkPosYX, dirZ);
            gpn.b chunkYXZ = renderGlobal.getRenderChunk(chunkPosYXZ);
            this.updateChunkLight(chunk, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkXZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkY, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYX, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYZ, this.setLitChunkPos, setNewPos);
            this.updateChunkLight(chunkYXZ, this.setLitChunkPos, setNewPos);
        }
        this.updateLitChunks(renderGlobal);
        this.setLitChunkPos = setNewPos;
    }

    private long getChunkPos(double x, double y2, double z) {
        int cx = kk.a((int)ayz.a((double)x));
        int cy = kk.a((int)ayz.a((double)y2));
        int cz = kk.a((int)ayz.a((double)z));
        return kk.b((int)cx, (int)cy, (int)cz);
    }

    private long getChunkPos(gpn.b renderChunk, long pos, jn facing) {
        int x = kk.b((long)pos);
        int y2 = kk.c((long)pos);
        int z = kk.d((long)pos);
        return kk.b((int)(x += facing.j()), (int)(y2 += facing.k()), (int)(z += facing.l()));
    }

    private void updateChunkLight(gpn.b renderChunk, Set<ji> setPrevPos, Set<ji> setNewPos) {
        if (renderChunk == null) {
            return;
        }
        gpn.a compiledChunk = renderChunk.d();
        if (compiledChunk != null && !compiledChunk.isEmpty()) {
            renderChunk.a(false);
            renderChunk.setNeedsBackgroundPriorityUpdate(true);
        }
        ji pos = renderChunk.f().j();
        if (setPrevPos != null) {
            setPrevPos.remove(pos);
        }
        if (setNewPos != null) {
            setNewPos.add(pos);
        }
    }

    public void updateLitChunks(glv renderGlobal) {
        for (ji posOld : this.setLitChunkPos) {
            gpn.b chunkOld = renderGlobal.getRenderChunk(posOld);
            this.updateChunkLight(chunkOld, null, null);
        }
    }

    public bum getEntity() {
        return this.entity;
    }

    public double getLastPosX() {
        return this.lastPosX;
    }

    public double getLastPosY() {
        return this.lastPosY;
    }

    public double getLastPosZ() {
        return this.lastPosZ;
    }

    public int getLastLightLevel() {
        return this.lastLightLevel;
    }

    public double getOffsetY() {
        return this.offsetY;
    }

    public String toString() {
        return "Entity: " + String.valueOf(this.entity) + ", offsetY: " + this.offsetY;
    }
}

