/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.model;

import net.optifine.model.QuadBounds;

public class QuadBounds {
    private float minX = Float.MAX_VALUE;
    private float minY = Float.MAX_VALUE;
    private float minZ = Float.MAX_VALUE;
    private float maxX = -3.4028235E38f;
    private float maxY = -3.4028235E38f;
    private float maxZ = -3.4028235E38f;

    public QuadBounds(int[] vertexData) {
        int step = vertexData.length / 4;
        for (int i = 0; i < 4; ++i) {
            int pos = i * step;
            float x = Float.intBitsToFloat(vertexData[pos + 0]);
            float y2 = Float.intBitsToFloat(vertexData[pos + 1]);
            float z = Float.intBitsToFloat(vertexData[pos + 2]);
            if (this.minX > x) {
                this.minX = x;
            }
            if (this.minY > y2) {
                this.minY = y2;
            }
            if (this.minZ > z) {
                this.minZ = z;
            }
            if (this.maxX < x) {
                this.maxX = x;
            }
            if (this.maxY < y2) {
                this.maxY = y2;
            }
            if (!(this.maxZ < z)) continue;
            this.maxZ = z;
        }
    }

    public float getMinX() {
        return this.minX;
    }

    public float getMinY() {
        return this.minY;
    }

    public float getMinZ() {
        return this.minZ;
    }

    public float getMaxX() {
        return this.maxX;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public float getMaxZ() {
        return this.maxZ;
    }

    public boolean isFaceQuad(jn face) {
        float val;
        float max;
        float min;
        switch (1.$SwitchMap$net$minecraft$core$Direction[face.ordinal()]) {
            case 1: {
                min = this.getMinY();
                max = this.getMaxY();
                val = 0.0f;
                break;
            }
            case 2: {
                min = this.getMinY();
                max = this.getMaxY();
                val = 1.0f;
                break;
            }
            case 3: {
                min = this.getMinZ();
                max = this.getMaxZ();
                val = 0.0f;
                break;
            }
            case 4: {
                min = this.getMinZ();
                max = this.getMaxZ();
                val = 1.0f;
                break;
            }
            case 5: {
                min = this.getMinX();
                max = this.getMaxX();
                val = 0.0f;
                break;
            }
            case 6: {
                min = this.getMinX();
                max = this.getMaxX();
                val = 1.0f;
                break;
            }
            default: {
                return false;
            }
        }
        return min == val && max == val;
    }

    public boolean isFullQuad(jn face) {
        float max2;
        float min2;
        float max1;
        float min1;
        switch (1.$SwitchMap$net$minecraft$core$Direction[face.ordinal()]) {
            case 1: 
            case 2: {
                min1 = this.getMinX();
                max1 = this.getMaxX();
                min2 = this.getMinZ();
                max2 = this.getMaxZ();
                break;
            }
            case 3: 
            case 4: {
                min1 = this.getMinX();
                max1 = this.getMaxX();
                min2 = this.getMinY();
                max2 = this.getMaxY();
                break;
            }
            case 5: 
            case 6: {
                min1 = this.getMinY();
                max1 = this.getMaxY();
                min2 = this.getMinZ();
                max2 = this.getMaxZ();
                break;
            }
            default: {
                return false;
            }
        }
        return min1 == 0.0f && max1 == 1.0f && min2 == 0.0f && max2 == 1.0f;
    }
}

