/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Supplier;

public class ChunkLayerMap<T> {
    private T[] values = new Object[gmj.CHUNK_RENDER_TYPES.length];
    private Supplier<T> defaultValue;

    public ChunkLayerMap(Function<gmj, T> initialValue) {
        int i;
        gmj[] renderTypes = gmj.CHUNK_RENDER_TYPES;
        this.values = new Object[renderTypes.length];
        for (i = 0; i < renderTypes.length; ++i) {
            gmj renderType = renderTypes[i];
            T t = initialValue.apply(renderType);
            this.values[renderType.ordinal()] = t;
        }
        for (i = 0; i < this.values.length; ++i) {
            if (this.values[i] != null) continue;
            throw new RuntimeException("Missing value at index: " + i);
        }
    }

    public T get(gmj layer) {
        return (T)this.values[layer.ordinal()];
    }

    public Collection<T> values() {
        return Arrays.asList(this.values);
    }
}

