/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import java.nio.FloatBuffer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.regex.Pattern;
import net.optifine.Config;
import net.optifine.util.GpuMemory;
import net.optifine.util.MathUtils;
import net.optifine.util.StrUtils;
import net.optifine.util.TimedEvent;
import org.joml.Matrix4f;
import org.joml.Runtime;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

/*
 * Exception performing whole class analysis ignored.
 */
public class DebugUtils {
    private static FloatBuffer floatBuffer16 = BufferUtils.createFloatBuffer((int)16);
    private static float[] floatArray16 = new float[16];
    private static String[] FRAME_UNIFORMS = new String[0];
    private static NumberFormat NUMBER_FORMAT = new DecimalFormat(" 0.00E0;-", new DecimalFormatSymbols(Locale.ROOT));
    private static Pattern PATTERN_EXP = Pattern.compile("E(\\d)");

    public static String getGlModelView() {
        floatBuffer16.clear();
        GL11.glGetFloatv((int)2982, (FloatBuffer)floatBuffer16);
        floatBuffer16.get(floatArray16);
        float[] floatArray16T = DebugUtils.transposeMat4((float[])floatArray16);
        return DebugUtils.getMatrix4((float[])floatArray16T);
    }

    public static String getGlProjection() {
        floatBuffer16.clear();
        GL11.glGetFloatv((int)2983, (FloatBuffer)floatBuffer16);
        floatBuffer16.get(floatArray16);
        float[] floatArray16T = DebugUtils.transposeMat4((float[])floatArray16);
        return DebugUtils.getMatrix4((float[])floatArray16T);
    }

    private static float[] transposeMat4(float[] arr) {
        float[] arrT = new float[16];
        for (int x = 0; x < 4; ++x) {
            for (int y2 = 0; y2 < 4; ++y2) {
                arrT[x * 4 + y2] = arr[y2 * 4 + x];
            }
        }
        return arrT;
    }

    public static String getMatrix4(Matrix4f mat) {
        MathUtils.write((Matrix4f)mat, (float[])floatArray16);
        return DebugUtils.getMatrix4((float[])floatArray16);
    }

    public static String getMatrix3(float[] fs) {
        return DebugUtils.getMatrix3((float[])fs, (String)"\n");
    }

    public static String getMatrix3(float[] fs, String lineSep) {
        return DebugUtils.getMatrix((float[])fs, (int)3, (String)lineSep);
    }

    public static String getMatrix4(float[] fs) {
        return DebugUtils.getMatrix4((float[])fs, (String)"\n");
    }

    public static String getMatrix4(float[] fs, String lineSep) {
        return DebugUtils.getMatrix((float[])fs, (int)4, (String)lineSep);
    }

    public static String getMatrix(float[] fs, int cols, String lineSep) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < fs.length; ++i) {
            String str = DebugUtils.format((double)fs[i]);
            if (i > 0) {
                if (i % cols == 0) {
                    sb.append(lineSep);
                } else {
                    sb.append(" ");
                }
            }
            str = StrUtils.fillLeft((String)str, (int)5, (char)' ');
            sb.append(str);
        }
        return sb.toString();
    }

    private static String format(double val) {
        String str = Runtime.format((double)val, (NumberFormat)NUMBER_FORMAT);
        str = PATTERN_EXP.matcher(str).replaceAll("E+$1");
        str = str.replace('E', 'e');
        return str;
    }

    public static void debugVboMemory(gpn.b[] renderChunks) {
        if (!TimedEvent.isActive((String)"DbgVbos", (long)3000L)) {
            return;
        }
        int sum = 0;
        int countChunks = 0;
        int countVbos = 0;
        int countLayers = 0;
        for (int i = 0; i < renderChunks.length; ++i) {
            gpn.b renderChunk = renderChunks[i];
            int sumPre = sum;
            for (gmj rt : gpn.BLOCK_RENDER_LAYERS) {
                ffy vb = renderChunk.a(rt);
                if (vb.getIndexCount() > 0) {
                    sum += vb.getIndexCount() * vb.d().b();
                    ++countVbos;
                }
                if (!renderChunk.d().isLayerUsed(rt)) continue;
                ++countLayers;
            }
            if (sum <= sumPre) continue;
            ++countChunks;
        }
        Config.dbg((String)("VRAM: " + sum / 0x100000 + " MB, vbos: " + countVbos + ", layers: " + countLayers + ", chunks: " + countChunks));
        Config.dbg((String)("VBOs: " + GpuMemory.getBufferAllocated() / 0x100000L + " MB"));
    }

    public static void debugTextures() {
        Config.dbg((String)" *** TEXTURES ***");
        hev textureManager = flk.Q().aa();
        long sum = 0L;
        Collection locations = textureManager.getTextureLocations();
        ArrayList list = new ArrayList(locations);
        Collections.sort(list);
        for (akv loc : list) {
            hee texture = textureManager.b(loc);
            long size = GpuMemory.getTextureSize((hee)texture);
            if (Config.isShaders()) {
                size *= 3L;
            }
            Config.dbg((String)(String.valueOf(loc) + " = " + size));
            sum += size;
        }
        Config.dbg((String)("All: " + sum));
    }

    public static String getClassName(Object obj) {
        if (obj == null) {
            return "null";
        }
        return obj.getClass().getName();
    }
}

