/*
 * Decompiled with CFR 0.152.
 */
package com.teammetallurgy.aquaculture.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import com.teammetallurgy.aquaculture.client.ClientHandler;
import com.teammetallurgy.aquaculture.client.renderer.entity.layers.JellyfishLayer;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishCathfishModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishLargeModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishLongnoseModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishMediumModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.FishSmallModel;
import com.teammetallurgy.aquaculture.client.renderer.entity.model.JellyfishModel;
import com.teammetallurgy.aquaculture.entity.AquaFishEntity;
import com.teammetallurgy.aquaculture.entity.FishType;
import javax.annotation.Nonnull;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.TropicalFishModelB;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class AquaFishRenderer
extends MobRenderer<AquaFishEntity, EntityModel<AquaFishEntity>> {
    private static final ResourceLocation DEFAULT_LOCATION = new ResourceLocation("aquaculture", "textures/entity/fish/atlantic_cod.png");
    private final TropicalFishModelB<AquaFishEntity> tropicalFishBModel;
    private final FishSmallModel<AquaFishEntity> smallModel;
    private final FishMediumModel<AquaFishEntity> mediumModel;
    private final FishLargeModel<AquaFishEntity> largeModel;
    private final FishLongnoseModel<AquaFishEntity> longnoseModel;
    private final FishCathfishModel<AquaFishEntity> catfishModel;
    private final JellyfishModel<AquaFishEntity> jellyfishModel;

    public AquaFishRenderer(EntityRendererProvider.Context context, boolean isJellyfish) {
        super(context, new FishMediumModel(context.m_174023_(ClientHandler.MEDIUM_MODEL)), 0.35f);
        this.tropicalFishBModel = new TropicalFishModelB(context.m_174023_(ModelLayers.f_171256_));
        this.smallModel = new FishSmallModel(context.m_174023_(ClientHandler.SMALL_MODEL));
        this.mediumModel = new FishMediumModel(context.m_174023_(ClientHandler.MEDIUM_MODEL));
        this.largeModel = new FishLargeModel(context.m_174023_(ClientHandler.LARGE_MODEL));
        this.longnoseModel = new FishLongnoseModel(context.m_174023_(ClientHandler.LONGNOSE_MODEL));
        this.catfishModel = new FishCathfishModel(context.m_174023_(ClientHandler.CATFISH_MODEL));
        this.jellyfishModel = new JellyfishModel(context.m_174023_(ClientHandler.JELLYFISH_MODEL));
        if (isJellyfish) {
            this.m_115326_(new JellyfishLayer(this, context.m_174027_()));
        }
    }

    public void render(@Nonnull AquaFishEntity fishEntity, float entityYaw, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int i) {
        if (fishEntity != null) {
            switch (fishEntity.getFishType()) {
                case SMALL: {
                    this.f_115290_ = this.smallModel;
                    break;
                }
                case LARGE: {
                    this.f_115290_ = this.largeModel;
                    break;
                }
                case LONGNOSE: {
                    this.f_115290_ = this.longnoseModel;
                    break;
                }
                case CATFISH: {
                    this.f_115290_ = this.catfishModel;
                    break;
                }
                case JELLYFISH: {
                    this.f_115290_ = this.jellyfishModel;
                    break;
                }
                case HALIBUT: {
                    this.f_115290_ = this.tropicalFishBModel;
                    break;
                }
                default: {
                    this.f_115290_ = this.mediumModel;
                }
            }
            super.m_7392_((Mob)fishEntity, entityYaw, partialTicks, matrixStack, buffer, i);
        }
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull AquaFishEntity fishEntity) {
        ResourceLocation location = fishEntity.m_6095_().getRegistryName();
        if (location != null) {
            return new ResourceLocation("aquaculture", "textures/entity/fish/" + location.m_135815_() + ".png");
        }
        return DEFAULT_LOCATION;
    }

    protected void setupRotations(@Nonnull AquaFishEntity fishEntity, @Nonnull PoseStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_((LivingEntity)fishEntity, matrixStack, ageInTicks, rotationYaw, partialTicks);
        FishType fishType = fishEntity.getFishType();
        if (fishType != FishType.JELLYFISH) {
            float salmonRotation = 1.0f;
            float salmonMultiplier = 1.0f;
            if (fishType == FishType.LONGNOSE && !fishEntity.m_20069_()) {
                salmonRotation = 1.3f;
                salmonMultiplier = 1.7f;
            }
            float fishRotation = fishType == FishType.LONGNOSE ? salmonRotation * 4.3f * Mth.m_14031_((float)(salmonMultiplier * 0.6f * ageInTicks)) : 4.3f * Mth.m_14031_((float)(0.6f * ageInTicks));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(fishRotation));
            if (fishType == FishType.LONGNOSE) {
                matrixStack.m_85837_(0.0, 0.0, (double)-0.4f);
            }
            if (!fishEntity.m_20069_() && fishType != FishType.HALIBUT) {
                if (fishType == FishType.MEDIUM || fishType == FishType.LARGE || fishType == FishType.CATFISH) {
                    matrixStack.m_85837_((double)0.1f, (double)0.1f, (double)-0.1f);
                } else {
                    matrixStack.m_85837_((double)0.2f, (double)0.1f, 0.0);
                }
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
            }
            if (fishType == FishType.HALIBUT) {
                matrixStack.m_85837_((double)-0.4f, (double)0.1f, 0.0);
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(-90.0f));
            }
        }
    }

    protected void scale(AquaFishEntity fishEntity, @Nonnull PoseStack matrixStack, float partialTickTime) {
        ResourceLocation location = fishEntity.m_6095_().getRegistryName();
        float scale = 0.0f;
        if (location != null) {
            switch (location.m_135815_()) {
                case "minnow": {
                    scale = 0.5f;
                    break;
                }
                case "synodontis": {
                    scale = 0.8f;
                    break;
                }
                case "brown_trout": 
                case "piranha": {
                    scale = 0.9f;
                    break;
                }
                case "pollock": {
                    scale = 1.1f;
                    break;
                }
                case "atlantic_cod": 
                case "blackfish": 
                case "catfish": 
                case "tambaqui": {
                    scale = 1.2f;
                    break;
                }
                case "pacific_halibut": 
                case "atlantic_halibut": 
                case "capitaine": 
                case "largemouth_bass": 
                case "gar": 
                case "arapaima": 
                case "tuna": {
                    scale = 1.4f;
                }
            }
        }
        if (scale > 0.0f) {
            matrixStack.m_85836_();
            matrixStack.m_85841_(scale, scale, scale);
            matrixStack.m_85849_();
        }
    }
}

