/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.beaconpotion;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.beaconpotion.ContainerPotion;
import com.lothrazar.cyclic.capabilities.CustomEnergyStorage;
import com.lothrazar.cyclic.data.EntityFilterType;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TilePotion
extends TileBlockEntityCyclic
implements MenuProvider {
    static final int MAX = 64000;
    private static final int TICKS_FIRE_PER = 60;
    static final int TICKS_PER_DURATION = 160000;
    private static final int POTION_TICKS = 400;
    private static final int MAX_RADIUS = 64;
    private int radius = 64;
    public static ForgeConfigSpec.IntValue POWERCONF;
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private List<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();
    EntityFilterType entityFilter = EntityFilterType.PLAYERS;
    ItemStackHandler inventory = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            List newEffects = PotionUtils.m_43547_((ItemStack)stack);
            return newEffects.size() > 0;
        }
    };
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public TilePotion(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.BEACON.get(), pos, state);
        this.timer = 0;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TilePotion e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TilePotion e) {
        e.tick();
    }

    public void tick() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        if (this.effects.size() == 0) {
            this.timer = 0;
        }
        int cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            return;
        }
        this.energy.extractEnergy(cost, false);
        --this.timer;
        if (this.timer > 0) {
            this.tryAffectEntities(cost);
            return;
        }
        this.effects.clear();
        ItemStack s = this.inventory.getStackInSlot(0);
        if (s.m_41619_()) {
            return;
        }
        List newEffects = PotionUtils.m_43547_((ItemStack)s);
        if (newEffects.size() > 0) {
            this.pullFromItem(newEffects);
        }
    }

    public Component m_5446_() {
        return new TextComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerPotion(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.radius = tag.m_128451_("radius");
        this.entityFilter = EntityFilterType.values()[tag.m_128451_("entityFilter")];
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        if (tag.m_128425_("Effects", 9)) {
            ListTag listnbt = tag.m_128437_("Effects", 10);
            this.effects.clear();
            for (int i = 0; i < listnbt.size(); ++i) {
                MobEffectInstance effectinstance = MobEffectInstance.m_19560_((CompoundTag)listnbt.m_128728_(i));
                if (effectinstance == null) continue;
                this.effects.add(effectinstance);
            }
        }
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("radius", this.radius);
        tag.m_128405_("entityFilter", this.entityFilter.ordinal());
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        if (!this.effects.isEmpty()) {
            ListTag listnbt = new ListTag();
            for (MobEffectInstance effectinstance : this.effects) {
                listnbt.add((Object)effectinstance.m_19555_(new CompoundTag()));
            }
            tag.m_128365_("Effects", (Tag)listnbt);
        }
        super.m_183515_(tag);
    }

    private void pullFromItem(List<MobEffectInstance> newEffects) {
        this.timer = 160000;
        this.setLitProperty(true);
        int maxDur = 0;
        for (MobEffectInstance eff : newEffects) {
            if (!this.isPotionValid(eff)) continue;
            this.effects.add(new MobEffectInstance(eff.m_19544_(), 400, eff.m_19564_(), true, false));
            maxDur = Math.max(eff.m_19557_(), maxDur);
        }
        this.inventory.extractItem(0, 1, false);
    }

    private void tryAffectEntities(int repair) {
        int affected;
        if (this.timer % 60 == 0 && this.effects.size() > 0 && this.energy.getEnergyStored() >= repair && (affected = this.affectEntities()) > 0) {
            this.energy.extractEnergy(repair, false);
        }
    }

    private int affectEntities() {
        boolean showParticles = false;
        int affecdted = 0;
        List<? extends LivingEntity> list = this.entityFilter.getEntities(this.f_58857_, this.f_58858_, this.radius);
        for (LivingEntity livingEntity : list) {
            if (livingEntity == null) continue;
            for (MobEffectInstance eff : this.effects) {
                ++affecdted;
                if (livingEntity.m_21023_(eff.m_19544_())) {
                    livingEntity.m_21124_(eff.m_19544_()).m_19558_(eff);
                    continue;
                }
                livingEntity.m_7292_(new MobEffectInstance(eff.m_19544_(), 400, eff.m_19564_(), true, showParticles));
            }
        }
        return affecdted;
    }

    private boolean isPotionValid(MobEffectInstance eff) {
        return eff.m_19544_().m_19486_() && !eff.m_19544_().m_8093_();
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.timer;
            }
            case ENTITYTYPE: {
                return this.entityFilter.ordinal();
            }
            case RANGE: {
                return this.radius;
            }
        }
        return -1;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TIMER: {
                this.timer = value;
                break;
            }
            case ENTITYTYPE: {
                this.entityFilter = EntityFilterType.values()[value %= EntityFilterType.values().length];
                break;
            }
            case RANGE: {
                this.radius = value > 64 ? 64 : Math.min(value, 64);
            }
        }
    }

    public List<String> getPotionDisplay() {
        ArrayList<String> list = new ArrayList<String>();
        for (MobEffectInstance eff : this.effects) {
            list.add(eff.m_19576_());
        }
        return list;
    }

    public String getTimerDisplay() {
        if (this.effects.size() == 0) {
            return "cyclic.gui.empty";
        }
        return this.getTimerSeconds() + " seconds";
    }

    private int getTimerSeconds() {
        return this.timer / 20;
    }

    static enum Fields {
        TIMER,
        REDSTONE,
        RANGE,
        ENTITYTYPE;

    }
}

