/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.cable.fluid;

import com.google.common.collect.Maps;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.cable.CableBase;
import com.lothrazar.cyclic.block.cable.EnumConnectType;
import com.lothrazar.cyclic.block.cable.fluid.ContainerCableFluid;
import com.lothrazar.cyclic.capabilities.FluidTankBase;
import com.lothrazar.cyclic.item.datacard.filter.FilterCardItem;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilFluid;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileCableFluid
extends TileBlockEntityCyclic
implements MenuProvider {
    public static ForgeConfigSpec.IntValue BUFFERSIZE;
    public static ForgeConfigSpec.IntValue TRANSFER_RATE;
    final ItemStackHandler filter = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_41720_() == ItemRegistry.FILTER_DATA.get();
        }
    };
    private Map<Direction, LazyOptional<FluidTankBase>> flow = Maps.newHashMap();
    List<Integer> rawList = IntStream.rangeClosed(0, 5).boxed().collect(Collectors.toList());

    public TileCableFluid(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.FLUID_PIPE.get(), pos, state);
        for (Direction f : Direction.values()) {
            this.flow.put(f, (LazyOptional<FluidTankBase>)LazyOptional.of(() -> new FluidTankBase(this, (Integer)BUFFERSIZE.get() * 1000, p -> true)));
        }
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileCableFluid e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileCableFluid e) {
        e.tick();
    }

    public void tick() {
        for (Direction side : Direction.values()) {
            EnumConnectType connection = (EnumConnectType)((Object)this.m_58900_().m_61143_((Property)CableBase.FACING_TO_PROPERTY_MAP.get(side)));
            if (!connection.isExtraction()) continue;
            this.tryExtract(side);
        }
        this.normalFlow();
    }

    private void tryExtract(Direction extractSide) {
        Direction incomingSide;
        if (extractSide == null) {
            return;
        }
        BlockPos target = this.f_58858_.m_142300_(extractSide);
        IFluidHandler stuff = UtilFluid.getTank(this.f_58857_, target, incomingSide = extractSide.m_122424_());
        if (stuff != null && stuff.getTanks() > 0 && !FilterCardItem.filterAllowsExtract(this.filter.getStackInSlot(0), stuff.getFluidInTank(0))) {
            return;
        }
        boolean success = UtilFluid.tryFillPositionFromTank(this.f_58857_, this.f_58858_, extractSide, stuff, (Integer)TRANSFER_RATE.get());
        if (success) {
            return;
        }
        FluidTankBase tank = (FluidTankBase)((Object)this.flow.get(extractSide).orElse(null));
        if (tank != null && tank.getSpace() >= 1000) {
            UtilFluid.extractSourceWaterloggedCauldron(this.f_58857_, target, (IFluidHandler)tank);
        }
    }

    private void normalFlow() {
        for (Direction incomingSide : Direction.values()) {
            IFluidHandler sideHandler = (IFluidHandler)this.flow.get(incomingSide).orElse(null);
            Collections.shuffle(this.rawList);
            for (Integer i : this.rawList) {
                EnumConnectType connection;
                Direction outgoingSide = Direction.values()[i];
                if (outgoingSide == incomingSide || (connection = (EnumConnectType)((Object)this.m_58900_().m_61143_((Property)CableBase.FACING_TO_PROPERTY_MAP.get(outgoingSide)))).isExtraction() || connection.isBlocked()) continue;
                this.moveFluids(outgoingSide, this.f_58858_.m_142300_(outgoingSide), (Integer)TRANSFER_RATE.get(), sideHandler);
            }
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (side != null && cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && !CableBase.isCableBlocked(this.m_58900_(), side)) {
            return this.flow.get(side).cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.filter.deserializeNBT(tag.m_128469_("filter"));
        for (Direction dir : Direction.values()) {
            FluidTankBase fluidh = (FluidTankBase)((Object)this.flow.get(dir).orElse(null));
            if (!tag.m_128441_("fluid" + dir.toString())) continue;
            fluidh.readFromNBT(tag.m_128469_("fluid" + dir.toString()));
        }
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("filter", (Tag)this.filter.serializeNBT());
        for (Direction dir : Direction.values()) {
            FluidTankBase fluidh = (FluidTankBase)((Object)this.flow.get(dir).orElse(null));
            CompoundTag fluidtag = new CompoundTag();
            if (fluidh != null) {
                fluidh.writeToNBT(fluidtag);
            }
            tag.m_128365_("fluid" + dir.toString(), (Tag)fluidtag);
        }
        super.m_183515_(tag);
    }

    @Override
    public void setField(int field, int value) {
    }

    @Override
    public int getField(int field) {
        return 0;
    }

    public Component m_5446_() {
        return new TextComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerCableFluid(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }
}

