/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.clock;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.clock.BlockRedstoneClock;
import com.lothrazar.cyclic.block.clock.ContainerClock;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TileRedstoneClock
extends TileBlockEntityCyclic
implements MenuProvider {
    private int delay;
    private int duration;
    private int power;
    private Map<Direction, Boolean> poweredSides = new HashMap<Direction, Boolean>();

    public TileRedstoneClock(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.CLOCK.get(), pos, state);
        this.timer = 0;
        this.delay = 60;
        this.duration = 60;
        this.power = 15;
        this.needsRedstone = 0;
        this.facingResetAllOn();
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileRedstoneClock e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileRedstoneClock e) {
    }

    public void tick() {
        try {
            this.updateMyState();
        }
        catch (Throwable e) {
            ModCyclic.LOGGER.error("Clock blockstate update error", e);
        }
    }

    private void facingResetAllOn() {
        for (Direction f : Direction.values()) {
            this.poweredSides.put(f, true);
        }
    }

    public int getPower() {
        return this.power;
    }

    public int getPowerForSide(Direction side) {
        if (this.getSideHasPower(side)) {
            return this.power;
        }
        return 0;
    }

    public boolean getSideHasPower(Direction side) {
        return this.poweredSides.get(side);
    }

    public int getSideField(Direction side) {
        return this.getSideHasPower(side) ? 1 : 0;
    }

    public void setSideField(Direction side, int pow) {
        this.poweredSides.put(side, pow == 1);
    }

    private boolean detectAllOff() {
        boolean areAnyOn = false;
        for (Direction f : Direction.values()) {
            areAnyOn = areAnyOn || this.poweredSides.get(f) != false;
        }
        return !areAnyOn;
    }

    public Component m_5446_() {
        return new TextComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerClock(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.delay = tag.m_128451_("redstone_delay");
        this.duration = tag.m_128451_("redstone_duration");
        this.power = tag.m_128451_("redstone_power");
        for (Direction f : Direction.values()) {
            this.poweredSides.put(f, tag.m_128471_(f.m_122433_()));
        }
        if (this.detectAllOff()) {
            this.facingResetAllOn();
        }
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("redstone_delay", this.delay);
        tag.m_128405_("redstone_duration", this.duration);
        tag.m_128405_("redstone_power", this.power);
        for (Direction f : Direction.values()) {
            tag.m_128379_(f.m_122433_(), this.poweredSides.get(f).booleanValue());
        }
        super.m_183515_(tag);
    }

    private void updateMyState() throws IllegalArgumentException {
        boolean powered;
        BlockState blockState = this.f_58857_.m_8055_(this.f_58858_);
        if (!blockState.m_61138_((Property)BlockRedstoneClock.LIT)) {
            return;
        }
        if (this.power == 0) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)blockState.m_61124_((Property)BlockRedstoneClock.LIT, (Comparable)Boolean.valueOf(false)));
            return;
        }
        ++this.timer;
        boolean prevPowered = (Boolean)blockState.m_61143_((Property)BlockRedstoneClock.LIT);
        if (this.timer < this.delay) {
            powered = false;
        } else if (this.timer < this.delay + this.duration) {
            powered = true;
        } else {
            this.timer = 0;
            powered = false;
        }
        if (prevPowered != powered) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)blockState.m_61124_((Property)BlockRedstoneClock.LIT, (Comparable)Boolean.valueOf(powered)));
        }
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case POWER: {
                return this.power;
            }
            case TIMER: {
                return this.timer;
            }
            case DELAY: {
                return this.delay;
            }
            case DURATION: {
                return this.duration;
            }
            case REDSTONE: {
                return this.needsRedstone;
            }
            case D: {
                return this.getSideField(Direction.DOWN);
            }
            case E: {
                return this.getSideField(Direction.EAST);
            }
            case N: {
                return this.getSideField(Direction.NORTH);
            }
            case S: {
                return this.getSideField(Direction.SOUTH);
            }
            case U: {
                return this.getSideField(Direction.UP);
            }
            case W: {
                return this.getSideField(Direction.WEST);
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (Fields.values()[id]) {
            case POWER: {
                if (value < 0) {
                    value = 0;
                }
                if (value > 15) {
                    value = 15;
                }
                this.power = value;
                break;
            }
            case TIMER: {
                this.timer = value;
                break;
            }
            case DELAY: {
                this.delay = Math.max(value, 1);
                break;
            }
            case DURATION: {
                this.duration = Math.max(value, 1);
                break;
            }
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case D: {
                this.setSideField(Direction.DOWN, value % 2);
                break;
            }
            case E: {
                this.setSideField(Direction.EAST, value % 2);
                break;
            }
            case N: {
                this.setSideField(Direction.NORTH, value % 2);
                break;
            }
            case S: {
                this.setSideField(Direction.SOUTH, value % 2);
                break;
            }
            case U: {
                this.setSideField(Direction.UP, value % 2);
                break;
            }
            case W: {
                this.setSideField(Direction.WEST, value % 2);
            }
        }
    }

    static enum Fields {
        TIMER,
        DELAY,
        DURATION,
        POWER,
        REDSTONE,
        N,
        E,
        S,
        W,
        U,
        D;

    }
}

