/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.crusher;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.crusher.ContainerCrusher;
import com.lothrazar.cyclic.block.crusher.RecipeCrusher;
import com.lothrazar.cyclic.capabilities.CustomEnergyStorage;
import com.lothrazar.cyclic.capabilities.ItemStackHandlerWrapper;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileCrusher
extends TileBlockEntityCyclic
implements MenuProvider {
    static final int MAX = 64000;
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    ItemStackHandler inputSlots = new ItemStackHandler(1);
    ItemStackHandler outputSlots = new ItemStackHandler(2);
    private ItemStackHandlerWrapper inventory = new ItemStackHandlerWrapper(this.inputSlots, this.outputSlots);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private int burnTimeMax = 0;
    private int burnTime = 0;
    private RecipeCrusher<?> currentRecipe;

    public TileCrusher(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.CRUSHER.get(), pos, state);
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileCrusher tileAnvilAuto) {
        tileAnvilAuto.tick();
    }

    public static <E extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileCrusher e) {
        e.tick();
    }

    public Component m_5446_() {
        return new TextComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerCrusher(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        this.burnTime = tag.m_128451_("burnTime");
        this.burnTimeMax = tag.m_128451_("burnTimeMax");
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("burnTime", this.burnTime);
        tag.m_128405_("burnTimeMax", this.burnTimeMax);
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    public void tick() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.burnTime <= 0 && this.currentRecipe != null) {
            this.burnTimeMax = 0;
            this.burnTime = 0;
            if (!this.currentRecipe.m_8043_().m_41619_()) {
                this.outputSlots.insertItem(0, this.currentRecipe.m_8043_().m_41777_(), false);
            }
            if (!(this.currentRecipe.bonus.m_41619_() || this.currentRecipe.percent <= 0 || this.currentRecipe.percent != 1 && this.f_58857_.f_46441_.nextInt(100) >= this.currentRecipe.percent)) {
                this.outputSlots.insertItem(1, this.currentRecipe.createBonus(this.f_58857_.f_46441_), false);
            }
            this.f_58857_.m_5898_((Player)null, 1042, this.f_58858_, 0);
            this.currentRecipe = null;
        }
        if (this.burnTime <= 0 && this.burnTimeMax == 0) {
            this.findMatchingRecipe();
        }
        if (this.currentRecipe == null) {
            this.findMatchingRecipe();
            return;
        }
        if (this.burnTimeMax > 0) {
            this.setLitProperty(true);
            int onSim = this.energy.extractEnergy(this.currentRecipe.energy.getRfPertick(), true);
            if (onSim >= this.currentRecipe.energy.getRfPertick()) {
                this.energy.extractEnergy(this.currentRecipe.energy.getRfPertick(), false);
                --this.burnTime;
            }
        }
    }

    private void findMatchingRecipe() {
        if (this.currentRecipe != null && this.currentRecipe.matches(this, this.f_58857_)) {
            return;
        }
        this.currentRecipe = null;
        List recipes = this.f_58857_.m_7465_().m_44013_(CyclicRecipeType.CRUSHER);
        for (RecipeCrusher rec : recipes) {
            if (!rec.matches(this, this.f_58857_)) continue;
            this.currentRecipe = rec;
            this.burnTime = this.burnTimeMax = this.currentRecipe.energy.getTicks();
            this.inputSlots.extractItem(0, 1, false);
            return;
        }
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.burnTime;
            }
            case TIMERMAX: {
                return this.burnTimeMax;
            }
        }
        return 0;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TIMER: {
                this.burnTime = value;
                break;
            }
            case TIMERMAX: {
                this.burnTimeMax = value;
            }
        }
    }

    static enum Fields {
        TIMER,
        REDSTONE,
        TIMERMAX;

    }
}

