/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.generatoritem;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.generatoritem.TileGeneratorDrops;
import com.lothrazar.cyclic.recipe.CyclicRecipe;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.recipe.ingredient.EnergyIngredient;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeGeneratorItem<TileEntityBase>
extends CyclicRecipe {
    private NonNullList<Ingredient> ingredients = NonNullList.m_122779_();
    private final EnergyIngredient energy;
    public static final SerializeGenerateItem SERIALGENERATOR = new SerializeGenerateItem();

    public RecipeGeneratorItem(ResourceLocation id, Ingredient in, EnergyIngredient energy) {
        super(id);
        this.ingredients.add((Object)in);
        this.energy = energy;
    }

    public boolean matches(TileBlockEntityCyclic inv, Level worldIn) {
        try {
            TileGeneratorDrops tile = (TileGeneratorDrops)inv;
            return this.matches(tile.inputSlots.getStackInSlot(0), (Ingredient)this.ingredients.get(0));
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean matches(ItemStack current, Ingredient ing) {
        if (ing == Ingredient.f_43901_) {
            return current.m_41619_();
        }
        if (current.m_41619_()) {
            return ing == Ingredient.f_43901_;
        }
        return ing.test(current);
    }

    public ItemStack[] ingredientAt(int slot) {
        Ingredient ing = (Ingredient)this.ingredients.get(slot);
        return ing.m_43908_();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    @Override
    public ItemStack m_8043_() {
        return ItemStack.f_41583_;
    }

    public RecipeType<?> m_6671_() {
        return CyclicRecipeType.GENERATOR_ITEM;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return SERIALGENERATOR;
    }

    public int getTicks() {
        return this.energy.getTicks();
    }

    public int getRfPertick() {
        return this.energy.getRfPertick();
    }

    public int getEnergyTotal() {
        return this.getRfPertick() * this.getTicks();
    }

    public static class SerializeGenerateItem
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<RecipeGeneratorItem<? extends TileBlockEntityCyclic>> {
        SerializeGenerateItem() {
            this.setRegistryName(new ResourceLocation("cyclic", "generator_item"));
        }

        public RecipeGeneratorItem<? extends TileBlockEntityCyclic> fromJson(ResourceLocation recipeId, JsonObject json) {
            RecipeGeneratorItem r = null;
            try {
                Ingredient inputFirst = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"fuel"));
                r = new RecipeGeneratorItem(recipeId, inputFirst, new EnergyIngredient(json));
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Error loading recipe " + recipeId, e);
            }
            return r;
        }

        public RecipeGeneratorItem fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            RecipeGeneratorItem r = new RecipeGeneratorItem(recipeId, Ingredient.m_43940_((FriendlyByteBuf)buffer), new EnergyIngredient(buffer.readInt(), buffer.readInt()));
            return r;
        }

        public void toNetwork(FriendlyByteBuf buffer, RecipeGeneratorItem recipe) {
            Ingredient zero = (Ingredient)recipe.ingredients.get(0);
            zero.m_43923_(buffer);
            buffer.writeInt(recipe.energy.getTicks());
            buffer.writeInt(recipe.energy.getRfPertick());
        }
    }
}

