/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.generatoritem;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.generatoritem.ContainerGeneratorDrops;
import com.lothrazar.cyclic.block.generatoritem.RecipeGeneratorItem;
import com.lothrazar.cyclic.capabilities.CustomEnergyStorage;
import com.lothrazar.cyclic.capabilities.ItemStackHandlerWrapper;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileGeneratorDrops
extends TileBlockEntityCyclic
implements MenuProvider {
    static final int MAX = 640000;
    CustomEnergyStorage energy = new CustomEnergyStorage(640000, 640000);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    ItemStackHandler inputSlots = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return true;
        }
    };
    ItemStackHandler outputSlots = new ItemStackHandler(0);
    private ItemStackHandlerWrapper inventory = new ItemStackHandlerWrapper(this.inputSlots, this.outputSlots);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private int burnTimeMax = 0;
    private int burnTime = 0;
    private int burnPerTick;
    private RecipeGeneratorItem<?> currentRecipe;

    public TileGeneratorDrops(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.GENERATOR_ITEM.get(), pos, state);
        this.needsRedstone = 0;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileGeneratorDrops e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileGeneratorDrops e) {
        e.tick();
    }

    public void tick() {
        this.syncEnergy();
        if (this.flowing == 1) {
            this.exportEnergyAllSides();
        }
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        if (this.burnTime == 0) {
            this.setLitProperty(false);
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.burnTime <= 0) {
            this.currentRecipe = null;
            this.burnTimeMax = 0;
            this.burnTime = 0;
        }
        if (this.burnTimeMax == 0) {
            this.findMatchingRecipe();
        }
        if (this.burnPerTick == 0 || this.burnTime == 0 || this.currentRecipe == null) {
            return;
        }
        this.setLitProperty(true);
        int onSim = this.energy.receiveEnergy(this.burnPerTick, true);
        if (onSim > 0) {
            --this.burnTime;
            this.energy.receiveEnergy(this.burnPerTick, false);
        }
    }

    private void findMatchingRecipe() {
        if (this.currentRecipe != null && this.currentRecipe.matches(this, this.f_58857_)) {
            return;
        }
        this.currentRecipe = null;
        List recipes = this.f_58857_.m_7465_().m_44013_(CyclicRecipeType.GENERATOR_ITEM);
        for (RecipeGeneratorItem rec : recipes) {
            if (!rec.matches(this, this.f_58857_)) continue;
            this.burnTime = this.burnTimeMax = rec.getTicks();
            this.burnPerTick = rec.getRfPertick();
            this.currentRecipe = rec;
            boolean slot = false;
            boolean qty = true;
            this.inputSlots.extractItem(0, 1, false);
            return;
        }
    }

    public Component m_5446_() {
        return new TextComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerGeneratorDrops(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        this.burnTime = tag.m_128451_("burnTime");
        this.burnTimeMax = tag.m_128451_("burnTimeMax");
        this.burnPerTick = tag.m_128451_("burnPerTick");
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        tag.m_128405_("burnTime", this.burnTime);
        tag.m_128405_("burnTimeMax", this.burnTimeMax);
        tag.m_128405_("burnPerTick", this.burnPerTick);
        super.m_183515_(tag);
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case TIMER: {
                return this.burnTime;
            }
            case BURNMAX: {
                return this.burnTimeMax;
            }
            case FLOWING: {
                return this.flowing;
            }
        }
        return 0;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case TIMER: {
                this.burnTime = value;
                break;
            }
            case BURNMAX: {
                this.burnTimeMax = value;
                break;
            }
            case FLOWING: {
                this.flowing = value;
            }
        }
    }

    public int getEnergyMax() {
        return 640000;
    }

    static enum Fields {
        TIMER,
        REDSTONE,
        BURNMAX,
        FLOWING;

    }
}

