/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.generatorsolar;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.generatorsolar.BlockGeneratorSolar;
import com.lothrazar.cyclic.capabilities.CustomEnergyStorage;
import com.lothrazar.cyclic.capabilities.ItemStackHandlerWrapper;
import com.lothrazar.cyclic.registry.TileRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileGeneratorSolar
extends TileBlockEntityCyclic {
    static final int MAX = 64000;
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    ItemStackHandler inputSlots = new ItemStackHandler(1);
    ItemStackHandler outputSlots = new ItemStackHandler(0);
    private ItemStackHandlerWrapper inventory = new ItemStackHandlerWrapper(this.inputSlots, this.outputSlots);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public TileGeneratorSolar(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.GENERATOR_SOLAR.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileGeneratorSolar e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileGeneratorSolar e) {
        e.tick();
    }

    public void tick() {
        this.syncEnergy();
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.moveEnergy(Direction.DOWN, 100);
        --this.timer;
        if (this.timer == 0 || (Integer)BlockGeneratorSolar.TIMEOUT.get() == 0) {
            this.tryConsumeFuel();
        }
        if (this.timer <= 0) {
            this.timer = (Integer)BlockGeneratorSolar.TIMEOUT.get();
        }
    }

    private void tryConsumeFuel() {
        if (this.f_58857_.m_46461_() && this.f_58857_.m_46861_(this.m_58899_())) {
            this.setLitProperty(true);
            int receive = (Integer)BlockGeneratorSolar.ENERGY_GENERATE.get();
            if (this.f_58857_.m_46470_()) {
                receive /= 4;
            } else if (this.f_58857_.m_46471_()) {
                receive /= 2;
            }
            if (receive < 1) {
                receive = 1;
            }
            if (this.energy.receiveEnergy(receive, true) == receive) {
                this.energy.receiveEnergy(receive, false);
            }
        } else {
            this.setLitProperty(false);
        }
    }

    public void invalidateCaps() {
        this.energyCap.invalidate();
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && side == Direction.DOWN) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case FLOWING: {
                return this.flowing;
            }
        }
        return 0;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case FLOWING: {
                this.flowing = value;
            }
        }
    }

    public int getEnergyMax() {
        return 64000;
    }

    static enum Fields {
        REDSTONE,
        FLOWING;

    }
}

