/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.placerfluid;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.placerfluid.ContainerPlacerFluid;
import com.lothrazar.cyclic.capabilities.FluidTankBase;
import com.lothrazar.cyclic.registry.TileRegistry;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TilePlacerFluid
extends TileBlockEntityCyclic
implements MenuProvider {
    public static final int CAPACITY = 8000;
    FluidTankBase tank = new FluidTankBase(this, 8000, this.isFluidValid());
    LazyOptional<FluidTankBase> fluidCap = LazyOptional.of(() -> this.tank);

    public TilePlacerFluid(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.PLACER_FLUID.get(), pos, state);
        this.needsRedstone = 1;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TilePlacerFluid e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TilePlacerFluid e) {
        e.tick();
    }

    public void tick() {
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        this.setLitProperty(true);
        FluidStack test = this.tank.drain(1000, IFluidHandler.FluidAction.SIMULATE);
        if (test.getAmount() == 1000 && test.getFluid().m_76145_() != null && test.getFluid().m_76145_().m_76188_() != null) {
            Direction dir = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_);
            BlockPos offset = this.f_58858_.m_142300_(dir);
            BlockState state = test.getFluid().m_76145_().m_76188_();
            if (this.f_58857_.m_46859_(offset) && this.f_58857_.m_46597_(offset, state)) {
                this.tank.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    public Predicate<FluidStack> isFluidValid() {
        return p -> true;
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.tank.setFluid(fluid);
    }

    @Override
    public FluidStack getFluid() {
        return this.tank == null ? FluidStack.EMPTY : this.tank.getFluid();
    }

    public Component m_5446_() {
        return new TextComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerPlacerFluid(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.fluidCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.tank.readFromNBT(tag.m_128469_("fluid"));
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        CompoundTag fluid = new CompoundTag();
        this.tank.writeToNBT(fluid);
        tag.m_128365_("fluid", (Tag)fluid);
        super.m_183515_(tag);
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
        }
        return 0;
    }

    @Override
    public void setField(int id, int value) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % 2;
            }
        }
    }

    static enum Fields {
        REDSTONE,
        RENDER;

    }
}

