/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.solidifier;

import com.google.gson.JsonObject;
import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.solidifier.TileSolidifier;
import com.lothrazar.cyclic.recipe.CyclicRecipe;
import com.lothrazar.cyclic.recipe.CyclicRecipeType;
import com.lothrazar.cyclic.recipe.ingredient.EnergyIngredient;
import com.lothrazar.cyclic.recipe.ingredient.FluidTagIngredient;
import com.lothrazar.cyclic.util.UtilRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RecipeSolidifier<TileEntityBase>
extends CyclicRecipe {
    private ItemStack result = ItemStack.f_41583_;
    private NonNullList<Ingredient> ingredients = NonNullList.m_122779_();
    private final EnergyIngredient energy;
    public final FluidTagIngredient fluidIngredient;
    public static final SerializeSolidifier SERIALIZER = new SerializeSolidifier();

    public RecipeSolidifier(ResourceLocation id, NonNullList<Ingredient> inList, FluidTagIngredient fluid, ItemStack result, EnergyIngredient energy) {
        super(id);
        this.energy = energy;
        this.ingredients = inList;
        if (this.ingredients.size() == 2) {
            this.ingredients.add((Object)Ingredient.f_43901_);
        } else if (this.ingredients.size() == 1) {
            this.ingredients.add((Object)Ingredient.f_43901_);
            this.ingredients.add((Object)Ingredient.f_43901_);
        }
        if (this.ingredients.size() != 3) {
            throw new IllegalArgumentException("Solidifier recipe must have at most three ingredients");
        }
        this.fluidIngredient = fluid;
        this.result = result;
    }

    @Override
    public FluidStack getRecipeFluid() {
        return this.fluidIngredient.getFluidStack();
    }

    public EnergyIngredient getEnergy() {
        return this.energy;
    }

    public boolean matches(TileBlockEntityCyclic inv, Level worldIn) {
        try {
            TileSolidifier tile = (TileSolidifier)inv;
            return this.matchItems(tile) && CyclicRecipe.matchFluid(tile.getFluid(), this.fluidIngredient);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private int findMatchingSlot(TileSolidifier tile, Ingredient shapeless, List<Integer> skip) {
        for (int i = 0; i < 3; ++i) {
            if (skip.contains(i) || !shapeless.test(tile.getStackInputSlot(i))) continue;
            return i;
        }
        return -1;
    }

    private boolean matchItems(TileSolidifier tile) {
        Ingredient top = (Ingredient)this.ingredients.get(0);
        Ingredient middle = (Ingredient)this.ingredients.get(1);
        Ingredient bottom = (Ingredient)this.ingredients.get(2);
        ArrayList<Integer> matchingSlots = new ArrayList<Integer>();
        matchingSlots.add(this.findMatchingSlot(tile, top, matchingSlots));
        matchingSlots.add(this.findMatchingSlot(tile, middle, matchingSlots));
        matchingSlots.add(this.findMatchingSlot(tile, bottom, matchingSlots));
        if (matchingSlots.contains(-1)) {
            return false;
        }
        return matchingSlots.contains(0) && matchingSlots.contains(1) && matchingSlots.contains(2);
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public ItemStack[] ingredientAt(int slot) {
        Ingredient ing = (Ingredient)this.ingredients.get(slot);
        return ing.m_43908_();
    }

    @Override
    public ItemStack m_8043_() {
        return this.result.m_41777_();
    }

    public RecipeType<?> m_6671_() {
        return CyclicRecipeType.SOLID;
    }

    @Override
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public static class SerializeSolidifier
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<RecipeSolidifier<? extends TileBlockEntityCyclic>> {
        SerializeSolidifier() {
            this.setRegistryName(new ResourceLocation("cyclic", "solidifier"));
        }

        public RecipeSolidifier<? extends TileBlockEntityCyclic> fromJson(ResourceLocation recipeId, JsonObject json) {
            RecipeSolidifier r = null;
            try {
                NonNullList<Ingredient> list = UtilRecipe.getIngredientsArray(json);
                ItemStack resultStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
                FluidTagIngredient fs = CyclicRecipe.parseFluid(json, "mix");
                r = new RecipeSolidifier(recipeId, list, fs, resultStack, new EnergyIngredient(json));
            }
            catch (Exception e) {
                ModCyclic.LOGGER.error("Error loading recipe " + recipeId, e);
            }
            return r;
        }

        public RecipeSolidifier fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buf) {
            NonNullList ins = NonNullList.m_122779_();
            ins.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            ins.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            ins.add((Object)Ingredient.m_43940_((FriendlyByteBuf)buf));
            FluidTagIngredient fsi = FluidTagIngredient.readFromPacket(buf);
            RecipeSolidifier r = new RecipeSolidifier(recipeId, (NonNullList<Ingredient>)ins, fsi, buf.m_130267_(), new EnergyIngredient(buf.readInt(), buf.readInt()));
            return r;
        }

        public void toNetwork(FriendlyByteBuf buf, RecipeSolidifier recipe) {
            Ingredient zero = (Ingredient)recipe.ingredients.get(0);
            Ingredient one = (Ingredient)recipe.ingredients.get(1);
            Ingredient two = (Ingredient)recipe.ingredients.get(2);
            zero.m_43923_(buf);
            one.m_43923_(buf);
            two.m_43923_(buf);
            recipe.fluidIngredient.writeToPacket(buf);
            buf.m_130055_(recipe.m_8043_());
            buf.writeInt(recipe.energy.getRfPertick());
            buf.writeInt(recipe.energy.getTicks());
        }
    }
}

