/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.soundmuff;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.block.BlockCyclic;
import com.lothrazar.cyclic.block.soundmuff.SoundVolumeControlled;
import com.lothrazar.cyclic.util.UtilBlockstates;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SoundmufflerBlock
extends BlockCyclic {
    private static final int VOL_REDUCE_PER_BLOCK = 2;
    private static final int RADIUS = 6;

    public SoundmufflerBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(1.0f).m_60918_(SoundType.f_56756_));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onPlaySound(PlaySoundEvent event) {
        ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
        if (event.getSound() == null || event.getSound() instanceof TickableSoundInstance || clientWorld == null) {
            return;
        }
        SoundInstance sound = event.getSound();
        ArrayList<BlockPos> blocks = UtilBlockstates.findBlocks((Level)clientWorld, new BlockPos(sound.m_7772_(), sound.m_7780_(), sound.m_7778_()), (Block)this, 6);
        if (blocks == null || blocks.size() == 0) {
            return;
        }
        try {
            SoundVolumeControlled newSound = new SoundVolumeControlled(sound);
            float pct = 0.33333334f;
            newSound.setVolume((float)(Math.min((double)pct, 1.0) / (double)blocks.size()));
            event.setSound((SoundInstance)newSound);
        }
        catch (Exception e) {
            ModCyclic.LOGGER.error("Error trying to detect volume of sound " + sound, e);
        }
    }
}

