/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.uncrafter;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.uncrafter.ContainerUncraft;
import com.lothrazar.cyclic.block.uncrafter.UncraftStatusEnum;
import com.lothrazar.cyclic.capabilities.CustomEnergyStorage;
import com.lothrazar.cyclic.capabilities.ItemStackHandlerWrapper;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilString;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileUncraft
extends TileBlockEntityCyclic
implements MenuProvider {
    static final int MAX = 64000;
    public static ForgeConfigSpec.IntValue POWERCONF;
    public static ForgeConfigSpec.BooleanValue IGNORE_NBT;
    public static ForgeConfigSpec.ConfigValue<Integer> TIMER;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> IGNORELIST;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> IGNORELIST_RECIPES;
    CustomEnergyStorage energy = new CustomEnergyStorage(64000, 64000);
    ItemStackHandler inputSlots = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileUncraft.this.status = UncraftStatusEnum.EMPTY;
        }
    };
    ItemStackHandler outputSlots = new ItemStackHandler(16){

        protected void onContentsChanged(int slot) {
            if (TileUncraft.this.status == UncraftStatusEnum.NOROOM) {
                TileUncraft.this.status = UncraftStatusEnum.EMPTY;
            }
        }
    };
    private ItemStackHandlerWrapper inventory = new ItemStackHandlerWrapper(this.inputSlots, this.outputSlots);
    private LazyOptional<IEnergyStorage> energyCap = LazyOptional.of(() -> this.energy);
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);
    private UncraftStatusEnum status = UncraftStatusEnum.EMPTY;

    public TileUncraft(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.UNCRAFTER.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileUncraft e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileUncraft e) {
        e.tick();
    }

    public void tick() {
        this.syncEnergy();
        ItemStack dropMe = this.inputSlots.getStackInSlot(0).m_41777_();
        if (dropMe.m_41619_()) {
            this.status = UncraftStatusEnum.EMPTY;
            this.timer = (Integer)TIMER.get();
            return;
        }
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        int cost = (Integer)POWERCONF.get();
        if (this.energy.getEnergyStored() < cost && cost > 0) {
            return;
        }
        this.setLitProperty(true);
        if (this.status != UncraftStatusEnum.EMPTY && this.status != UncraftStatusEnum.MATCH) {
            this.timer = (Integer)TIMER.get();
            return;
        }
        if (--this.timer > 0) {
            return;
        }
        this.timer = (Integer)TIMER.get();
        if (this.f_58857_.f_46443_ || this.f_58857_.m_142572_() == null) {
            return;
        }
        Recipe<?> match = this.findMatchingRecipe(this.f_58857_, dropMe);
        if (match != null) {
            if (this.uncraftRecipe(match)) {
                this.status = UncraftStatusEnum.MATCH;
                this.inputSlots.extractItem(0, match.m_8043_().m_41613_(), false);
                this.energy.extractEnergy(cost, false);
            }
        } else {
            this.status = UncraftStatusEnum.NORECIPE;
        }
    }

    public UncraftStatusEnum getStatus() {
        return this.status;
    }

    public Component m_5446_() {
        return new TextComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerUncraft(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        this.energyCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY && (Integer)POWERCONF.get() > 0) {
            return this.energyCap.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.energy.deserializeNBT((Tag)tag.m_128469_("energy"));
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        this.status = UncraftStatusEnum.values()[tag.m_128451_("ucstats")];
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("ucstats", this.status.ordinal());
        tag.m_128365_("energy", (Tag)this.energy.serializeNBT());
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        super.m_183515_(tag);
    }

    private boolean uncraftRecipe(Recipe<?> match) {
        int i;
        List result = match.m_7527_().stream().flatMap(ingredient -> Arrays.stream(ingredient.m_43908_()).filter(stack -> !stack.hasContainerItem()).findAny().map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
        if (result.isEmpty()) {
            this.status = UncraftStatusEnum.NORECIPE;
            return false;
        }
        boolean simulate = true;
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            ItemStack r;
            ItemStack rOut = r = (ItemStack)iterator.next();
            for (i = 0; i < this.outputSlots.getSlots(); ++i) {
                if (rOut.m_41619_()) continue;
                rOut = this.outputSlots.insertItem(i, rOut, simulate);
            }
            if (rOut.m_41619_()) continue;
            this.status = UncraftStatusEnum.NOROOM;
            return false;
        }
        simulate = false;
        for (ItemStack r : result) {
            ItemStack forTesting = r.m_41777_();
            for (i = 0; i < this.outputSlots.getSlots() && !forTesting.m_41619_(); ++i) {
                forTesting = this.outputSlots.insertItem(i, forTesting, simulate);
            }
        }
        return true;
    }

    public Recipe<?> findMatchingRecipe(Level world, ItemStack dropMe) {
        Collection list = world.m_142572_().m_129894_().m_44051_();
        for (Recipe recipe : list) {
            if (recipe.m_6671_() != RecipeType.f_44107_ || !this.recipeMatches(dropMe, recipe)) continue;
            return recipe;
        }
        return null;
    }

    private boolean recipeMatches(ItemStack stack, Recipe<?> recipe) {
        if (stack.m_41619_() || recipe == null || recipe.m_8043_().m_41619_() || recipe.m_8043_().m_41613_() > stack.m_41613_()) {
            this.status = UncraftStatusEnum.NORECIPE;
            return false;
        }
        List recipes = (List)IGNORELIST_RECIPES.get();
        if (UtilString.isInList(recipes, recipe.m_6423_())) {
            this.status = UncraftStatusEnum.CONFIG;
            return false;
        }
        if (UtilString.isInList((List)IGNORELIST.get(), stack.m_41720_().getRegistryName())) {
            this.status = UncraftStatusEnum.CONFIG;
            return false;
        }
        boolean matches = false;
        if (((Boolean)IGNORE_NBT.get()).booleanValue()) {
            matches = stack.m_41720_() == recipe.m_8043_().m_41720_();
        } else {
            boolean bl = matches = stack.m_41720_() == recipe.m_8043_().m_41720_() && ItemStack.m_41658_((ItemStack)stack, (ItemStack)recipe.m_8043_());
        }
        if (!matches) {
            this.status = UncraftStatusEnum.NORECIPE;
        }
        return matches;
    }

    @Override
    public int getField(int id) {
        switch (Fields.values()[id]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case STATUS: {
                return this.status.ordinal();
            }
            case TIMER: {
                return this.timer;
            }
        }
        return 0;
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case STATUS: {
                this.status = UncraftStatusEnum.values()[value];
                break;
            }
            case TIMER: {
                this.timer = value;
            }
        }
    }

    static enum Fields {
        REDSTONE,
        STATUS,
        TIMER;

    }
}

