/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.block.wireless.item;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.block.wireless.item.ContainerWirelessItem;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.item.datacard.LocationGpsCard;
import com.lothrazar.cyclic.registry.TileRegistry;
import com.lothrazar.cyclic.util.UtilWorld;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileWirelessItem
extends TileBlockEntityCyclic
implements MenuProvider {
    private int transferRate = 1;
    ItemStackHandler inventory = new ItemStackHandler(1);
    ItemStackHandler gpsSlots = new ItemStackHandler(1){

        public boolean isItemValid(int slot, ItemStack stack) {
            return stack.m_41720_() instanceof LocationGpsCard;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public TileWirelessItem(BlockPos pos, BlockState state) {
        super((BlockEntityType)TileRegistry.WIRELESS_ITEM.get(), pos, state);
        this.needsRedstone = 0;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, TileWirelessItem e) {
        e.tick();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos blockPos, BlockState blockState, TileWirelessItem e) {
        e.tick();
    }

    public Component m_5446_() {
        return new TextComponent(this.m_58903_().getRegistryName().m_135815_());
    }

    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new ContainerWirelessItem(i, this.f_58857_, this.f_58858_, playerInventory, playerEntity);
    }

    public void invalidateCaps() {
        this.inventoryCap.invalidate();
        super.invalidateCaps();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        this.inventory.deserializeNBT(tag.m_128469_("inv"));
        this.gpsSlots.deserializeNBT(tag.m_128469_("invgps"));
        this.transferRate = tag.m_128451_("transferRate");
        super.m_142466_(tag);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128405_("transferRate", this.transferRate);
        tag.m_128365_("inv", (Tag)this.inventory.serializeNBT());
        tag.m_128365_("invgps", (Tag)this.gpsSlots.serializeNBT());
        super.m_183515_(tag);
    }

    public void tick() {
        this.syncEnergy();
        if (this.requiresRedstone() && !this.isPowered()) {
            this.setLitProperty(false);
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        boolean moved = false;
        BlockPosDim loc = this.getTargetInSlot();
        if (loc != null && UtilWorld.dimensionIsEqual(loc, this.f_58857_)) {
            moved = this.moveItems(Direction.UP, loc.getPos(), this.transferRate, (IItemHandler)this.inventory, 0);
        }
        this.setLitProperty(moved);
    }

    BlockPosDim getTargetInSlot() {
        return LocationGpsCard.getPosition(this.gpsSlots.getStackInSlot(0));
    }

    @Override
    public void setField(int field, int value) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                this.needsRedstone = value % 2;
                break;
            }
            case RENDER: {
                this.render = value % 2;
                break;
            }
            case TRANSFER_RATE: {
                this.transferRate = value;
            }
        }
    }

    @Override
    public int getField(int field) {
        switch (Fields.values()[field]) {
            case REDSTONE: {
                return this.needsRedstone;
            }
            case RENDER: {
                return this.render;
            }
            case TRANSFER_RATE: {
                return this.transferRate;
            }
        }
        return 0;
    }

    public float getRed() {
        return 0.89f;
    }

    public float getBlue() {
        return 0.0f;
    }

    public float getGreen() {
        return 0.12f;
    }

    public float getAlpha() {
        return 0.9f;
    }

    public float getThick() {
        return 0.065f;
    }

    static enum Fields {
        RENDER,
        TRANSFER_RATE,
        REDSTONE;

    }
}

