/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.enchant;

import com.lothrazar.cyclic.enchant.EnchantmentCyclic;
import com.lothrazar.cyclic.registry.EnchantRegistry;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class XpEnchant
extends EnchantmentCyclic {
    public static final String ID = "experience_boost";
    public static ForgeConfigSpec.BooleanValue CFG;

    public XpEnchant(Enchantment.Rarity rarityIn, EnchantmentCategory typeIn, EquipmentSlot ... mainhand) {
        super(rarityIn, typeIn, mainhand);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isEnabled() {
        return (Boolean)CFG.get();
    }

    @SubscribeEvent
    public void handleBlockBreakEvent(BlockEvent.BreakEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        int level = this.getCurrentLevelTool(event.getPlayer().m_21205_());
        if (level <= 0) {
            return;
        }
        event.setExpToDrop(event.getExpToDrop() + this.getRandomExpAmount(level, event.getPlayer().f_19853_));
    }

    @SubscribeEvent
    public void handleEntityDropEvent(LivingExperienceDropEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        if (event.getAttackingPlayer() == null) {
            return;
        }
        int level = this.getCurrentLevelTool(event.getAttackingPlayer().m_21205_());
        if (level <= 0) {
            return;
        }
        event.setDroppedExperience(event.getDroppedExperience() + this.getRandomExpAmount(level, event.getAttackingPlayer().f_19853_));
    }

    private int getRandomExpAmount(int level, Level world) {
        return world.f_46441_.nextInt(this.m_6586_()) * (level + 1);
    }

    public boolean m_6081_(ItemStack stack) {
        if (stack.m_41720_() instanceof SwordItem) {
            return true;
        }
        return super.m_6081_(stack);
    }

    public boolean m_5975_(Enchantment ench) {
        return super.m_5975_(ench) && ench != EnchantRegistry.EXCAVATE;
    }

    public int m_6586_() {
        return 3;
    }
}

