/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.event;

import com.lothrazar.cyclic.config.ClientConfigCyclic;
import com.lothrazar.cyclic.data.BlockPosDim;
import com.lothrazar.cyclic.data.CyclicFile;
import com.lothrazar.cyclic.data.RelativeShape;
import com.lothrazar.cyclic.event.PlayerDataEvents;
import com.lothrazar.cyclic.item.OreProspector;
import com.lothrazar.cyclic.item.builder.BuilderActionType;
import com.lothrazar.cyclic.item.builder.BuilderItem;
import com.lothrazar.cyclic.item.builder.PacketSwapBlock;
import com.lothrazar.cyclic.item.datacard.LocationGpsCard;
import com.lothrazar.cyclic.item.datacard.ShapeCard;
import com.lothrazar.cyclic.item.random.RandomizerItem;
import com.lothrazar.cyclic.item.slingshot.LaserItem;
import com.lothrazar.cyclic.net.PacketEntityLaser;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.registry.SoundRegistry;
import com.lothrazar.cyclic.util.RenderMiningLaser;
import com.lothrazar.cyclic.util.UtilPlayer;
import com.lothrazar.cyclic.util.UtilRender;
import com.lothrazar.cyclic.util.UtilSound;
import com.lothrazar.cyclic.util.UtilWorld;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventRender {
    @SubscribeEvent
    public void overlay(RenderGameOverlayEvent.Post event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Minecraft mc = Minecraft.m_91087_();
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            BlockState targetState;
            ItemStack itemStackHeld = BuilderItem.getIfHeld((Player)player);
            if (itemStackHeld.m_41720_() instanceof BuilderItem && (targetState = BuilderActionType.getBlockState(itemStackHeld)) != null) {
                EventRender.drawStack(new ItemStack((ItemLike)targetState.m_60734_()));
                int slot = UtilPlayer.getFirstSlotWithBlock((Player)player, targetState);
                if (slot < 0) {
                    int width = mc.m_91268_().m_85445_();
                    int height = mc.m_91268_().m_85446_();
                    EventRender.drawString(event.getMatrixStack(), "0", width / 2 + 16, height / 2 + 12);
                }
            }
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            int sec;
            int height = mc.m_91268_().m_85446_();
            CyclicFile datFile = PlayerDataEvents.getOrCreate((Player)player);
            if (datFile.flyTicks > 0) {
                sec = datFile.flyTicks / 20;
                EventRender.drawString(event.getMatrixStack(), "flight " + sec, 10, height - 30);
            }
            if (datFile.spectatorTicks > 0) {
                sec = datFile.spectatorTicks / 20;
                EventRender.drawString(event.getMatrixStack(), "noClip " + sec, 10, height - 10);
            }
        }
    }

    public static void drawString(PoseStack ms, String str, int x, int y) {
        Minecraft mc = Minecraft.m_91087_();
        mc.f_91062_.m_92883_(ms, str, (float)x, (float)y, 0xFFFFFF);
    }

    public static void drawStack(ItemStack stack) {
        Minecraft mc = Minecraft.m_91087_();
        int width = mc.m_91268_().m_85445_();
        int height = mc.m_91268_().m_85446_();
        mc.m_91291_().m_115203_(stack, width / 2, height / 2);
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderLevelLastEvent event) {
        RelativeShape shape;
        BlockPosDim loc;
        Object buildStyle;
        BlockHitResult lookingAt;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        Level world = player.f_19853_;
        double range = 6.0;
        float alpha = 0.25f;
        HashMap<BlockPos, Color> renderCubes = new HashMap<BlockPos, Color>();
        ItemStack stack = BuilderItem.getIfHeld((Player)player);
        if (stack.m_41720_() instanceof BuilderItem && !world.m_46859_((lookingAt = (BlockHitResult)player.m_19907_(range, 0.0f, false)).m_82425_())) {
            BlockPos pos = lookingAt.m_82425_();
            buildStyle = ((BuilderItem)stack.m_41720_()).style;
            if (buildStyle.isOffset() && lookingAt.m_82434_() != null) {
                pos = pos.m_142300_(lookingAt.m_82434_());
            }
            alpha = 0.4f;
            List<BlockPos> coordinates = PacketSwapBlock.getSelectedBlocks(world, pos, BuilderItem.getActionType(stack), lookingAt.m_82434_(), buildStyle);
            for (BlockPos coordinate : coordinates) {
                renderCubes.put(coordinate, ClientConfigCyclic.getColor(stack));
            }
        }
        if ((stack = RandomizerItem.getIfHeld((Player)player)).m_41720_() instanceof RandomizerItem) {
            lookingAt = UtilRender.getLookingAt((Player)player, (int)range);
            if (player.f_19853_.m_8055_(lookingAt.m_82425_()) == Blocks.f_50016_.m_49966_()) {
                return;
            }
            List<BlockPos> coords = RandomizerItem.getPlaces(lookingAt.m_82425_(), lookingAt.m_82434_());
            buildStyle = coords.iterator();
            while (buildStyle.hasNext()) {
                BlockPos e;
                renderCubes.put(e, RandomizerItem.canMove(player.f_19853_.m_8055_(e = (BlockPos)buildStyle.next()), player.f_19853_, e) ? ClientConfigCyclic.getColor(stack) : Color.RED);
            }
        }
        if ((stack = OreProspector.getIfHeld((Player)player)).m_41720_() instanceof OreProspector) {
            ArrayList<BlockPosDim> coords = OreProspector.getPosition(stack);
            for (BlockPosDim loc2 : coords) {
                if (loc2 == null || loc2.getDimension() != null && !loc2.getDimension().equalsIgnoreCase(UtilWorld.dimensionToString(world))) continue;
                UtilRender.createBox(event.getPoseStack(), loc2.getPos());
            }
        }
        if ((stack = player.m_21205_()).m_41720_() instanceof LocationGpsCard && (loc = LocationGpsCard.getPosition(stack)) != null && (loc.getDimension() == null || loc.getDimension().equalsIgnoreCase(UtilWorld.dimensionToString(world)))) {
            renderCubes.put(loc.getPos(), ClientConfigCyclic.getColor(stack));
        }
        if (stack.m_41720_() instanceof ShapeCard && (shape = RelativeShape.read(stack)) != null) {
            BlockPos here = player.m_142538_();
            for (BlockPos s : shape.getShape()) {
                renderCubes.put(here.m_141952_((Vec3i)s), ClientConfigCyclic.getColor(stack));
            }
        }
        if (renderCubes.keySet().size() > 0) {
            UtilRender.renderColourCubes(event, renderCubes, alpha);
        }
        if (!(stack = LaserItem.getIfHeld((Player)player)).m_41619_() && player.m_6117_()) {
            IEnergyStorage storage = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null).orElse(null);
            if (storage == null || storage.getEnergyStored() < 50) {
                return;
            }
            if (mc.f_91076_ != null) {
                RenderMiningLaser.renderLaser(event, (Player)player, mc.m_91296_(), stack, InteractionHand.MAIN_HAND);
                if (world.m_46467_() % 4L == 0L) {
                    PacketRegistry.INSTANCE.sendToServer((Object)new PacketEntityLaser(mc.f_91076_.m_142049_(), true));
                    UtilSound.playSound((Entity)player, SoundRegistry.LASERBEANPEW, 0.2f);
                }
            } else {
                BlockHitResult miss;
                Vec3 entityHitResultLocation;
                double distance;
                AABB aabb;
                Vec3 cameraEyeViewRay;
                double laserGamemodeRange = (double)mc.f_91072_.m_105286_() * 8.0;
                Entity camera = mc.m_91288_();
                Vec3 cameraViewVector = camera.m_20252_(1.0f);
                Vec3 cameraEyePosition = camera.m_20299_(1.0f);
                EntityHitResult ehr = ProjectileUtil.m_37287_((Entity)camera, (Vec3)cameraEyePosition, (Vec3)(cameraEyeViewRay = cameraEyePosition.m_82520_(cameraViewVector.f_82479_ * laserGamemodeRange, cameraViewVector.f_82480_ * laserGamemodeRange, cameraViewVector.f_82481_ * laserGamemodeRange)), (AABB)(aabb = camera.m_142469_().m_82369_(cameraViewVector.m_82490_(laserGamemodeRange)).m_82377_(1.0, 1.0, 1.0)), ent -> ent.m_6097_() && ent.m_6084_(), (double)0.0);
                if (ehr != null && (distance = Math.sqrt(cameraEyePosition.m_82557_(entityHitResultLocation = ehr.m_82450_()))) < 6000.0 && (miss = mc.f_91073_.m_45547_(new ClipContext(cameraEyePosition, entityHitResultLocation, ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, (Entity)mc.f_91074_))).m_6662_() != HitResult.Type.BLOCK) {
                    RenderMiningLaser.renderLaser(event, (Player)player, mc.m_91296_(), stack, InteractionHand.MAIN_HAND);
                    if (world.m_46467_() % 4L == 0L) {
                        PacketRegistry.INSTANCE.sendToServer((Object)new PacketEntityLaser(ehr.m_82443_().m_142049_(), false));
                        UtilSound.playSound((Entity)player, SoundRegistry.LASERBEANPEW, 0.2f);
                    }
                }
            }
        }
    }
}

