/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.gui;

import com.lothrazar.cyclic.block.TileBlockEntityCyclic;
import com.lothrazar.cyclic.gui.ButtonMachine;
import com.lothrazar.cyclic.gui.TextureEnum;
import com.lothrazar.cyclic.net.PacketTileData;
import com.lothrazar.cyclic.registry.PacketRegistry;
import com.lothrazar.cyclic.util.UtilChat;
import net.minecraft.core.BlockPos;

public class ButtonMachineField
extends ButtonMachine {
    BlockPos tilePos;
    private TextureEnum textureOne;
    private TextureEnum textureZero;
    private String tooltipPrefix;

    public ButtonMachineField(int xPos, int yPos, int field, BlockPos pos) {
        this(xPos, yPos, field, pos, TextureEnum.REDSTONE_ON, TextureEnum.REDSTONE_NEEDED, "gui.cyclic.redstone");
    }

    public ButtonMachineField(int xPos, int yPos, int field, BlockPos pos, TextureEnum toff, TextureEnum tonn, String tooltipPrefix) {
        super(xPos, yPos, 20, 20, "", p -> PacketRegistry.INSTANCE.sendToServer((Object)new PacketTileData(field, pos)));
        this.tilePos = pos;
        this.setTileField(field);
        this.textureZero = toff;
        this.textureOne = tonn;
        this.tooltipPrefix = tooltipPrefix;
    }

    public ButtonMachineField setSize(int size) {
        this.f_93619_ = size;
        this.f_93618_ = size;
        return this;
    }

    public void onValueUpdate(TileBlockEntityCyclic tile) {
        int val = tile.getField(this.getTileField());
        this.onValueUpdate(val);
    }

    private void onValueUpdate(int val) {
        this.setTooltip(UtilChat.lang(this.tooltipPrefix + val));
        this.setTextureId(val == 1 ? this.textureOne : this.textureZero);
    }
}

