/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.equipment;

import com.lothrazar.cyclic.api.IHasClickToggle;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.util.CharmUtil;
import com.lothrazar.cyclic.util.UtilChat;
import com.lothrazar.cyclic.util.UtilNBT;
import com.lothrazar.cyclic.util.UtilPlayer;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingEvent;

public class GlowingHelmetItem
extends ArmorItem
implements IHasClickToggle {
    public static final String NBT_STATUS = "onoff";

    public GlowingHelmetItem(ArmorMaterial materialIn, EquipmentSlot slot, Item.Properties builderIn) {
        super(materialIn, slot, builderIn);
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        boolean isTurnedOn = this.isOn(stack);
        GlowingHelmetItem.removeNightVision(player, isTurnedOn);
        if (isTurnedOn) {
            GlowingHelmetItem.addNightVision(player);
        }
    }

    public void m_7373_(ItemStack stack, Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent(UtilChat.lang(this.m_5524_() + ".tooltip")).m_130940_(ChatFormatting.GRAY));
        String onoff = this.isOn(stack) ? "on" : "off";
        TranslatableComponent t = new TranslatableComponent(UtilChat.lang("item.cantoggle.tooltip.info") + " " + UtilChat.lang("item.cantoggle.tooltip." + onoff));
        t.m_130940_(ChatFormatting.DARK_GRAY);
        tooltip.add((Component)t);
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    private static void addNightVision(Player player) {
        player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 400, 0));
    }

    public static void removeNightVision(Player player, boolean hidden) {
        player.m_6234_(MobEffects.f_19611_);
    }

    private static void checkIfHelmOff(Player player) {
        Item itemInSlot = UtilPlayer.getItemArmorSlot(player, EquipmentSlot.HEAD);
        if (itemInSlot instanceof GlowingHelmetItem) {
            GlowingHelmetItem.removeNightVision(player, false);
        }
    }

    @Override
    public void toggle(Player player, ItemStack held) {
        CompoundTag tags = UtilNBT.getItemStackNBT(held);
        int vnew = this.isOn(held) ? 0 : 1;
        tags.m_128405_(NBT_STATUS, vnew);
    }

    @Override
    public boolean isOn(ItemStack held) {
        return GlowingHelmetItem.isOnStatic(held);
    }

    private static boolean isOnStatic(ItemStack held) {
        CompoundTag tags = UtilNBT.getItemStackNBT(held);
        if (!tags.m_128441_(NBT_STATUS)) {
            return true;
        }
        return tags.m_128451_(NBT_STATUS) == 1;
    }

    public static void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity().f_19853_.m_46467_() % 20L == 0L && event.getEntityLiving() != null) {
            Player player = (Player)event.getEntityLiving();
            GlowingHelmetItem.checkIfHelmOff(player);
            ItemStack helm = CharmUtil.getCurio(player, (Item)ItemRegistry.GLOWING_HELMET.get());
            if (!helm.m_41619_()) {
                if (GlowingHelmetItem.isOnStatic(helm)) {
                    GlowingHelmetItem.addNightVision(player);
                } else {
                    GlowingHelmetItem.removeNightVision(player, false);
                }
            }
        }
    }
}

