/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.item.slingshot;

import com.lothrazar.cyclic.ModCyclic;
import com.lothrazar.cyclic.registry.EntityRegistry;
import com.lothrazar.cyclic.registry.ItemRegistry;
import com.lothrazar.cyclic.util.UtilEntity;
import java.util.Random;
import java.util.UUID;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public class MagicMissileEntity
extends ThrowableItemProjectile {
    private static final int MAX_LIFETIME = 120000;
    private static final int TIME_UNTIL_HOMING = 4;
    private static final double SPEED = 0.95;
    private UUID targetId = null;
    private LivingEntity targetEntity;
    private int lifetime = 120000;

    public MagicMissileEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level world) {
        super(entityType, world);
    }

    public MagicMissileEntity(LivingEntity livingEntityIn, Level worldIn) {
        super(EntityRegistry.MAGIC_MISSILE, livingEntityIn, worldIn);
    }

    protected Item m_7881_() {
        return (Item)ItemRegistry.FIREBALL.get();
    }

    public void setTarget(LivingEntity target) {
        ModCyclic.LOGGER.info("Magic missile target found " + target);
        this.targetId = target == null ? null : target.m_142081_();
        this.targetEntity = target;
    }

    public void m_8119_() {
        super.m_8119_();
        --this.lifetime;
        if (!this.f_19853_.f_46443_ && this.lifetime <= 0) {
            this.m_6074_();
            ModCyclic.LOGGER.info(" server side Self I took too long " + this.targetEntity);
            return;
        }
        if (!(this.f_19853_.f_46443_ || this.targetEntity != null && this.targetEntity.m_6084_())) {
            this.m_6074_();
            ModCyclic.LOGGER.info(" - erase self dead entity  " + this.targetEntity);
            return;
        }
        this.moveTowardsTarget();
    }

    private void moveTowardsTarget() {
        if (this.targetEntity == null) {
            return;
        }
        if (this.targetEntity.m_142538_().equals((Object)this.m_142538_())) {
            return;
        }
        double posX = this.m_20182_().f_82479_;
        double posY = this.m_20182_().f_82480_;
        double posZ = this.m_20182_().f_82481_;
        this.m_19915_(4.0f, 120000.0f);
        float rotationYaw = (float)Math.toRadians(UtilEntity.yawDegreesBetweenPoints(posX, posY, posZ, this.targetEntity.m_20182_().f_82479_, this.targetEntity.m_20182_().f_82480_, this.targetEntity.m_20182_().f_82481_));
        float rotationPitch = (float)Math.toRadians(UtilEntity.pitchDegreesBetweenPoints(posX, posY, posZ, this.targetEntity.m_20182_().f_82479_, this.targetEntity.m_20182_().f_82480_, this.targetEntity.m_20182_().f_82481_));
        this.m_19915_(rotationYaw, rotationPitch);
        Vec3 moveVec = UtilEntity.lookVector(rotationYaw, rotationPitch).m_82490_(0.95);
        this.m_20256_(moveVec);
    }

    protected void m_6532_(HitResult result) {
        HitResult.Type type = result.m_6662_();
        if (type == HitResult.Type.ENTITY) {
            EntityHitResult entityRayTrace = (EntityHitResult)result;
            Entity target = entityRayTrace.m_82443_();
            Entity owner = this.m_37282_();
            if (target.m_6084_()) {
                target.m_6469_(DamageSource.m_19361_((Entity)this, (Entity)owner), (float)Mth.m_14072_((Random)this.f_19853_.f_46441_, (int)1, (int)6));
            }
        }
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

