/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.render;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidRenderMap<V>
extends Object2ObjectOpenCustomHashMap<FluidStack, V> {
    public FluidRenderMap() {
        super((Hash.Strategy)FluidHashStrategy.INSTANCE);
    }

    public static TextureAtlasSprite getFluidTexture(FluidStack fluidStack, FluidType type) {
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation spriteLocation = type == FluidType.STILL ? fluid.getAttributes().getStillTexture(fluidStack) : fluid.getAttributes().getFlowingTexture(fluidStack);
        return FluidRenderMap.getSprite(spriteLocation);
    }

    public static TextureAtlasSprite getSprite(ResourceLocation spriteLocation) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(spriteLocation);
    }

    public static class FluidHashStrategy
    implements Hash.Strategy<FluidStack> {
        public static FluidHashStrategy INSTANCE = new FluidHashStrategy();

        public int hashCode(FluidStack stack) {
            if (stack == null || stack.isEmpty()) {
                return 0;
            }
            int code = 1;
            code = 31 * code + stack.getFluid().hashCode();
            if (stack.hasTag()) {
                code = 31 * code + stack.getTag().hashCode();
            }
            return code;
        }

        public boolean equals(FluidStack a, FluidStack b) {
            return a == null ? b == null : b != null && a.isFluidEqual(b);
        }
    }

    public static enum FluidType {
        STILL,
        FLOWING;

    }
}

