/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.cyclic.util;

import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;

public class UtilPlayer {
    public static final UUID REACH_ID = UUID.fromString("1abcdef2-eff2-4a81-b92b-a1cb95f115c6");

    public static void removePlayerReach(Player playerIn) {
        AttributeInstance attr = playerIn.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get());
        attr.m_22120_(REACH_ID);
    }

    public static void addPlayerReach(Player playerIn, int reachBoost) {
        UtilPlayer.removePlayerReach(playerIn);
        AttributeInstance attr = playerIn.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get());
        AttributeModifier enchantment = new AttributeModifier(REACH_ID, "ReachEnchantmentCyclic", (double)reachBoost, AttributeModifier.Operation.ADDITION);
        attr.m_22125_(enchantment);
    }

    public static double getExpTotal(Player player) {
        int level = player.f_36078_;
        double totalExp = UtilPlayer.getXpForLevel(level);
        double progress = Math.round((float)player.m_36323_() * player.f_36080_);
        return totalExp += (double)((int)progress);
    }

    public static int getXpForLevel(int level) {
        int totalExp = 0;
        totalExp = level <= 15 ? level * level + 6 * level : (level <= 30 ? (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0) : (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0));
        return totalExp;
    }

    public static ItemStack getPlayerItemIfHeld(Player player) {
        ItemStack wand = player.m_21205_();
        if (wand.m_41619_()) {
            wand = player.m_21206_();
        }
        return wand;
    }

    public static int getFirstSlotWithBlock(Player player, BlockState targetState) {
        int ret = -1;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || stack.m_41720_() == null || Block.m_49814_((Item)stack.m_41720_()) != targetState.m_60734_()) continue;
            return i;
        }
        return ret;
    }

    public static BlockState getBlockstateFromSlot(Player player, int slot) {
        ItemStack stack = player.m_150109_().m_8020_(slot);
        if (!stack.m_41619_() && stack.m_41720_() != null && Block.m_49814_((Item)stack.m_41720_()) != null) {
            Block b = Block.m_49814_((Item)stack.m_41720_());
            return b.m_49966_();
        }
        return null;
    }

    public static void decrStackSize(Player player, int slot) {
        if (!player.m_7500_() && slot >= 0) {
            player.m_150109_().m_7407_(slot, 1);
        }
    }

    public static Item getItemArmorSlot(Player player, EquipmentSlot slot) {
        ItemStack inslot = (ItemStack)player.m_150109_().f_35975_.get(slot.m_20749_());
        Item item = inslot.m_41619_() ? null : inslot.m_41720_();
        return item;
    }
}

