/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.event.ForgeEventFactory;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.registry.ModSounds;

public class TomatoBlock
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61409_;
    private static final int TOMATO_BEARING_AGE = 7;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public TomatoBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected static float getGrowthChance(Block blockIn, BlockGetter worldIn, BlockPos pos) {
        boolean isMatchedNorthSouth;
        float f = 1.0f;
        BlockPos floorPos = pos.m_7495_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = worldIn.m_8055_(floorPos.m_142082_(i, 0, j));
                if (blockstate.canSustainPlant(worldIn, floorPos.m_142082_(i, 0, j), Direction.UP, (IPlantable)blockIn)) {
                    f1 = 1.0f;
                    if (blockstate.isFertile(worldIn, floorPos.m_142082_(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos northPos = pos.m_142127_();
        BlockPos southPos = pos.m_142128_();
        BlockPos westPos = pos.m_142125_();
        BlockPos eastPos = pos.m_142126_();
        boolean isMatchedWestEast = blockIn == worldIn.m_8055_(westPos).m_60734_() || blockIn == worldIn.m_8055_(eastPos).m_60734_();
        boolean bl = isMatchedNorthSouth = blockIn == worldIn.m_8055_(northPos).m_60734_() || blockIn == worldIn.m_8055_(southPos).m_60734_();
        if (isMatchedWestEast && isMatchedNorthSouth) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockIn == worldIn.m_8055_(westPos.m_142127_()).m_60734_() || blockIn == worldIn.m_8055_(eastPos.m_142127_()).m_60734_() || blockIn == worldIn.m_8055_(eastPos.m_142128_()).m_60734_() || blockIn == worldIn.m_8055_(westPos.m_142128_()).m_60734_();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public int getMaxAge() {
        return 7;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE);
    }

    public BlockState withAge(int age) {
        return (BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(age));
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) >= this.getMaxAge();
    }

    protected int getBonemealAgeIncrease(Level worldIn) {
        return Mth.m_14072_((Random)worldIn.f_46441_, (int)2, (int)5);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.m_61143_((Property)AGE)];
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)ModItems.TOMATO_SEEDS.get());
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        float f;
        int i;
        super.m_7458_(state, worldIn, pos, rand);
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.m_45524_(pos, 0) >= 9 && (i = this.getAge(state)) < this.getMaxAge() && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt((int)(25.0f / (f = TomatoBlock.getGrowthChance((Block)this, (BlockGetter)worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            worldIn.m_7731_(pos, this.withAge(i + 1), 2);
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.CROP;
    }

    public boolean m_7370_(BlockGetter worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return !this.isMaxAge(state);
    }

    public boolean m_5491_(Level worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void m_7719_(ServerLevel worldIn, Random rand, BlockPos pos, BlockState state) {
        int maxAge;
        int newAge = this.getAge(state) + this.getBonemealAgeIncrease((Level)worldIn);
        if (newAge > (maxAge = this.getMaxAge())) {
            newAge = maxAge;
        }
        worldIn.m_7731_(pos, this.withAge(newAge), 2);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        boolean isMature;
        int age = (Integer)state.m_61143_((Property)AGE);
        boolean bl = isMature = age == 7;
        if (!isMature && player.m_21120_(handIn).m_41720_() == Items.f_42499_) {
            return InteractionResult.PASS;
        }
        if (isMature) {
            int j = 1 + worldIn.f_46441_.nextInt(2);
            TomatoBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.TOMATO.get(), j));
            if ((double)worldIn.f_46441_.nextFloat() < 0.05) {
                TomatoBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)ModItems.ROTTEN_TOMATO.get()));
            }
            worldIn.m_5594_(null, pos, (SoundEvent)ModSounds.ITEM_TOMATO_PICK_FROM_BUSH.get(), SoundSource.BLOCKS, 1.0f, 0.8f + worldIn.f_46441_.nextFloat() * 0.4f);
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(5)), 2);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        return (worldIn.m_45524_(pos, 0) >= 8 || worldIn.m_45527_(pos)) && super.m_7898_(state, worldIn, pos);
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof Ravager && ForgeEventFactory.getMobGriefingEvent((Level)worldIn, (Entity)entityIn)) {
            worldIn.m_46953_(pos, true, entityIn);
        }
        super.m_7892_(state, worldIn, pos, entityIn);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{AGE});
    }
}

