/*
 * Decompiled with CFR 0.152.
 */
package com.belgieyt.redstonevillager;

import java.util.Random;
import java.util.function.Function;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;

public class TradeBuilder {
    protected Function<Random, ItemStack> price = null;
    protected Function<Random, ItemStack> price2 = random -> ItemStack.f_41583_;
    protected Function<Random, ItemStack> forSale = null;
    protected final int maxTrades;
    protected final int xp;
    protected final float priceMult;

    public TradeBuilder(int maxTrades, int xp, float priceMult) {
        this.maxTrades = maxTrades;
        this.xp = xp;
        this.priceMult = priceMult;
    }

    public TradeBuilder setPrice(Function<Random, ItemStack> price) {
        this.price = price;
        return this;
    }

    public TradeBuilder setPrice(Item item, int min, int max) {
        return this.setPrice(TradeBuilder.createFunction(item, min, max));
    }

    public TradeBuilder setPrice2(Function<Random, ItemStack> price2) {
        this.price2 = price2;
        return this;
    }

    public TradeBuilder setPrice2(Item item, int min, int max) {
        return this.setPrice2(TradeBuilder.createFunction(item, min, max));
    }

    public TradeBuilder setForSale(Function<Random, ItemStack> forSale) {
        this.forSale = forSale;
        return this;
    }

    public TradeBuilder setForSale(Item item, int min, int max) {
        return this.setForSale(TradeBuilder.createFunction(item, min, max));
    }

    public TradeBuilder setEmeraldPrice(int emeralds) {
        return this.setPrice(random -> new ItemStack((ItemLike)Items.f_42616_, emeralds));
    }

    public TradeBuilder setEmeraldPriceFor(int emeralds, Item item, int amt) {
        this.setEmeraldPrice(emeralds);
        return this.setForSale(random -> new ItemStack((ItemLike)item, amt));
    }

    public TradeBuilder setEmeraldPriceFor(int emeralds, Item item) {
        return this.setEmeraldPriceFor(emeralds, item, 1);
    }

    public TradeBuilder setEmeraldPrice(int min, int max) {
        return this.setPrice(Items.f_42616_, min, max);
    }

    public TradeBuilder setEmeraldPriceFor(int min, int max, Item item, int amt) {
        this.setEmeraldPrice(min, max);
        return this.setForSale(random -> new ItemStack((ItemLike)item, amt));
    }

    public TradeBuilder setEmeraldPriceFor(int min, int max, Item item) {
        return this.setEmeraldPriceFor(min, max, item, 1);
    }

    public boolean canBuild() {
        return this.price != null && this.forSale != null;
    }

    public VillagerTrades.ItemListing build() {
        return (entity, random) -> !this.canBuild() ? null : new MerchantOffer(this.price.apply(random), this.price2.apply(random), this.forSale.apply(random), this.maxTrades, this.xp, this.priceMult);
    }

    public static Function<Random, ItemStack> createFunction(Item item, int min, int max) {
        return random -> new ItemStack((ItemLike)item, random.nextInt(max) + min);
    }
}

