/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.optifine.Config;
import net.optifine.CustomGuiProperties;
import net.optifine.CustomGuis;
import net.optifine.config.BiomeId;
import net.optifine.config.ConnectedParser;
import net.optifine.config.MatchProfession;
import net.optifine.config.Matches;
import net.optifine.config.NbtTagValue;
import net.optifine.config.RangeListInt;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.StrUtils;
import net.optifine.util.TextureUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class CustomGuiProperties {
    private String fileName = null;
    private String basePath = null;
    private EnumContainer container = null;
    private Map<yh, yh> textureLocations = null;
    private NbtTagValue nbtName = null;
    private BiomeId[] biomes = null;
    private RangeListInt heights = null;
    private Boolean large = null;
    private Boolean trapped = null;
    private Boolean christmas = null;
    private Boolean ender = null;
    private RangeListInt levels = null;
    private MatchProfession[] professions = null;
    private EnumVariant[] variants = null;
    private bta[] colors = null;
    private static final EnumVariant[] VARIANTS_HORSE = new EnumVariant[]{EnumVariant.HORSE, EnumVariant.DONKEY, EnumVariant.MULE, EnumVariant.LLAMA};
    private static final EnumVariant[] VARIANTS_DISPENSER = new EnumVariant[]{EnumVariant.DISPENSER, EnumVariant.DROPPER};
    private static final EnumVariant[] VARIANTS_INVALID = new EnumVariant[0];
    private static final bta[] COLORS_INVALID = new bta[0];
    private static final yh ANVIL_GUI_TEXTURE = new yh("textures/gui/container/anvil.png");
    private static final yh BEACON_GUI_TEXTURE = new yh("textures/gui/container/beacon.png");
    private static final yh BREWING_STAND_GUI_TEXTURE = new yh("textures/gui/container/brewing_stand.png");
    private static final yh CHEST_GUI_TEXTURE = new yh("textures/gui/container/generic_54.png");
    private static final yh CRAFTING_TABLE_GUI_TEXTURE = new yh("textures/gui/container/crafting_table.png");
    private static final yh HORSE_GUI_TEXTURE = new yh("textures/gui/container/horse.png");
    private static final yh DISPENSER_GUI_TEXTURE = new yh("textures/gui/container/dispenser.png");
    private static final yh ENCHANTMENT_TABLE_GUI_TEXTURE = new yh("textures/gui/container/enchanting_table.png");
    private static final yh FURNACE_GUI_TEXTURE = new yh("textures/gui/container/furnace.png");
    private static final yh HOPPER_GUI_TEXTURE = new yh("textures/gui/container/hopper.png");
    private static final yh INVENTORY_GUI_TEXTURE = new yh("textures/gui/container/inventory.png");
    private static final yh SHULKER_BOX_GUI_TEXTURE = new yh("textures/gui/container/shulker_box.png");
    private static final yh VILLAGER_GUI_TEXTURE = new yh("textures/gui/container/villager2.png");

    public CustomGuiProperties(Properties props, String path) {
        ConnectedParser cp = new ConnectedParser("CustomGuis");
        this.fileName = cp.parseName(path);
        this.basePath = cp.parseBasePath(path);
        this.container = (EnumContainer)cp.parseEnum(props.getProperty("container"), (Enum[])EnumContainer.values(), "container");
        this.textureLocations = CustomGuiProperties.parseTextureLocations((Properties)props, (String)"texture", (EnumContainer)this.container, (String)"textures/gui/", (String)this.basePath);
        this.nbtName = cp.parseNbtTagValue("name", props.getProperty("name"));
        this.biomes = cp.parseBiomes(props.getProperty("biomes"));
        this.heights = cp.parseRangeListIntNeg(props.getProperty("heights"));
        this.large = cp.parseBooleanObject(props.getProperty("large"));
        this.trapped = cp.parseBooleanObject(props.getProperty("trapped"));
        this.christmas = cp.parseBooleanObject(props.getProperty("christmas"));
        this.ender = cp.parseBooleanObject(props.getProperty("ender"));
        this.levels = cp.parseRangeListInt(props.getProperty("levels"));
        this.professions = cp.parseProfessions(props.getProperty("professions"));
        EnumVariant[] vars = CustomGuiProperties.getContainerVariants((EnumContainer)this.container);
        this.variants = (EnumVariant[])cp.parseEnums(props.getProperty("variants"), (Enum[])vars, "variants", (Enum[])VARIANTS_INVALID);
        this.colors = CustomGuiProperties.parseEnumDyeColors((String)props.getProperty("colors"));
    }

    private static EnumVariant[] getContainerVariants(EnumContainer cont) {
        if (cont == EnumContainer.HORSE) {
            return VARIANTS_HORSE;
        }
        if (cont == EnumContainer.DISPENSER) {
            return VARIANTS_DISPENSER;
        }
        return new EnumVariant[0];
    }

    private static bta[] parseEnumDyeColors(String str) {
        if (str == null) {
            return null;
        }
        str = str.toLowerCase();
        String[] tokens = Config.tokenize((String)str, (String)" ");
        bta[] cols = new bta[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            bta col = CustomGuiProperties.parseEnumDyeColor((String)token);
            if (col == null) {
                CustomGuiProperties.warn((String)("Invalid color: " + token));
                return COLORS_INVALID;
            }
            cols[i] = col;
        }
        return cols;
    }

    private static bta parseEnumDyeColor(String str) {
        if (str == null) {
            return null;
        }
        bta[] colors = bta.values();
        for (int i = 0; i < colors.length; ++i) {
            bta enumDyeColor = colors[i];
            if (enumDyeColor.c().equals(str)) {
                return enumDyeColor;
            }
            if (!enumDyeColor.b().equals(str)) continue;
            return enumDyeColor;
        }
        return null;
    }

    private static yh parseTextureLocation(String str, String basePath) {
        if (str == null) {
            return null;
        }
        Object tex = TextureUtils.fixResourcePath((String)(str = str.trim()), (String)basePath);
        if (!((String)tex).endsWith(".png")) {
            tex = (String)tex + ".png";
        }
        return new yh(basePath + "/" + (String)tex);
    }

    private static Map<yh, yh> parseTextureLocations(Properties props, String property, EnumContainer container, String pathPrefix, String basePath) {
        HashMap<yh, yh> map = new HashMap<yh, yh>();
        String propVal = props.getProperty(property);
        if (propVal != null) {
            yh locKey = CustomGuiProperties.getGuiTextureLocation((EnumContainer)container);
            yh locVal = CustomGuiProperties.parseTextureLocation((String)propVal, (String)basePath);
            if (locKey != null && locVal != null) {
                map.put(locKey, locVal);
            }
        }
        String keyPrefix = property + ".";
        Set<Object> keys = props.keySet();
        for (String string : keys) {
            if (!string.startsWith(keyPrefix)) continue;
            String pathRel = string.substring(keyPrefix.length());
            pathRel = pathRel.replace('\\', '/');
            pathRel = StrUtils.removePrefixSuffix((String)pathRel, (String)"/", (String)".png");
            String path = pathPrefix + pathRel + ".png";
            String val = props.getProperty(string);
            yh locKey = new yh(path);
            yh locVal = CustomGuiProperties.parseTextureLocation((String)val, (String)basePath);
            map.put(locKey, locVal);
        }
        return map;
    }

    private static yh getGuiTextureLocation(EnumContainer container) {
        if (container == null) {
            return null;
        }
        switch (1.$SwitchMap$net$optifine$CustomGuiProperties$EnumContainer[container.ordinal()]) {
            case 1: {
                return ANVIL_GUI_TEXTURE;
            }
            case 2: {
                return BEACON_GUI_TEXTURE;
            }
            case 3: {
                return BREWING_STAND_GUI_TEXTURE;
            }
            case 4: {
                return CHEST_GUI_TEXTURE;
            }
            case 5: {
                return CRAFTING_TABLE_GUI_TEXTURE;
            }
            case 6: {
                return null;
            }
            case 7: {
                return DISPENSER_GUI_TEXTURE;
            }
            case 8: {
                return ENCHANTMENT_TABLE_GUI_TEXTURE;
            }
            case 9: {
                return FURNACE_GUI_TEXTURE;
            }
            case 10: {
                return HOPPER_GUI_TEXTURE;
            }
            case 11: {
                return HORSE_GUI_TEXTURE;
            }
            case 12: {
                return INVENTORY_GUI_TEXTURE;
            }
            case 13: {
                return SHULKER_BOX_GUI_TEXTURE;
            }
            case 14: {
                return VILLAGER_GUI_TEXTURE;
            }
        }
        return null;
    }

    public boolean isValid(String path) {
        if (this.fileName == null || this.fileName.length() <= 0) {
            CustomGuiProperties.warn((String)("No name found: " + path));
            return false;
        }
        if (this.basePath == null) {
            CustomGuiProperties.warn((String)("No base path found: " + path));
            return false;
        }
        if (this.container == null) {
            CustomGuiProperties.warn((String)("No container found: " + path));
            return false;
        }
        if (this.textureLocations.isEmpty()) {
            CustomGuiProperties.warn((String)("No texture found: " + path));
            return false;
        }
        if (this.professions == ConnectedParser.PROFESSIONS_INVALID) {
            CustomGuiProperties.warn((String)("Invalid professions or careers: " + path));
            return false;
        }
        if (this.variants == VARIANTS_INVALID) {
            CustomGuiProperties.warn((String)("Invalid variants: " + path));
            return false;
        }
        if (this.colors == COLORS_INVALID) {
            CustomGuiProperties.warn((String)("Invalid colors: " + path));
            return false;
        }
        return true;
    }

    private static void warn(String str) {
        Config.warn((String)("[CustomGuis] " + str));
    }

    private boolean matchesGeneral(EnumContainer ec, gh pos, cag blockAccess) {
        caz biome;
        if (this.container != ec) {
            return false;
        }
        if (this.biomes != null && !Matches.biome((caz)(biome = blockAccess.v(pos)), (BiomeId[])this.biomes)) {
            return false;
        }
        return this.heights == null || this.heights.isInRange(pos.v());
    }

    public boolean matchesPos(EnumContainer ec, gh pos, cag blockAccess, ecr screen) {
        String name;
        if (!this.matchesGeneral(ec, pos, blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(name = CustomGuiProperties.getName((ecr)screen))) {
            return false;
        }
        switch (1.$SwitchMap$net$optifine$CustomGuiProperties$EnumContainer[ec.ordinal()]) {
            case 2: {
                return this.matchesBeacon(pos, (bzg)blockAccess);
            }
            case 4: {
                return this.matchesChest(pos, (bzg)blockAccess);
            }
            case 7: {
                return this.matchesDispenser(pos, (bzg)blockAccess);
            }
            case 13: {
                return this.matchesShulker(pos, (bzg)blockAccess);
            }
        }
        return true;
    }

    public static String getName(ecr screen) {
        pz itc = screen.j();
        if (itc == null) {
            return null;
        }
        return itc.a();
    }

    private boolean matchesBeacon(gh pos, bzg blockAccess) {
        clz te = blockAccess.c_(pos);
        if (!(te instanceof clu)) {
            return false;
        }
        clu teb = (clu)te;
        if (this.levels != null) {
            if (!Reflector.TileEntityBeacon_levels.exists()) {
                return false;
            }
            int l = Reflector.getFieldValueInt((Object)teb, (ReflectorField)Reflector.TileEntityBeacon_levels, (int)-1);
            if (!this.levels.isInRange(l)) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesChest(gh pos, bzg blockAccess) {
        clz te = blockAccess.c_(pos);
        if (te instanceof cme) {
            cme tec = (cme)te;
            return this.matchesChest(tec, pos, blockAccess);
        }
        if (te instanceof cmo) {
            cmo teec = (cmo)te;
            return this.matchesEnderChest(teec, pos, blockAccess);
        }
        return false;
    }

    private boolean matchesChest(cme tec, gh pos, bzg blockAccess) {
        coc blockState = blockAccess.a_(pos);
        cov chestType = blockState.b((cpg)cdw.c) ? (cov)blockState.c((cpg)cdw.c) : cov.a;
        boolean isLarge = chestType != cov.a;
        boolean isTrapped = tec instanceof cnh;
        boolean isChristmas = CustomGuis.isChristmas;
        boolean isEnder = false;
        return this.matchesChest(isLarge, isTrapped, isChristmas, isEnder);
    }

    private boolean matchesEnderChest(cmo teec, gh pos, bzg blockAccess) {
        return this.matchesChest(false, false, false, true);
    }

    private boolean matchesChest(boolean isLarge, boolean isTrapped, boolean isChristmas, boolean isEnder) {
        if (this.large != null && this.large != isLarge) {
            return false;
        }
        if (this.trapped != null && this.trapped != isTrapped) {
            return false;
        }
        if (this.christmas != null && this.christmas != isChristmas) {
            return false;
        }
        return this.ender == null || this.ender == isEnder;
    }

    private boolean matchesDispenser(gh pos, bzg blockAccess) {
        EnumVariant var;
        clz te = blockAccess.c_(pos);
        if (!(te instanceof cml)) {
            return false;
        }
        cml ted = (cml)te;
        return this.variants == null || Config.equalsOne((Object)(var = this.getDispenserVariant(ted)), (Object[])this.variants);
    }

    private EnumVariant getDispenserVariant(cml ted) {
        if (ted instanceof cmm) {
            return EnumVariant.DROPPER;
        }
        return EnumVariant.DISPENSER;
    }

    private boolean matchesShulker(gh pos, bzg blockAccess) {
        bta col;
        clz te = blockAccess.c_(pos);
        if (!(te instanceof cmy)) {
            return false;
        }
        cmy tesb = (cmy)te;
        return this.colors == null || Config.equalsOne((Object)(col = tesb.j()), (Object[])this.colors);
    }

    public boolean matchesEntity(EnumContainer ec, awt entity, cag blockAccess) {
        String entityName;
        if (!this.matchesGeneral(ec, entity.cW(), blockAccess)) {
            return false;
        }
        if (this.nbtName != null && !this.nbtName.matchesValue(entityName = entity.co())) {
            return false;
        }
        switch (1.$SwitchMap$net$optifine$CustomGuiProperties$EnumContainer[ec.ordinal()]) {
            case 14: {
                return this.matchesVillager(entity, (bzg)blockAccess);
            }
            case 11: {
                return this.matchesHorse(entity, (bzg)blockAccess);
            }
        }
        return true;
    }

    private boolean matchesVillager(awt entity, bzg blockAccess) {
        int level;
        bnf vd;
        bnh vp;
        if (!(entity instanceof bne)) {
            return false;
        }
        bne entityVillager = (bne)entity;
        return this.professions == null || MatchProfession.matchesOne((bnh)(vp = (vd = entityVillager.fJ()).b()), (int)(level = vd.c()), (MatchProfession[])this.professions);
    }

    private boolean matchesHorse(awt entity, bzg blockAccess) {
        biz el;
        bta col;
        EnumVariant var;
        if (!(entity instanceof biw)) {
            return false;
        }
        biw ah = (biw)entity;
        if (this.variants != null && !Config.equalsOne((Object)(var = this.getHorseVariant(ah)), (Object[])this.variants)) {
            return false;
        }
        return this.colors == null || !(ah instanceof biz) || Config.equalsOne((Object)(col = (el = (biz)ah).gk()), (Object[])this.colors);
    }

    private EnumVariant getHorseVariant(biw entity) {
        if (entity instanceof biy) {
            return EnumVariant.HORSE;
        }
        if (entity instanceof bix) {
            return EnumVariant.DONKEY;
        }
        if (entity instanceof bjb) {
            return EnumVariant.MULE;
        }
        if (entity instanceof biz) {
            return EnumVariant.LLAMA;
        }
        return null;
    }

    public EnumContainer getContainer() {
        return this.container;
    }

    public yh getTextureLocation(yh loc) {
        yh locNew = (yh)this.textureLocations.get(loc);
        if (locNew == null) {
            return loc;
        }
        return locNew;
    }

    public String toString() {
        return "name: " + this.fileName + ", container: " + this.container + ", textures: " + this.textureLocations;
    }
}

