/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.render;

import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Set;
import net.optifine.Config;

public class ChunkVisibility {
    public static final int MASK_FACINGS = 63;
    public static final gm[][] enumFacingArrays = ChunkVisibility.makeEnumFacingArrays((boolean)false);
    public static final gm[][] enumFacingOppositeArrays = ChunkVisibility.makeEnumFacingArrays((boolean)true);
    private static int counter = 0;
    private static int iMaxStatic = -1;
    private static int iMaxStaticFinal = 16;
    private static ell worldLast = null;
    private static int pcxLast = Integer.MIN_VALUE;
    private static int pczLast = Integer.MIN_VALUE;

    public static int getMaxChunkY(ell world, awt viewEntity, int renderDistanceChunks, epz viewFrustum) {
        int minHeight = world.u_();
        int maxHeight = world.v_();
        int minChunkHeight = minHeight >> 4;
        int pcx = aiy.b((double)viewEntity.dc()) >> 4;
        int pcy = aiy.b((double)(viewEntity.de() - (double)minHeight)) >> 4;
        int pcz = aiy.b((double)viewEntity.di()) >> 4;
        int pcyMax = maxHeight - minHeight >> 4;
        pcy = Config.limit((int)pcy, (int)0, (int)(pcyMax - 1));
        long playerSectionKey = ha.c((gh)viewEntity.cW());
        crs playerSection = world.getSectionStorage().d(playerSectionKey);
        boolean multiplayer = !Config.isIntegratedServerRunning();
        int cxStart = pcx - renderDistanceChunks;
        int cxEnd = pcx + renderDistanceChunks;
        int czStart = pcz - renderDistanceChunks;
        int czEnd = pcz + renderDistanceChunks;
        if (world != worldLast || pcx != pcxLast || pcz != pczLast) {
            counter = 0;
            iMaxStaticFinal = 16;
            worldLast = world;
            pcxLast = pcx;
            pczLast = pcz;
        }
        if (counter == 0) {
            iMaxStatic = -1;
        }
        int iMax = iMaxStatic;
        switch (counter) {
            case 0: {
                cxEnd = pcx;
                czEnd = pcz;
                break;
            }
            case 1: {
                cxStart = pcx;
                czEnd = pcz;
                break;
            }
            case 2: {
                cxEnd = pcx;
                czStart = pcz;
                break;
            }
            case 3: {
                cxStart = pcx;
                czStart = pcz;
            }
        }
        for (int cx = cxStart; cx < cxEnd; ++cx) {
            for (int cz = czStart; cz < czEnd; ++cz) {
                cqi chunk = world.d(cx, cz);
                if (chunk.A()) {
                    int i2;
                    if (!multiplayer || (i2 = viewFrustum.getHighestUsedChunkIndex(cx, iMax, cz)) <= iMax) continue;
                    iMax = i2;
                    continue;
                }
                cqj[] ebss = chunk.d();
                for (int i3 = ebss.length - 1; i3 > iMax; --i3) {
                    cqj ebs = ebss[i3];
                    if (ebs == null || ebs.c()) continue;
                    if (i3 <= iMax) break;
                    iMax = i3;
                    break;
                }
                try {
                    Map mapTileEntities = chunk.E();
                    if (mapTileEntities.isEmpty()) continue;
                    Set keys = mapTileEntities.keySet();
                    for (gh pos : keys) {
                        int i4 = pos.v() - minHeight >> 4;
                        if (i4 <= iMax) continue;
                        iMax = i4;
                    }
                    continue;
                }
                catch (ConcurrentModificationException mapTileEntities) {
                    // empty catch block
                }
            }
        }
        if (counter == 0) {
            LongSet sectionKeys = world.getSectionStorage().getSectionKeys();
            LongIterator it = sectionKeys.iterator();
            while (it.hasNext()) {
                long sectionKey = it.nextLong();
                int sectionY = ha.c((long)sectionKey);
                int i5 = sectionY - minChunkHeight;
                if (sectionKey == playerSectionKey && i5 == pcy && playerSection != null && playerSection.getEntityList().size() == 1 || i5 <= iMax) continue;
                iMax = i5;
            }
        }
        if (counter < 3) {
            iMaxStatic = iMax;
            iMax = iMaxStaticFinal;
        } else {
            iMaxStaticFinal = iMax;
            iMaxStatic = -1;
        }
        counter = (counter + 1) % 4;
        return (iMax << 4) + minHeight;
    }

    public static boolean isFinished() {
        return counter == 0;
    }

    private static gm[][] makeEnumFacingArrays(boolean opposite) {
        int count = 64;
        gm[][] arrs = new gm[count][];
        for (int i2 = 0; i2 < count; ++i2) {
            ArrayList<gm> list = new ArrayList<gm>();
            for (int ix = 0; ix < gm.p.length; ++ix) {
                gm facing = gm.p[ix];
                gm facingMask = opposite ? facing.f() : facing;
                int mask = 1 << facingMask.ordinal();
                if ((i2 & mask) == 0) continue;
                list.add(facing);
            }
            gm[] fs = list.toArray(new gm[list.size()]);
            arrs[i2] = fs;
        }
        return arrs;
    }

    public static gm[] getFacingsNotOpposite(int setDisabled) {
        int index = ~setDisabled & 0x3F;
        return enumFacingOppositeArrays[index];
    }

    public static gm[] getFacings(int setDirections) {
        int index = setDirections & 0x3F;
        return enumFacingArrays[index];
    }

    public static void reset() {
        worldLast = null;
    }
}

