/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import dev.gigaherz.toolbelt.BeltFinder;
import dev.gigaherz.toolbelt.ConfigData;
import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.client.ClientEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.CapabilityItemHandler;

public class ToolBeltLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation TEXTURE_BELT = ToolBelt.location("textures/entity/belt.png");
    private final BeltModel<T> beltModel = new BeltModel(Minecraft.m_91087_().m_167973_().m_171103_(ClientEvents.BELT_LAYER));

    public ToolBeltLayer(LivingEntityRenderer<T, M> owner) {
        super(owner);
    }

    private void translateToBody(PoseStack poseStack) {
        ((HumanoidModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
    }

    public void render(PoseStack matrixStack, MultiBufferSource buffer, int lightness, T player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!ConfigData.showBeltOnPlayers) {
            return;
        }
        BeltFinder.findBelt(player, true).ifPresent(getter -> {
            if (getter.isHidden()) {
                return;
            }
            getter.getBelt().getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(cap -> {
                ItemStack rightItem;
                boolean rightHanded = player.m_5737_() == HumanoidArm.RIGHT;
                matrixStack.m_85836_();
                this.translateToBody(matrixStack);
                ItemStack firstItem = cap.getStackInSlot(0);
                ItemStack secondItem = cap.getStackInSlot(1);
                ItemStack leftItem = rightHanded ? firstItem : secondItem;
                ItemStack itemStack = rightItem = rightHanded ? secondItem : firstItem;
                if (!leftItem.m_41619_() || !rightItem.m_41619_()) {
                    matrixStack.m_85836_();
                    if (((HumanoidModel)this.m_117386_()).f_102610_) {
                        matrixStack.m_85837_(0.0, 0.75, 0.0);
                        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
                    }
                    ToolBeltLayer.renderHeldItem(player, rightItem, ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, matrixStack, buffer, lightness);
                    ToolBeltLayer.renderHeldItem(player, leftItem, ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, matrixStack, buffer, lightness);
                    matrixStack.m_85849_();
                }
                matrixStack.m_85837_(0.0, (double)0.19f, 0.0);
                matrixStack.m_85841_(0.85f, 0.6f, 0.78f);
                ToolBeltLayer.m_117376_(this.beltModel, (ResourceLocation)TEXTURE_BELT, (PoseStack)matrixStack, (MultiBufferSource)buffer, (int)lightness, (LivingEntity)player, (float)1.0f, (float)1.0f, (float)1.0f);
                matrixStack.m_85849_();
            });
        });
    }

    private static void renderHeldItem(LivingEntity player, ItemStack stack, ItemTransforms.TransformType transformType, HumanoidArm handSide, PoseStack matrixStack, MultiBufferSource buffer, int lightness) {
        if (stack.m_41619_()) {
            return;
        }
        matrixStack.m_85836_();
        if (handSide == HumanoidArm.LEFT) {
            matrixStack.m_85837_((double)-0.271875f, (double)0.7f, (double)-0.1f);
        } else {
            matrixStack.m_85837_((double)0.271875f, (double)0.7f, (double)-0.1f);
        }
        matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(40.0f));
        float scale = ConfigData.beltItemScale;
        matrixStack.m_85841_(scale, scale, scale);
        Minecraft.m_91087_().m_91292_().m_109322_(player, stack, transformType, handSide == HumanoidArm.LEFT, matrixStack, buffer, lightness);
        matrixStack.m_85849_();
    }

    public static class BeltModel<T extends LivingEntity>
    extends EntityModel<T> {
        private static final String BELT = "belt";
        private static final String BUCKLE = "buckle";
        private static final String LEFT_POCKET = "left_pocket";
        private static final String RIGHT_POCKET = "right_pocket";
        private final ModelPart belt;
        private final ModelPart buckle;
        private final ModelPart left_pocket;
        private final ModelPart right_pocket;

        public BeltModel(ModelPart part) {
            super(RenderType::m_110458_);
            this.belt = part.m_171324_(BELT);
            this.buckle = part.m_171324_(BUCKLE);
            this.left_pocket = part.m_171324_(LEFT_POCKET);
            this.right_pocket = part.m_171324_(RIGHT_POCKET);
        }

        public static LayerDefinition createBodyLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.m_171576_();
            partdefinition.m_171599_(BELT, CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-5.0f, 10.0f, -3.0f, 10.0f, 4.0f, 6.0f), PartPose.f_171404_);
            partdefinition.m_171599_(BUCKLE, CubeListBuilder.m_171558_().m_171514_(10, 10).m_171481_(-2.5f, 9.5f, -3.5f, 5.0f, 5.0f, 1.0f), PartPose.f_171404_);
            partdefinition.m_171599_(LEFT_POCKET, CubeListBuilder.m_171558_().m_171514_(0, 10).m_171481_(-2.0f, 12.0f, 5.0f, 4.0f, 4.0f, 1.0f), PartPose.m_171430_((float)0.0f, (float)-90.0f, (float)0.0f));
            partdefinition.m_171599_(RIGHT_POCKET, CubeListBuilder.m_171558_().m_171514_(0, 10).m_171481_(-2.0f, 12.0f, 5.0f, 4.0f, 4.0f, 1.0f), PartPose.m_171430_((float)0.0f, (float)90.0f, (float)0.0f));
            return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
        }

        public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        }

        public void m_7695_(PoseStack matrixStack, VertexConsumer vertexBuilder, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            this.belt.m_104306_(matrixStack, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.left_pocket.m_104306_(matrixStack, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            this.right_pocket.m_104306_(matrixStack, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            matrixStack.m_85836_();
            matrixStack.m_85841_(0.8f, 1.0f, 1.0f);
            this.buckle.m_104306_(matrixStack, vertexBuilder, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            matrixStack.m_85849_();
        }
    }
}

