/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave;

import com.mojang.datafixers.DataFixer;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2189;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2806;
import net.minecraft.class_2861;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3508;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3898;
import net.minecraft.class_3977;
import net.minecraft.class_4284;
import net.minecraft.class_6490;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeKey;
import xaero.map.biome.BiomeKeyManager;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.misc.CachedFunction;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;

public class WorldDataReader {
    private MapProcessor mapProcessor;
    private boolean[] underair;
    private boolean[] blockFound;
    private byte[] lightLevels;
    private int[] topH;
    private MapBlock buildingObject = new MapBlock();
    private OverlayBuilder[] overlayBuilders;
    private class_2338.class_2339 mutableBlockPos;
    private List<class_2680> blockStatePalette;
    private class_6490 heightMapBitArray;
    private class_6490 blockStatesBitArray;
    private class_6490 biomesBitArray;
    private class_2487[] chunkNBTCompounds;
    public Object taskCreationSync;
    private BiomeKeyManager biomeKeyManager;
    private BlockStateShortShapeCache blockStateShortShapeCache;
    private BiomeKey defaultBiomeKey;
    private final CachedFunction<class_2688<?, ?>, Boolean> transparentCache;
    private int[] firstTransparentStateY;
    private boolean[] shouldExtendTillTheBottom;
    private CachedFunction<class_3610, class_2680> fluidToBlock;

    public WorldDataReader(OverlayManager overlayManager, BiomeKeyManager biomeKeyManager, BlockStateShortShapeCache blockStateShortShapeCache) {
        this.underair = new boolean[256];
        this.blockFound = new boolean[256];
        this.lightLevels = new byte[256];
        this.overlayBuilders = new OverlayBuilder[256];
        this.mutableBlockPos = new class_2338.class_2339();
        this.blockStatePalette = new ArrayList<class_2680>();
        this.heightMapBitArray = new class_3508(9, 256);
        this.taskCreationSync = new Object();
        for (int i = 0; i < this.overlayBuilders.length; ++i) {
            this.overlayBuilders[i] = new OverlayBuilder(overlayManager);
        }
        this.chunkNBTCompounds = new class_2487[16];
        this.biomeKeyManager = biomeKeyManager;
        this.topH = new int[256];
        this.blockStateShortShapeCache = blockStateShortShapeCache;
        this.defaultBiomeKey = biomeKeyManager.get(class_1972.field_9423.method_29177().toString());
        this.biomesBitArray = new class_3508(1, 64);
        this.transparentCache = new CachedFunction<class_2688, Boolean>(state -> this.mapProcessor.getMapWriter().shouldOverlay((class_2688<?, ?>)state));
        this.shouldExtendTillTheBottom = new boolean[256];
        this.firstTransparentStateY = new int[256];
        this.fluidToBlock = new CachedFunction<class_3610, class_2680>(class_3610::method_15759);
    }

    public void setMapProcessor(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
    }

    private void updateHeightArray(int bitsPerHeight) {
        if (this.heightMapBitArray.method_34896() != bitsPerHeight) {
            this.heightMapBitArray = new class_3508(bitsPerHeight, 256);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildRegion(MapRegion region, class_3218 worldServer, class_1937 world, boolean loading, int[] chunkCountDest) {
        boolean regionIsResting;
        if (!loading) {
            region.pushWriterPause();
        }
        boolean result = true;
        int prevRegX = region.getRegionX();
        int prevRegZ = region.getRegionZ() - 1;
        MapRegion prevRegion = this.mapProcessor.getMapRegion(prevRegX, prevRegZ, false);
        MapRegion mapRegion = region;
        synchronized (mapRegion) {
            regionIsResting = region.isResting();
            if (!loading && regionIsResting) {
                region.setBeingWritten(true);
                region.setShouldCache(false, "world save");
                region.setReloadHasBeenRequested(false, "world save");
                region.setVersion(this.mapProcessor.getGlobalVersion());
                region.setCacheHashCode(WorldMap.settings.getRegionCacheHashCode());
                if (region.getLoadState() != 2) {
                    if (region.getLoadState() == 4) {
                        region.restoreBufferUpdateObjects();
                    }
                    region.setLoadState((byte)2);
                    region.setLastSaveTime(System.currentTimeMillis() + 100000L);
                    this.mapProcessor.addToProcess(region);
                } else {
                    this.mapProcessor.removeToRefresh(region);
                    region.setRefreshing(false);
                }
            }
        }
        int caveStart = this.mapProcessor.getCaveStart();
        boolean ignoreHeightmaps = this.mapProcessor.getMapWorld().isIgnoreHeightmaps();
        boolean flowers = WorldMap.settings.flowers;
        if (loading || region.getLoadState() == 2 && regionIsResting) {
            int worldBottomY = worldServer.method_31607();
            int worldTopY = worldServer.method_31600();
            class_3898 chunkManager = worldServer.method_14178().field_17254;
            class_2378<class_1959> biomeRegistry = region.getBiomeRegistry();
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    MapTileChunk tileChunk = region.getChunk(i, j);
                    if (tileChunk == null) {
                        tileChunk = new MapTileChunk(region, (region.getRegionX() << 3) + i, (region.getRegionZ() << 3) + j);
                        region.setChunk(i, j, tileChunk);
                    }
                    this.readChunkNBTCompounds((class_3977)chunkManager, tileChunk);
                    this.buildTileChunk(tileChunk, caveStart, ignoreHeightmaps, prevRegion, world, biomeRegistry, flowers, worldBottomY, worldTopY);
                    tileChunk.setLoadState((byte)2);
                    if (!tileChunk.includeInSave()) {
                        region.setChunk(i, j, null);
                        tileChunk.getLeafTexture().deleteTexturesAndBuffers();
                        tileChunk = null;
                        continue;
                    }
                    chunkCountDest[0] = chunkCountDest[0] + 1;
                }
            }
            if (region.isMultiplayer()) {
                region.setLastSaveTime(System.currentTimeMillis() - 60000L + 1500L);
            }
        } else {
            result = false;
        }
        if (!loading) {
            region.popWriterPause();
        }
        return result;
    }

    private void readChunkNBTCompounds(class_3977 chunkLoader, MapTileChunk tileChunk) {
        for (int xl = 0; xl < 4; ++xl) {
            for (int zl = 0; zl < 4; ++zl) {
                int i = zl << 2 | xl;
                try {
                    this.chunkNBTCompounds[i] = chunkLoader.method_23696(new class_1923(tileChunk.getX() * 4 + xl, tileChunk.getZ() * 4 + zl));
                    continue;
                }
                catch (IOException e) {
                    this.chunkNBTCompounds[i] = null;
                }
            }
        }
    }

    public class_2487 readChunk(class_2861 regionFile, class_1923 pos) throws IOException {
        try (DataInputStream datainputstream = regionFile.method_21873(pos);){
            if (datainputstream != null) {
                class_2487 class_24872 = class_2507.method_10627((DataInput)datainputstream);
                return class_24872;
            }
            class_2487 class_24873 = null;
            return class_24873;
        }
    }

    private void buildTileChunk(MapTileChunk tileChunk, int caveStart, boolean ignoreHeightmaps, MapRegion prevRegion, class_1937 world, class_2378<class_1959> biomeRegistry, boolean flowers, int worldBottomY, int worldTopY) {
        tileChunk.unincludeInSave();
        tileChunk.resetHeights();
        for (int insideX = 0; insideX < 4; ++insideX) {
            for (int insideZ = 0; insideZ < 4; ++insideZ) {
                int i;
                DataFixer fixer;
                MapTile tile = tileChunk.getTile(insideX, insideZ);
                int chunkX = (tileChunk.getX() << 2) + insideX;
                int chunkZ = (tileChunk.getZ() << 2) + insideZ;
                class_2487 nbttagcompound = this.chunkNBTCompounds[insideZ << 2 | insideX];
                if (nbttagcompound == null) {
                    if (tile == null) continue;
                    tileChunk.setChanged(true);
                    tileChunk.setTile(insideX, insideZ, null, this.blockStateShortShapeCache);
                    this.mapProcessor.getTilePool().addToPool(tile);
                    continue;
                }
                boolean createdTile = false;
                if (tile == null) {
                    tile = this.mapProcessor.getTilePool().get(this.mapProcessor.getCurrentDimension(), chunkX, chunkZ);
                    createdTile = true;
                }
                if (this.buildTile(nbttagcompound = class_2512.method_10688((DataFixer)(fixer = class_310.method_1551().method_1543()), (class_4284)class_4284.field_19214, (class_2487)nbttagcompound, (int)(i = nbttagcompound.method_10573("DataVersion", 99) ? nbttagcompound.method_10550("DataVersion") : -1)), tile, tileChunk, chunkX, chunkZ, caveStart, ignoreHeightmaps, world, biomeRegistry, flowers, worldBottomY, worldTopY)) {
                    tileChunk.setTile(insideX, insideZ, tile, this.blockStateShortShapeCache);
                    if (!createdTile) continue;
                    tileChunk.setChanged(true);
                    continue;
                }
                tileChunk.setTile(insideX, insideZ, null, this.blockStateShortShapeCache);
                this.mapProcessor.getTilePool().addToPool(tile);
            }
        }
        if (tileChunk.wasChanged()) {
            tileChunk.setToUpdateBuffers(true);
            tileChunk.setChanged(false);
        }
    }

    private boolean buildTile(class_2487 nbttagcompound, MapTile tile, MapTileChunk tileChunk, int chunkX, int chunkZ, int caveStart, boolean ignoreHeightmaps, class_1937 world, class_2378<class_1959> biomeRegistry, boolean flowers, int worldBottomY, int worldTopY) {
        boolean cave;
        boolean heightMapExists;
        String status;
        class_2487 levelCompound = nbttagcompound;
        boolean oldOptimizedChunk = levelCompound.method_10545("below_zero_retrogen");
        String string = status = !oldOptimizedChunk ? levelCompound.method_10558("Status") : levelCompound.method_10562("below_zero_retrogen").method_10558("target_status");
        if (class_2806.method_12168((String)status).method_16559() < class_2806.field_12800.method_16559()) {
            return false;
        }
        class_2499 sectionsList = levelCompound.method_10554("sections", 10);
        int fillCounter = 256;
        int[] topH = this.topH;
        int chunkBottomY = levelCompound.method_10550("yPos") * 16;
        boolean[] shouldExtendTillTheBottom = this.shouldExtendTillTheBottom;
        for (int i = 0; i < this.blockFound.length; ++i) {
            this.overlayBuilders[i].startBuilding();
            this.blockFound[i] = false;
            this.underair[i] = false;
            this.lightLevels[i] = 0;
            topH[i] = worldBottomY;
            shouldExtendTillTheBottom[i] = false;
        }
        boolean oldHeightMap = !levelCompound.method_10573("Heightmaps", 10);
        int[] oldHeightMapArray = null;
        if (oldHeightMap) {
            oldHeightMapArray = levelCompound.method_10561("HeightMap");
            heightMapExists = oldHeightMapArray.length == 256;
        } else {
            long[] heightMapArray = levelCompound.method_10562("Heightmaps").method_10565("WORLD_SURFACE");
            int potentialBitsPerHeight = heightMapArray.length / 4;
            boolean bl = heightMapExists = potentialBitsPerHeight > 0 && potentialBitsPerHeight <= 10;
            if (heightMapExists) {
                this.updateHeightArray(potentialBitsPerHeight);
                System.arraycopy(heightMapArray, 0, this.heightMapBitArray.method_15212(), 0, heightMapArray.length);
            }
        }
        boolean bl = cave = caveStart != Short.MAX_VALUE;
        if (sectionsList.size() == 0) {
            for (i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    MapBlock currentPixel = tile.getBlock(i, j);
                    this.buildingObject.prepareForWriting(worldBottomY);
                    this.buildingObject.write(class_2246.field_10124.method_9564(), worldBottomY, worldBottomY, null, (byte)0, false, cave);
                    tile.setBlock(i, j, this.buildingObject);
                    this.buildingObject = currentPixel != null ? currentPixel : new MapBlock();
                }
            }
        } else {
            for (i = sectionsList.size() - 1; i >= 0 && fillCounter > 0; --i) {
                class_2487 sectionCompound = sectionsList.method_10602(i);
                boolean hasBlocks = false;
                class_2487 blockStatesCompound = null;
                if (sectionCompound.method_10573("block_states", 10) && !(hasBlocks = (blockStatesCompound = sectionCompound.method_10562("block_states")).method_10573("data", 12)) && blockStatesCompound.method_10573("palette", 9)) {
                    class_2499 paletteList = blockStatesCompound.method_10554("palette", 10);
                    boolean bl2 = hasBlocks = paletteList.size() == 1 && !((class_2487)paletteList.method_10534(0)).method_10580("Name").method_10714().equals("minecraft:air");
                }
                if (i > 0 && !hasBlocks && !sectionCompound.method_10573("BlockLight", 7)) continue;
                boolean preparedSectionData = false;
                boolean hasDifferentBlockStates = false;
                class_2499 biomePaletteList = null;
                boolean hasDifferentBiomes = false;
                byte[] lightMap = null;
                int sectionHeight = sectionCompound.method_10571("Y") * 16;
                int sectionBasedHeight = sectionHeight + 15;
                for (int z = 0; z < 16; ++z) {
                    block5: for (int x = 0; x < 16; ++x) {
                        int startHeight;
                        int pos_2d = (z << 4) + x;
                        if (this.blockFound[pos_2d]) continue;
                        if (cave) {
                            startHeight = caveStart;
                        } else {
                            int height = heightMapExists ? (oldHeightMap ? oldHeightMapArray[pos_2d] : chunkBottomY + this.heightMapBitArray.method_15211(pos_2d)) : Integer.MIN_VALUE;
                            startHeight = ignoreHeightmaps || height < chunkBottomY ? sectionBasedHeight : height + 3;
                        }
                        if (startHeight >= worldTopY) {
                            startHeight = worldTopY - 1;
                        }
                        if (i > 0 && startHeight < sectionHeight) continue;
                        int localStartHeight = 15;
                        if (startHeight >> 4 << 4 == sectionHeight) {
                            localStartHeight = startHeight & 0xF;
                        }
                        if (!preparedSectionData) {
                            class_2487 biomesCompound;
                            if (hasBlocks) {
                                class_2499 paletteList = blockStatesCompound.method_10554("palette", 10);
                                hasDifferentBlockStates = blockStatesCompound.method_10573("data", 12) && paletteList.size() > 1;
                                boolean shouldReadPalette = true;
                                if (hasDifferentBlockStates) {
                                    long[] blockStatesArray = blockStatesCompound.method_10565("data");
                                    int bits = blockStatesArray.length * 64 / 4096;
                                    int bitsOther = Math.max(4, class_3532.method_15342((int)paletteList.size()));
                                    if (bitsOther > 8) {
                                        bits = bitsOther;
                                    }
                                    if (this.blockStatesBitArray == null || this.blockStatesBitArray.method_34896() != bits) {
                                        this.blockStatesBitArray = new class_3508(bits, 4096);
                                    }
                                    if (blockStatesArray.length == this.blockStatesBitArray.method_15212().length) {
                                        System.arraycopy(blockStatesArray, 0, this.blockStatesBitArray.method_15212(), 0, blockStatesArray.length);
                                    } else {
                                        hasDifferentBlockStates = false;
                                        shouldReadPalette = false;
                                    }
                                }
                                this.blockStatePalette.clear();
                                if (shouldReadPalette) {
                                    paletteList.forEach(stateTag -> {
                                        class_2680 state = class_2512.method_10681((class_2487)((class_2487)stateTag));
                                        this.blockStatePalette.add(state);
                                    });
                                }
                            }
                            if ((hasBlocks || i == 0) && sectionCompound.method_10573("biomes", 10) && (biomesCompound = sectionCompound.method_10562("biomes")).method_10573("palette", 9)) {
                                biomePaletteList = biomesCompound.method_10554("palette", 8);
                                boolean bl3 = hasDifferentBiomes = biomesCompound.method_10573("data", 12) && biomePaletteList.size() > 1;
                                if (hasDifferentBiomes) {
                                    long[] biomesLongArray = biomesCompound.method_10565("data");
                                    int bits = class_3532.method_15342((int)biomePaletteList.size());
                                    if (this.biomesBitArray == null || this.biomesBitArray.method_34896() != bits) {
                                        this.biomesBitArray = new class_3508(bits, 64);
                                    }
                                    if (biomesLongArray.length == this.biomesBitArray.method_15212().length) {
                                        System.arraycopy(biomesLongArray, 0, this.biomesBitArray.method_15212(), 0, biomesLongArray.length);
                                    } else {
                                        biomePaletteList = null;
                                    }
                                }
                            }
                            if (sectionCompound.method_10573("BlockLight", 7) && (lightMap = sectionCompound.method_10547("BlockLight")).length != 2048) {
                                lightMap = null;
                            }
                            preparedSectionData = true;
                        }
                        for (int y = localStartHeight; y >= 0; --y) {
                            boolean buildResult;
                            int h = sectionHeight | y;
                            BiomeKey biome = null;
                            int pos = y << 8 | pos_2d;
                            class_2680 state = null;
                            if (hasBlocks) {
                                int indexInPalette;
                                int n = indexInPalette = hasDifferentBlockStates ? this.blockStatesBitArray.method_15211(pos) : 0;
                                if (indexInPalette < this.blockStatePalette.size()) {
                                    state = this.blockStatePalette.get(indexInPalette);
                                }
                            }
                            if (state == null) {
                                state = class_2246.field_10124.method_9564();
                            }
                            if (biomePaletteList != null) {
                                int biomeIndexInPalette;
                                int n = biomeIndexInPalette = hasDifferentBiomes ? this.biomesBitArray.method_15211(x >> 2 | z >> 2 << 2 | y >> 2 << 4) : 0;
                                if (biomeIndexInPalette < biomePaletteList.size()) {
                                    biome = this.biomeKeyManager.get(biomePaletteList.method_10534(biomeIndexInPalette).method_10714());
                                }
                            }
                            if (biome == null) {
                                biome = this.defaultBiomeKey;
                            }
                            this.mutableBlockPos.method_10103(chunkX << 4 | x, h, chunkZ << 4 | z);
                            OverlayBuilder overlayBuilder = this.overlayBuilders[pos_2d];
                            byte light = this.lightLevels[pos_2d];
                            if (!shouldExtendTillTheBottom[pos_2d] && !overlayBuilder.isEmpty() && this.firstTransparentStateY[pos_2d] - h >= 5) {
                                shouldExtendTillTheBottom[pos_2d] = true;
                            }
                            if (!(buildResult = this.buildPixel(this.buildingObject, state, x, h, z, pos_2d, light, biome, cave, overlayBuilder, world, this.mutableBlockPos, biomeRegistry, topH, shouldExtendTillTheBottom[pos_2d], flowers)) && y == 0 && i == 0) {
                                h = worldBottomY;
                                state = class_2246.field_10124.method_9564();
                                buildResult = true;
                            }
                            if (buildResult) {
                                BiomeKey blockBiome = biome;
                                this.buildingObject.prepareForWriting(worldBottomY);
                                overlayBuilder.finishBuilding(this.buildingObject);
                                if (overlayBuilder.getOverlayBiome() != null) {
                                    blockBiome = overlayBuilder.getOverlayBiome();
                                }
                                boolean glowing = this.mapProcessor.getMapWriter().isGlowing(state);
                                this.buildingObject.write(state, h, topH[pos_2d], blockBiome, light, glowing, cave);
                                MapBlock currentPixel = tile.getBlock(x, z);
                                boolean equalsSlopesExcluded = this.buildingObject.equalsSlopesExcluded(currentPixel);
                                boolean fullyEqual = this.buildingObject.equals(currentPixel, equalsSlopesExcluded);
                                if (!fullyEqual) {
                                    tile.setBlock(x, z, this.buildingObject);
                                    this.buildingObject = currentPixel != null ? currentPixel : new MapBlock();
                                    if (!equalsSlopesExcluded) {
                                        tileChunk.setChanged(true);
                                    }
                                }
                                this.blockFound[pos_2d] = true;
                                --fillCounter;
                                continue block5;
                            }
                            this.lightLevels[pos_2d] = lightMap == null ? (byte)0 : this.nibbleValue(lightMap, pos);
                        }
                    }
                }
            }
        }
        tile.setWrittenOnce(true);
        tile.setLoaded(true);
        tile.setWorldInterpretationVersion(1);
        return true;
    }

    private boolean buildPixel(MapBlock pixel, class_2680 state, int x, int h, int z, int pos_2d, byte light, BiomeKey biome, boolean cave, OverlayBuilder overlayBuilder, class_1937 world, class_2338.class_2339 mutableBlockPos, class_2378<class_1959> biomeRegistry, int[] topH, boolean shouldExtendTillTheBottom, boolean flowers) {
        class_2248 b;
        class_3610 fluidFluidState = state.method_26227();
        if (!fluidFluidState.method_15769()) {
            this.underair[pos_2d] = true;
            class_2680 fluidState = this.fluidToBlock.apply(fluidFluidState);
            if (this.buildPixelHelp(pixel, fluidState, fluidState.method_26204(), fluidFluidState, pos_2d, h, cave, light, biome, overlayBuilder, world, biomeRegistry, topH, shouldExtendTillTheBottom, flowers)) {
                return true;
            }
        }
        if ((b = state.method_26204()) instanceof class_2189) {
            this.underair[pos_2d] = true;
            return false;
        }
        if (!this.underair[pos_2d] && cave) {
            return false;
        }
        if (b == this.fluidToBlock.apply(fluidFluidState).method_26204()) {
            return false;
        }
        return this.buildPixelHelp(pixel, state, state.method_26204(), null, pos_2d, h, cave, light, biome, overlayBuilder, world, biomeRegistry, topH, shouldExtendTillTheBottom, flowers);
    }

    private boolean buildPixelHelp(MapBlock pixel, class_2680 state, class_2248 b, class_3610 fluidFluidState, int pos_2d, int h, boolean cave, byte light, BiomeKey dataBiome, OverlayBuilder overlayBuilder, class_1937 world, class_2378<class_1959> biomeRegistry, int[] topH, boolean shouldExtendTillTheBottom, boolean flowers) {
        if (this.shouldOverlayCached((class_2688<?, ?>)(fluidFluidState == null ? state : fluidFluidState))) {
            if (h > topH[pos_2d]) {
                topH[pos_2d] = h;
            }
            if (overlayBuilder.isEmpty()) {
                this.firstTransparentStateY[pos_2d] = h;
            }
            if (shouldExtendTillTheBottom) {
                overlayBuilder.getCurrentOverlay().increaseOpacity(overlayBuilder.getCurrentOverlay().getState().method_26193((class_1922)world, (class_2338)this.mutableBlockPos));
            } else {
                overlayBuilder.build(state, state.method_26193((class_1922)world, (class_2338)this.mutableBlockPos), light, this.mapProcessor, dataBiome);
            }
            return false;
        }
        if (this.mapProcessor.getMapWriter().isInvisible(world, state, b, flowers)) {
            return false;
        }
        if (h > topH[pos_2d]) {
            topH[pos_2d] = h;
        }
        return true;
    }

    private boolean shouldOverlayCached(class_2688<?, ?> state) {
        return this.transparentCache.apply(state);
    }

    private byte nibbleValue(byte[] array, int index) {
        byte b = array[index >> 1];
        if ((index & 1) == 0) {
            return (byte)(b & 0xF);
        }
        return (byte)(b >> 4 & 0xF);
    }
}

