/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.category.ui.data.options.text;

import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import xaero.common.category.ui.data.GuiCategoryUIEditorExpandableData;
import xaero.common.category.ui.data.options.GuiCategoryUIEditorExpandingOptionsData;
import xaero.common.category.ui.data.options.GuiCategoryUIEditorOptionData;
import xaero.common.category.ui.data.options.GuiCategoryUIEditorOptionsData;
import xaero.common.category.ui.data.options.text.TextFieldSuggestionsResolver;
import xaero.common.category.ui.entry.CategorySettingsListEntryExpandingOptions;
import xaero.common.category.ui.entry.CategorySettingsListEntryWrapper;
import xaero.common.category.ui.entry.CategorySettingsListMainEntryFactory;
import xaero.common.category.ui.entry.widget.CategorySettingsTextField;
import xaero.common.graphics.CursorBox;
import xaero.common.misc.ListFactory;

public final class GuiCategoryUIEditorTextFieldOptionsData
extends GuiCategoryUIEditorExpandingOptionsData<String> {
    private String input;
    private String result;
    private int cursorPos;
    private int highlightPos;
    private final int maxLength;
    private CategorySettingsTextField.UpdatedValueConsumer updatedValueConsumer;
    private List<GuiCategoryUIEditorOptionData<String>> suggestions;
    private final TextFieldSuggestionsResolver suggestionsResolver;
    private final boolean allowAnyInput;
    private final boolean autoConfirm;

    protected GuiCategoryUIEditorTextFieldOptionsData(@Nonnull String displayName, @Nonnull String input, int maxLength, @Nonnull GuiCategoryUIEditorOptionData<String> currentValue, @Nonnull List<GuiCategoryUIEditorOptionData<String>> options, @Nonnull TextFieldSuggestionsResolver suggestionsResolver, boolean movable, @Nonnull CategorySettingsListMainEntryFactory listEntryFactory, boolean allowAnyInput, boolean autoConfirm, BiFunction<GuiCategoryUIEditorExpandableData<?>, GuiCategoryUIEditorExpandableData<GuiCategoryUIEditorOptionData<String>>, Supplier<CursorBox>> tooltipSupplier, GuiCategoryUIEditorOptionsData.IOptionsDataIsActiveSupplier isActiveSupplier) {
        super(displayName, currentValue, options, movable, listEntryFactory, tooltipSupplier, isActiveSupplier);
        this.maxLength = maxLength;
        this.resetInput(input);
        this.suggestionsResolver = suggestionsResolver;
        this.allowAnyInput = allowAnyInput;
        this.autoConfirm = autoConfirm;
    }

    public void resetInput(String input) {
        this.input = input;
        this.result = input;
        this.cursorPos = this.highlightPos = input.length();
    }

    @Override
    public void setCurrentValue(GuiCategoryUIEditorOptionData<String> currentValue) {
    }

    @Override
    public GuiCategoryUIEditorOptionData<String> getCurrentValue() {
        return GuiCategoryUIEditorOptionData.Builder.getDefault().setValue(this.input).build();
    }

    public String getInput() {
        return this.input;
    }

    public String getResult() {
        return this.result;
    }

    public int getCursorPos() {
        return this.cursorPos;
    }

    public int getHighlightPos() {
        return this.highlightPos;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setExpanded(boolean expanded) {
        if (!expanded) {
            this.resetInput(this.result);
            this.suggestions = null;
        }
        super.setExpanded(expanded);
    }

    @Override
    public boolean onSelected(GuiCategoryUIEditorOptionData<String> option) {
        boolean result = super.onSelected(option);
        this.resetInput(option.getValue().toString());
        return result;
    }

    public final CategorySettingsTextField.UpdatedValueConsumer getUpdatedValueConsumer() {
        if (this.updatedValueConsumer == null) {
            this.updatedValueConsumer = (s, c, h, rl) -> {
                this.cursorPos = c;
                this.highlightPos = h;
                String oldInput = this.input;
                if (oldInput == null || !oldInput.equals(s)) {
                    this.input = s;
                    this.suggestions = this.suggestionsResolver.getSuggestions(s, this.options);
                    if (this.autoConfirm) {
                        this.result = s;
                    }
                    if (!this.autoConfirm && this.allowAnyInput && !s.isEmpty()) {
                        this.suggestions.add(0, (GuiCategoryUIEditorOptionData<String>)GuiCategoryUIEditorOptionData.Builder.getDefault().setValue(s).build());
                    }
                    if (!this.suggestions.isEmpty()) {
                        this.setExpanded(true);
                    } else if (s.isEmpty()) {
                        this.setExpanded(false);
                    }
                    if (this.autoConfirm) {
                        rl.restoreScrollAfterUpdate();
                    }
                    rl.setLastExpandedData(this);
                    rl.updateEntries();
                }
            };
        }
        return this.updatedValueConsumer;
    }

    @Override
    public List<GuiCategoryUIEditorOptionData<String>> getSubExpandables() {
        return this.suggestions;
    }

    public static final class Builder
    extends GuiCategoryUIEditorExpandingOptionsData.Builder<String, Builder> {
        private String input;
        private int maxLength;
        private final GuiCategoryUIEditorOptionData.Builder<String> currentInputOption = GuiCategoryUIEditorOptionData.Builder.getDefault();
        private final TextFieldSuggestionsResolver.Builder suggestionsResolverBuilder;
        private boolean allowAnyInput;
        private boolean autoConfirm;

        protected Builder(ListFactory listFactory) {
            super(listFactory);
            this.suggestionsResolverBuilder = TextFieldSuggestionsResolver.Builder.getDefault(listFactory);
        }

        @Override
        public Builder setDefault() {
            super.setDefault();
            this.setInput("");
            this.setMaxLength(100);
            ((GuiCategoryUIEditorOptionData.Builder)this.currentInputOption.setDefault()).setDisplayName("null holder");
            this.setListEntryFactory((data, parent, index, lineType, rowList, screenWidth, isFinalExpanded) -> new CategorySettingsListEntryWrapper((x, y, width, height, root) -> new CategorySettingsListEntryExpandingOptions(x, y, width, height, index, rowList, root, (AbstractWidget)new CategorySettingsTextField(((GuiCategoryUIEditorTextFieldOptionsData)data).getUpdatedValueConsumer(), ((GuiCategoryUIEditorTextFieldOptionsData)data).getInput(), ((GuiCategoryUIEditorTextFieldOptionsData)data).getCursorPos(), ((GuiCategoryUIEditorTextFieldOptionsData)data).getHighlightPos(), ((GuiCategoryUIEditorTextFieldOptionsData)data).getMaxLength(), Minecraft.m_91087_().f_91062_, 214, 18, data.getDisplayName(), rowList), null, data.getTooltipSupplier(parent)), screenWidth, index, rowList, lineType, data));
            this.addOptionBuilder(this.currentInputOption);
            this.setAllowAnyInput(true);
            this.setAutoConfirm(true);
            this.suggestionsResolverBuilder.setDefault();
            return this;
        }

        public Builder setInput(String input) {
            this.input = input;
            return this;
        }

        public Builder setAllowAnyInput(boolean allowAnyInput) {
            this.allowAnyInput = allowAnyInput;
            return this;
        }

        public Builder setAutoConfirm(boolean autoConfirm) {
            this.autoConfirm = autoConfirm;
            return this;
        }

        public Builder setMaxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        @Override
        public Builder setCurrentValue(String currentValue) {
            return this;
        }

        @Override
        public GuiCategoryUIEditorTextFieldOptionsData build() {
            if (this.input == null) {
                throw new IllegalStateException("required fields not set!");
            }
            return (GuiCategoryUIEditorTextFieldOptionsData)super.build();
        }

        protected GuiCategoryUIEditorTextFieldOptionsData buildInternally(GuiCategoryUIEditorOptionData<String> currentValueData, List<GuiCategoryUIEditorOptionData<String>> options) {
            return new GuiCategoryUIEditorTextFieldOptionsData(this.displayName, this.input, this.maxLength, currentValueData, options, this.suggestionsResolverBuilder.build(), this.movable, this.listEntryFactory, this.allowAnyInput, this.autoConfirm, this.tooltipSupplier, this.isActiveSupplier);
        }

        public static Builder getDefault(ListFactory listFactory) {
            return new Builder(listFactory).setDefault();
        }
    }
}

