/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.patreon;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import javax.crypto.Cipher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.client.event.RenderPlayerEvent;
import xaero.common.MinimapLogs;
import xaero.common.patreon.PatreonMod;
import xaero.common.patreon.decrypt.DecryptInputStream;

public class Patreon {
    private static HashMap<Integer, ArrayList<String>> patrons = new HashMap();
    private static boolean notificationDisplayed;
    private static boolean loaded;
    private static boolean showCapes;
    private static int patronPledge;
    private static String updateLocation;
    private static HashMap<String, Object> mods;
    private static ArrayList<Object> outdatedMods;
    private static Cipher cipher;
    private static int KEY_VERSION;
    private static String publicKeyString;
    private static File optionsFile;
    private static String rendersCapes;
    private static ResourceLocation cape1;
    private static ResourceLocation cape2;
    private static ResourceLocation cape3;
    private static ResourceLocation cape4;
    private static boolean pauseCapes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkPatreon() {
        HashMap<Integer, ArrayList<String>> hashMap = patrons;
        synchronized (hashMap) {
            if (loaded) {
                return;
            }
            Patreon.loadSettings();
            Object s = "http://data.chocolateminecraft.com/Versions_" + Patreon.getKEY_VERSION() + "/Patreon.txt";
            s = ((String)s).replaceAll(" ", "%20");
            try {
                String[] args;
                String line;
                URL url = new URL((String)s);
                URLConnection conn = url.openConnection();
                conn.setReadTimeout(900);
                conn.setConnectTimeout(900);
                if (conn.getContentLengthLong() > 524288L) {
                    throw new IOException("Input too long to trust!");
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(new DecryptInputStream(conn.getInputStream(), cipher)));
                int pledge = -1;
                while ((line = reader.readLine()) != null && !line.equals("LAYOUTS")) {
                    if (line.startsWith("PATREON")) {
                        pledge = Integer.parseInt(line.substring(7));
                        patrons.put(pledge, new ArrayList());
                        continue;
                    }
                    if (pledge == -1) continue;
                    args = line.split("\\t");
                    patrons.get(pledge).add(args[0]);
                    if (!args[0].equalsIgnoreCase(Minecraft.m_91087_().m_91094_().m_92548_().getName())) continue;
                    Patreon.setPatronPledge(pledge);
                }
                updateLocation = reader.readLine();
                while ((line = reader.readLine()) != null) {
                    args = line.split("\\t");
                    Patreon.getMods().put(args[0], new PatreonMod(args[0], args[1], args[2], args[3]));
                }
                reader.close();
            }
            catch (Throwable e) {
                MinimapLogs.LOGGER.error("suppressed exception", e);
                patrons.clear();
                Patreon.getMods().clear();
            }
            finally {
                loaded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOutdatedMod(Object mod) {
        ArrayList<Object> arrayList = Patreon.getOutdatedMods();
        synchronized (arrayList) {
            Patreon.getOutdatedMods().add((PatreonMod)mod);
        }
    }

    public static int getPatronPledge(String name) {
        Integer[] keys = patrons.keySet().toArray(new Integer[0]);
        for (int i = 0; i < keys.length; ++i) {
            if (!patrons.get(keys[i]).contains(name)) continue;
            return keys[i];
        }
        return -1;
    }

    public static void saveSettings() {
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(optionsFile));
            writer.println("showCapes:" + Patreon.isShowCapes());
            writer.close();
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    public static void loadSettings() {
        try {
            String line;
            if (!optionsFile.exists()) {
                Patreon.saveSettings();
                return;
            }
            BufferedReader reader = new BufferedReader(new FileReader(optionsFile));
            while ((line = reader.readLine()) != null) {
                String[] args = line.split(":");
                if (!args[0].equalsIgnoreCase("showCapes")) continue;
                Patreon.setShowCapes(args[1].equals("true"));
            }
            reader.close();
        }
        catch (IOException e) {
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
    }

    public static ResourceLocation getPlayerCape(String modID, AbstractClientPlayer playerEntity) {
        if (!pauseCapes && Patreon.isShowCapes() && modID.equals(Patreon.getRendersCapes())) {
            ResourceLocation cape = null;
            int pledge = Patreon.getPatronPledge(playerEntity.m_7755_().getString());
            if (pledge == 2) {
                cape = cape1;
            } else if (pledge == 5) {
                cape = cape2;
            } else if (pledge == 10) {
                cape = cape3;
            } else if (pledge == 50) {
                cape = cape4;
            }
            if (cape == null) {
                return null;
            }
            pauseCapes = true;
            ResourceLocation realCape = playerEntity.m_108561_();
            boolean realIsWearing = playerEntity.m_36170_(PlayerModelPart.CAPE);
            pauseCapes = false;
            if (realCape != null && realIsWearing) {
                return realCape;
            }
            return cape;
        }
        return null;
    }

    public static Boolean isWearingCape(String modID, AbstractClientPlayer playerEntity) {
        if (!pauseCapes && Patreon.isShowCapes() && modID.equals(Patreon.getRendersCapes())) {
            pauseCapes = true;
            ResourceLocation realCape = playerEntity.m_108561_();
            boolean realIsWearing = playerEntity.m_36170_(PlayerModelPart.CAPE);
            pauseCapes = false;
            if (realIsWearing || realCape == null) {
                return realIsWearing;
            }
            int pledge = Patreon.getPatronPledge(playerEntity.m_7755_().getString());
            return pledge >= 2;
        }
        return null;
    }

    public static void renderCapeFallback(String modID, RenderPlayerEvent.Post event) {
        if (!event.getPlayer().m_6084_() || event.getPlayer().m_5803_() || event.getPlayer().m_6069_()) {
            return;
        }
        pauseCapes = true;
        ResourceLocation realCape = ((AbstractClientPlayer)event.getPlayer()).m_108561_();
        boolean realIsWearing = event.getPlayer().m_36170_(PlayerModelPart.CAPE);
        pauseCapes = false;
        if (realCape != null && realIsWearing || realCape == null && !realIsWearing) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)event.getPlayer();
        ResourceLocation cape = Patreon.getPlayerCape(modID, player);
        if (cape == null) {
            return;
        }
        ItemStack itemstack = player.m_6844_(EquipmentSlot.CHEST);
        if (itemstack == null || itemstack.m_41720_() != Items.f_42741_) {
            PoseStack matrixStack = event.getPoseStack();
            matrixStack.m_85836_();
            matrixStack.m_85841_(-1.0f, -1.0f, 1.0f);
            matrixStack.m_85837_(0.0, -1.35, 0.0);
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(player.f_20884_ + (player.f_20883_ - player.f_20884_) * event.getPartialTick()));
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.m_85837_(0.0, 0.0, 0.125);
            double d0 = player.f_36102_ + (player.f_36105_ - player.f_36102_) * (double)event.getPartialTick() - (player.f_19854_ + (player.m_20185_() - player.f_19854_) * (double)event.getPartialTick());
            double d1 = player.f_36103_ + (player.f_36106_ - player.f_36103_) * (double)event.getPartialTick() - (player.f_19855_ + (player.m_20186_() - player.f_19855_) * (double)event.getPartialTick());
            double d2 = player.f_36104_ + (player.f_36075_ - player.f_36104_) * (double)event.getPartialTick() - (player.f_19856_ + (player.m_20189_() - player.f_19856_) * (double)event.getPartialTick());
            float f = player.f_20884_ + (player.f_20883_ - player.f_20884_) * event.getPartialTick();
            double d3 = Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
            double d4 = -Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
            float f1 = (float)d1 * 10.0f;
            f1 = Mth.m_14036_((float)f1, (float)-6.0f, (float)32.0f);
            float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
            f2 = Mth.m_14036_((float)f2, (float)0.0f, (float)150.0f);
            float f3 = (float)(d0 * d4 - d2 * d3) * 100.0f;
            f3 = Mth.m_14036_((float)f3, (float)-20.0f, (float)20.0f);
            if (f2 < 0.0f) {
                f2 = 0.0f;
            }
            float f4 = player.f_36099_ + (player.f_36100_ - player.f_36099_) * event.getPartialTick();
            f1 += Mth.m_14031_((float)((player.f_19867_ + (player.f_19787_ - player.f_19867_) * event.getPartialTick()) * 6.0f)) * 32.0f * f4;
            if (player.m_6144_()) {
                f1 += 25.0f;
            }
            matrixStack.m_85845_(Vector3f.f_122223_.m_122240_(6.0f + Math.min(90.0f, f2 / 2.0f) + f1));
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(f3 / 2.0f));
            matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - f3 / 2.0f));
            VertexConsumer ivertexbuilder = event.getMultiBufferSource().m_6299_(RenderType.m_110446_((ResourceLocation)cape));
            ((PlayerModel)event.getRenderer().m_7200_()).m_103411_(matrixStack, ivertexbuilder, event.getPackedLight(), OverlayTexture.f_118083_);
            matrixStack.m_85849_();
        }
    }

    public static ArrayList<Object> getOutdatedMods() {
        return outdatedMods;
    }

    public static boolean needsNotification() {
        return !Patreon.isNotificationDisplayed() && !outdatedMods.isEmpty();
    }

    public static int getPatronPledge() {
        return patronPledge;
    }

    public static void setPatronPledge(int patronPledge) {
        Patreon.patronPledge = patronPledge;
    }

    public static boolean isNotificationDisplayed() {
        return notificationDisplayed;
    }

    public static void setNotificationDisplayed(boolean notificationDisplayed) {
        Patreon.notificationDisplayed = notificationDisplayed;
    }

    public static HashMap<String, Object> getMods() {
        return mods;
    }

    public static String getUpdateLocation() {
        return updateLocation;
    }

    public static String getRendersCapes() {
        return rendersCapes;
    }

    public static void setRendersCapes(String rendersCapes) {
        Patreon.rendersCapes = rendersCapes;
    }

    public static String getPublicKeyString() {
        return publicKeyString;
    }

    public static int getKEY_VERSION() {
        return KEY_VERSION;
    }

    public static boolean isShowCapes() {
        return showCapes;
    }

    public static void setShowCapes(boolean showCapes) {
        Patreon.showCapes = showCapes;
    }

    static {
        loaded = false;
        showCapes = true;
        patronPledge = -1;
        mods = new HashMap();
        outdatedMods = new ArrayList();
        cipher = null;
        KEY_VERSION = 3;
        publicKeyString = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAgtweVog3N8aN7gUJrnVz1yoWLjmzWxltoVt+WDHbD/mOa8+P/m6+JK0ferlJ4a9hm97muj5JCQugFy3ATc/ZojNXiLzsmZgjgZbVvBvRbgyCr5/XQOaf0aRYgYuADcs4H6garVmLwaHaie+uLRdu0oytn1uBdOogbV+YGzJjnZq2ddtelz9vhD8tLflKaEbJVmopnNVI/2OKQAnwuHQYxDwArzLvMmyiOoLvnvrBC85+BuYOaHV9lDma2mz+h2VLCm5DywxmU1GyuMbqjFhgybR5hp5V+D6qBtDTsTv2YlG6bdmR+eszXyLO4qPdwfklMc0ae9sMG+Ygo3mGr94+XwIDAQAB";
        try {
            cipher = Cipher.getInstance("RSA");
            KeyFactory factory = KeyFactory.getInstance("RSA");
            byte[] byteKey = Base64.getDecoder().decode(Patreon.getPublicKeyString().getBytes());
            X509EncodedKeySpec X509publicKey = new X509EncodedKeySpec(byteKey);
            PublicKey publicKey = factory.generatePublic(X509publicKey);
            cipher.init(2, publicKey);
        }
        catch (Exception e) {
            cipher = null;
            MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
        }
        optionsFile = new File("./config/xaeropatreon.txt");
        rendersCapes = null;
        cape1 = new ResourceLocation("xaeropatreon", "capes/cape1.png");
        cape2 = new ResourceLocation("xaeropatreon", "capes/cape2.png");
        cape3 = new ResourceLocation("xaeropatreon", "capes/cape3.png");
        cape4 = new ResourceLocation("xaeropatreon", "capes/cape4.png");
        pauseCapes = false;
    }
}

