/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity.ai;

import com.github.alexthe666.alexsmobs.entity.EntityFroststalker;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

public class FroststalkerAIMelee
extends Goal {
    private final EntityFroststalker froststalker;
    private LivingEntity target;
    private boolean willJump = false;
    private boolean hasJumped = false;
    private boolean clockwise = false;
    private int pursuitTime = 0;
    private int maxPursuitTime = 0;
    private BlockPos pursuitPos = null;
    private int startingOrbit = 0;

    public FroststalkerAIMelee(EntityFroststalker froststalker) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.froststalker = froststalker;
    }

    public boolean m_8036_() {
        if (this.froststalker.m_5448_() != null && this.froststalker.m_5448_().m_6084_()) {
            if (this.froststalker.isValidLeader(this.froststalker.m_5448_())) {
                return this.froststalker.m_142581_() != null && this.froststalker.m_142581_().equals((Object)this.froststalker.m_5448_());
            }
            return !this.froststalker.isFleeingFire();
        }
        return false;
    }

    public boolean m_8045_() {
        return this.target != null && !this.froststalker.isValidLeader(this.target);
    }

    public void m_8056_() {
        this.target = this.froststalker.m_5448_();
        this.willJump = this.froststalker.m_21187_().nextInt(2) == 0;
        this.hasJumped = false;
        this.clockwise = this.froststalker.m_21187_().nextBoolean();
        this.pursuitPos = null;
        this.pursuitTime = 0;
        this.maxPursuitTime = 40 + this.froststalker.m_21187_().nextInt(40);
        this.startingOrbit = this.froststalker.m_21187_().nextInt(360);
        this.froststalker.frostJump();
    }

    public void m_8037_() {
        this.froststalker.setBipedal(true);
        this.froststalker.standFor(20);
        boolean flag = false;
        if ((this.hasJumped || this.froststalker.isTackling()) && this.froststalker.m_20096_()) {
            this.hasJumped = false;
            this.willJump = false;
            this.froststalker.setTackling(false);
        }
        if (this.target != null && this.target.m_6084_()) {
            if (this.pursuitTime < this.maxPursuitTime) {
                ++this.pursuitTime;
                this.pursuitPos = this.getBlockNearTarget();
                float extraSpeed = 0.2f * Math.max(5.0f - this.froststalker.m_20270_((Entity)this.target), 0.0f);
                if (this.pursuitPos != null) {
                    this.froststalker.m_21573_().m_26519_((double)this.pursuitPos.m_123341_(), (double)this.pursuitPos.m_123342_(), (double)this.pursuitPos.m_123343_(), (double)(1.0f + extraSpeed));
                } else {
                    this.froststalker.m_21573_().m_5624_((Entity)this.target, 1.0);
                }
            } else if (this.willJump && this.pursuitTime == this.maxPursuitTime) {
                this.froststalker.m_21391_((Entity)this.target, 180.0f, 10.0f);
                if (this.froststalker.m_20270_((Entity)this.target) > 10.0f) {
                    this.froststalker.m_21573_().m_5624_((Entity)this.target, 1.0);
                } else if (this.froststalker.m_20096_() && this.froststalker.m_142582_((Entity)this.target)) {
                    this.froststalker.setTackling(true);
                    this.hasJumped = true;
                    Vec3 vector3d = this.froststalker.m_20184_();
                    Vec3 vector3d1 = new Vec3(this.target.m_20185_() - this.froststalker.m_20185_(), 0.0, this.target.m_20189_() - this.froststalker.m_20189_());
                    if (vector3d1.m_82556_() > 1.0E-7) {
                        vector3d1 = vector3d1.m_82541_().m_82490_(0.9).m_82549_(vector3d.m_82490_(0.8));
                    }
                    this.froststalker.m_20334_(vector3d1.f_82479_, 0.6f, vector3d1.f_82481_);
                } else {
                    flag = true;
                }
            } else if (!this.froststalker.isTackling()) {
                this.froststalker.m_21573_().m_5624_((Entity)this.target, 1.0);
            }
            if (this.froststalker.isTackling() && this.froststalker.m_20270_((Entity)this.target) <= this.froststalker.m_20205_() + this.target.m_20205_() + 1.1f && this.froststalker.m_142582_((Entity)this.target)) {
                this.target.m_6469_(DamageSource.m_19370_((LivingEntity)this.froststalker), (float)this.froststalker.m_21133_(Attributes.f_22281_));
                this.m_8056_();
            }
            if (!flag && this.froststalker.m_20270_((Entity)this.target) <= this.froststalker.m_20205_() + this.target.m_20205_() + 1.1f && this.froststalker.m_142582_((Entity)this.target) && this.pursuitTime == this.maxPursuitTime) {
                if (!this.froststalker.isTackling()) {
                    this.froststalker.m_7327_((Entity)this.target);
                }
                this.m_8056_();
            }
        }
        if (!this.froststalker.m_20096_()) {
            this.froststalker.m_21391_((Entity)this.target, 180.0f, 10.0f);
            this.froststalker.f_20883_ = this.froststalker.m_146908_();
        }
    }

    public BlockPos getBlockNearTarget() {
        float radius = (float)(this.froststalker.m_21187_().nextInt(5) + 3) + this.target.m_20205_();
        float neg = this.froststalker.m_21187_().nextBoolean() ? 1.0f : -1.0f;
        float renderYawOffset = this.froststalker.f_20883_;
        int orbit = (int)((float)this.startingOrbit + (float)this.pursuitTime / (float)this.maxPursuitTime * 360.0f);
        float angle = (float)Math.PI / 180 * (float)(this.clockwise ? -orbit : orbit);
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos circlePos = new BlockPos(this.target.m_20185_() + extraX, this.target.m_20188_(), this.target.m_20189_() + extraZ);
        while (!this.froststalker.f_19853_.m_8055_(circlePos).m_60795_() && circlePos.m_123342_() < this.froststalker.f_19853_.m_151558_()) {
            circlePos = circlePos.m_7494_();
        }
        while (!this.froststalker.f_19853_.m_8055_(circlePos.m_7495_()).m_60634_((BlockGetter)this.froststalker.f_19853_, circlePos.m_7495_(), (Entity)this.froststalker) && circlePos.m_123342_() > 1) {
            circlePos = circlePos.m_7495_();
        }
        if (this.froststalker.m_21692_(circlePos) > -1.0f) {
            return circlePos;
        }
        return null;
    }

    public void m_8041_() {
        this.froststalker.setTackling(false);
    }
}

