/*
 * Decompiled with CFR 0.152.
 */
package dev.architectury.registry.block;

import com.google.common.collect.Maps;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.block.forge.ToolTypeImpl;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.tags.Tag;
import net.minecraft.world.item.Item;

public final class ToolType {
    private static final Map<String, ToolType> TYPES = Maps.newConcurrentMap();
    public static final ToolType PICKAXE = ToolType.create("pickaxe", ToolType::pickaxeTag);
    public static final ToolType AXE = ToolType.create("axe", ToolType::axeTag);
    public static final ToolType HOE = ToolType.create("hoe", ToolType::hoeTag);
    public static final ToolType SHOVEL = ToolType.create("shovel", ToolType::shovelTag);
    public final String forgeName;
    public final Supplier<Tag<Item>> fabricTag;
    private Object obj;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static Tag<Item> pickaxeTag() {
        return ToolTypeImpl.pickaxeTag();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static Tag<Item> axeTag() {
        return ToolTypeImpl.axeTag();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static Tag<Item> hoeTag() {
        return ToolTypeImpl.hoeTag();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static Tag<Item> shovelTag() {
        return ToolTypeImpl.shovelTag();
    }

    private ToolType(String forgeName, Supplier<Tag<Item>> fabricTag) {
        this.forgeName = forgeName;
        this.fabricTag = fabricTag;
    }

    public static ToolType create(String forgeName, Supplier<Tag<Item>> fabricTag) {
        return TYPES.computeIfAbsent(forgeName, s -> new ToolType((String)s, fabricTag));
    }

    public static ToolType byName(String forgeName) {
        return TYPES.get(forgeName);
    }
}

