/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.loot;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class RollLootTableLootModifier
extends LootModifier {
    private final ResourceLocation target;
    private final ResourceLocation lootTable;

    public RollLootTableLootModifier(LootItemCondition[] conditions, ResourceLocation target, ResourceLocation lootTable) {
        super(conditions);
        this.target = target;
        this.lootTable = lootTable;
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (this.target.equals((Object)context.getQueriedLootTableId())) {
            context.m_78940_(this.lootTable).m_79148_(context, generatedLoot::add);
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<RollLootTableLootModifier> {
        public RollLootTableLootModifier read(ResourceLocation location, JsonObject object, LootItemCondition[] conditions) {
            ResourceLocation targetLootTable = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"target"));
            ResourceLocation lootTable = new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"lootTable"));
            return new RollLootTableLootModifier(conditions, targetLootTable, lootTable);
        }

        public JsonObject write(RollLootTableLootModifier instance) {
            JsonObject object = this.makeConditions(instance.conditions);
            object.addProperty("target", instance.target.toString());
            object.addProperty("lootTable", instance.lootTable.toString());
            return object;
        }
    }
}

