/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.citadel.server.generation;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;

public class SurfaceRulesManager {
    private static final List<SurfaceRules.RuleSource> OVERWORLD_REGISTRY = new ArrayList<SurfaceRules.RuleSource>();
    private static final List<SurfaceRules.RuleSource> NETHER_REGISTRY = new ArrayList<SurfaceRules.RuleSource>();
    private static final List<SurfaceRules.RuleSource> END_REGISTRY = new ArrayList<SurfaceRules.RuleSource>();
    private static final List<SurfaceRules.RuleSource> CAVE_REGISTRY = new ArrayList<SurfaceRules.RuleSource>();
    private static SurfaceRules.RuleSource overworldRules;
    private static SurfaceRules.RuleSource netherRules;
    private static SurfaceRules.RuleSource endRules;
    private static SurfaceRules.RuleSource caveRules;
    private static boolean mergedOverworld;
    private static boolean mergedNether;
    private static boolean mergedEnd;
    private static boolean mergedCaves;

    public static void registerOverworldSurfaceRule(SurfaceRules.ConditionSource condition, SurfaceRules.RuleSource rule) {
        SurfaceRulesManager.registerOverworldSurfaceRule(SurfaceRules.m_189394_((SurfaceRules.ConditionSource)condition, (SurfaceRules.RuleSource)rule));
    }

    public static void registerOverworldSurfaceRule(SurfaceRules.RuleSource rule) {
        OVERWORLD_REGISTRY.add(rule);
    }

    public static void registerNetherSurfaceRule(SurfaceRules.ConditionSource condition, SurfaceRules.RuleSource rule) {
        SurfaceRulesManager.registerNetherSurfaceRule(SurfaceRules.m_189394_((SurfaceRules.ConditionSource)condition, (SurfaceRules.RuleSource)rule));
    }

    public static void registerNetherSurfaceRule(SurfaceRules.RuleSource rule) {
        NETHER_REGISTRY.add(rule);
    }

    public static void registerEndSurfaceRule(SurfaceRules.ConditionSource condition, SurfaceRules.RuleSource rule) {
        SurfaceRulesManager.registerEndSurfaceRule(SurfaceRules.m_189394_((SurfaceRules.ConditionSource)condition, (SurfaceRules.RuleSource)rule));
    }

    public static void registerEndSurfaceRule(SurfaceRules.RuleSource rule) {
        END_REGISTRY.add(rule);
    }

    public static void registerCaveSurfaceRule(SurfaceRules.ConditionSource condition, SurfaceRules.RuleSource rule) {
        SurfaceRulesManager.registerCaveSurfaceRule(SurfaceRules.m_189394_((SurfaceRules.ConditionSource)condition, (SurfaceRules.RuleSource)rule));
    }

    public static void registerCaveSurfaceRule(SurfaceRules.RuleSource rule) {
        CAVE_REGISTRY.add(rule);
    }

    public static SurfaceRules.RuleSource process(NoiseGeneratorSettings settings, SurfaceRules.RuleSource prev) {
        SurfaceRules.RuleSource[] rules;
        if (settings.m_64476_(NoiseGeneratorSettings.f_64432_) || settings.m_64476_(NoiseGeneratorSettings.f_188869_) || settings.m_64476_(NoiseGeneratorSettings.f_64433_)) {
            if (!mergedOverworld) {
                if (!OVERWORLD_REGISTRY.isEmpty()) {
                    rules = OVERWORLD_REGISTRY.toArray(new SurfaceRules.RuleSource[0]);
                    overworldRules = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_198272_((SurfaceRules.RuleSource[])rules), prev});
                }
                mergedOverworld = true;
            }
            if (overworldRules != null) {
                return overworldRules;
            }
        }
        if (settings.m_64476_(NoiseGeneratorSettings.f_64434_)) {
            if (!mergedNether) {
                if (!NETHER_REGISTRY.isEmpty()) {
                    rules = NETHER_REGISTRY.toArray(new SurfaceRules.RuleSource[0]);
                    netherRules = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_198272_((SurfaceRules.RuleSource[])rules), prev});
                }
                mergedNether = true;
            }
            if (netherRules != null) {
                return netherRules;
            }
        }
        if (settings.m_64476_(NoiseGeneratorSettings.f_64435_)) {
            if (!mergedEnd) {
                if (!END_REGISTRY.isEmpty()) {
                    rules = END_REGISTRY.toArray(new SurfaceRules.RuleSource[0]);
                    endRules = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_198272_((SurfaceRules.RuleSource[])rules), prev});
                }
                mergedEnd = true;
            }
            if (endRules != null) {
                return endRules;
            }
        }
        if (settings.m_64476_(NoiseGeneratorSettings.f_64436_)) {
            if (!mergedCaves) {
                if (!CAVE_REGISTRY.isEmpty()) {
                    rules = CAVE_REGISTRY.toArray(new SurfaceRules.RuleSource[0]);
                    caveRules = SurfaceRules.m_198272_((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.m_198272_((SurfaceRules.RuleSource[])rules), prev});
                }
                mergedCaves = true;
            }
            if (caveRules != null) {
                return caveRules;
            }
        }
        return prev;
    }
}

