/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.entity;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;
import samebutdifferent.ecologics.registry.ModItems;
import samebutdifferent.ecologics.registry.ModSoundEvents;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class CoconutCrab
extends Animal
implements IAnimatable,
NeutralMob {
    private static final EntityDataAccessor<Boolean> HAS_COCONUT = SynchedEntityData.m_135353_(CoconutCrab.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public CoconutCrab(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel pLevel, AgeableMob pMob) {
        return null;
    }

    public boolean m_6898_(ItemStack pStack) {
        return false;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, new CrabAvoidGoal<Player>(this, Player.class, 8.0f, 2.0, 2.0));
        this.f_21345_.m_25352_(2, (Goal)new CrabMeleeAttackGoal(this, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new CrabNearestAttackableTargetGoal<Player>(this, Player.class, 10, true, false, arg_0 -> ((CoconutCrab)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 2.0).m_22268_((Attribute)ForgeMod.REACH_DISTANCE.get(), 3.0);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return super.m_6469_(pSource, this.hasCoconut() ? pAmount / 2.0f : pAmount);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21223_() <= this.m_21233_() / 2.0f && this.hasCoconut()) {
            this.breakCoconut();
        }
    }

    private void breakCoconut() {
        this.setHasCoconut(false);
        this.m_21662_();
        this.playCoconutSmashSound();
        ItemEntity itementity = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)ModItems.COCONUT_SLICE.get(), 2));
        itementity.m_32060_();
        this.f_19853_.m_7967_((Entity)itementity);
    }

    public boolean m_6040_() {
        return true;
    }

    protected float m_6108_() {
        return 0.98f;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    public void setHasCoconut(boolean hasCoconut) {
        this.f_19804_.m_135381_(HAS_COCONUT, (Object)hasCoconut);
    }

    public boolean hasCoconut() {
        return (Boolean)this.f_19804_.m_135370_(HAS_COCONUT);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_COCONUT, (Object)true);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSoundEvents.COCONUT_CRAB_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)ModSoundEvents.COCONUT_CRAB_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSoundEvents.COCONUT_CRAB_DEATH.get();
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    protected void playCoconutSmashSound() {
        this.m_5496_((SoundEvent)ModSoundEvents.COCONUT_SMASH.get(), 0.5f, 1.0f);
    }

    private static <P extends IAnimatable> PlayState predicate(AnimationEvent<P> event) {
        if (event.isMoving()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.coconut_crab.walk", Boolean.valueOf(true)));
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.coconut_crab.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, CoconutCrab::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public int m_6784_() {
        return this.remainingPersistentAngerTime;
    }

    public void m_7870_(int pTime) {
        this.remainingPersistentAngerTime = pTime;
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_142270_(this.f_19796_));
    }

    static class CrabAvoidGoal<T extends LivingEntity>
    extends AvoidEntityGoal<T> {
        private final CoconutCrab crab;

        public CrabAvoidGoal(CoconutCrab pMob, Class<T> pEntityClassToAvoid, float pMaxDistance, double pWalkSpeedModifier, double pSprintSpeedModifier) {
            super((PathfinderMob)pMob, pEntityClassToAvoid, pMaxDistance, pWalkSpeedModifier, pSprintSpeedModifier, EntitySelector.f_20408_::test);
            this.crab = pMob;
        }

        public boolean m_8036_() {
            return !this.crab.hasCoconut() && super.m_8036_();
        }
    }

    static class CrabMeleeAttackGoal
    extends MeleeAttackGoal {
        private final CoconutCrab crab;

        public CrabMeleeAttackGoal(CoconutCrab pMob, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)pMob, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.crab = pMob;
        }

        public boolean m_8036_() {
            return this.crab.hasCoconut() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.crab.hasCoconut() && super.m_8045_();
        }

        public void m_8056_() {
            if (!this.crab.hasCoconut()) {
                this.crab.m_21561_(false);
                this.m_8041_();
            } else {
                super.m_8056_();
            }
        }
    }

    static class CrabNearestAttackableTargetGoal<T extends LivingEntity>
    extends NearestAttackableTargetGoal<T> {
        private final CoconutCrab crab;

        public CrabNearestAttackableTargetGoal(CoconutCrab pMob, Class<T> pTargetType, int pRandomInterval, boolean pMustSee, boolean pMustReach, @Nullable Predicate<LivingEntity> pTargetPredicate) {
            super((Mob)pMob, pTargetType, pRandomInterval, pMustSee, pMustReach, pTargetPredicate);
            this.crab = pMob;
        }

        public boolean m_8036_() {
            return this.crab.hasCoconut() && super.m_8036_();
        }
    }
}

