/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.entity;

import java.util.Iterator;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cod;
import net.minecraft.world.entity.animal.Salmon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import samebutdifferent.ecologics.registry.ModEntityTypes;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class Penguin
extends Animal
implements IAnimatable {
    private static final EntityDataAccessor<Boolean> PREGNANT = SynchedEntityData.m_135353_(Penguin.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final Ingredient FOOD_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_, Items.f_42527_});
    private final AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public Penguin(EntityType<? extends Animal> type, Level level) {
        super(type, level);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.4f, 1.0f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 20);
        this.f_19793_ = 1.0f;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 2.0);
    }

    public void m_6075_() {
        int airSupply = this.m_20146_();
        super.m_6075_();
        if (!this.m_21525_()) {
            this.handleAirSupply(airSupply);
        }
    }

    public int m_6062_() {
        return 6000;
    }

    protected void handleAirSupply(int airSupply) {
        if (this.m_6084_() && !this.m_20071_()) {
            this.m_20301_(airSupply - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(DamageSource.f_19324_, 2.0f);
            }
        } else {
            this.m_20301_(this.m_6062_());
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Cod.class, false));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Salmon.class, false));
    }

    protected PathNavigation m_6037_(Level pLevel) {
        return new PenguinPathNavigation(this, pLevel);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)ModEntityTypes.PENGUIN.get()).m_20615_((Level)level);
    }

    public boolean m_6898_(ItemStack pStack) {
        return FOOD_ITEMS.test(pStack);
    }

    public boolean isPregnant() {
        return (Boolean)this.f_19804_.m_135370_(PREGNANT);
    }

    public void setPregnant(boolean isPregnant) {
        this.f_19804_.m_135381_(PREGNANT, (Object)isPregnant);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PREGNANT, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("IsPregnant", this.isPregnant());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setPregnant(pCompound.m_128471_("IsPregnant"));
    }

    public void m_27563_(ServerLevel level, Animal otherParent) {
        ServerPlayer serverplayer = this.m_27592_();
        if (serverplayer == null && otherParent.m_27592_() != null) {
            serverplayer = otherParent.m_27592_();
        }
        if (serverplayer != null) {
            serverplayer.m_36220_(Stats.f_12937_);
            CriteriaTriggers.f_10581_.m_147278_(serverplayer, (Animal)this, otherParent, null);
        }
        this.m_146762_(6000);
        otherParent.m_146762_(6000);
        this.m_27594_();
        otherParent.m_27594_();
        level.m_7605_((Entity)this, (byte)18);
        this.setPregnant(true);
        if (level.m_46469_().m_46207_(GameRules.f_46135_)) {
            level.m_7967_((Entity)new ExperienceOrb((Level)level, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_21187_().nextInt(7) + 1));
        }
    }

    protected void m_142669_() {
        super.m_142669_();
        if (!this.m_6162_() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46135_)) {
            this.m_20000_((ItemLike)Items.f_41877_, 1);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isPregnant() && this.f_19796_.nextInt(1500) == 0 && !this.f_19853_.f_46443_) {
            ServerLevel level = (ServerLevel)this.f_19853_;
            this.setPregnant(false);
            Penguin penguin = (Penguin)((EntityType)ModEntityTypes.PENGUIN.get()).m_20615_((Level)level);
            penguin.m_6863_(true);
            penguin.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0f, 0.0f);
            level.m_47205_((Entity)penguin);
            level.m_7605_((Entity)this, (byte)18);
        }
    }

    private boolean babyIsNearAdult() {
        Iterator iterator;
        if (this.m_6162_() && (iterator = this.f_19853_.m_45976_(Penguin.class, this.m_142469_().m_82377_(2.0, 5.0, 2.0)).iterator()).hasNext()) {
            Penguin penguin = (Penguin)((Object)iterator.next());
            return !penguin.m_6162_();
        }
        return false;
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (this.m_6162_()) {
            if (event.isMoving()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.baby_penguin.waddle", Boolean.valueOf(true)));
            } else if (this.babyIsNearAdult()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.baby_penguin.huddle", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.baby_penguin.idle", Boolean.valueOf(true)));
            }
        } else if (event.isMoving()) {
            if (this.m_20069_()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.penguin.swim", Boolean.valueOf(true)));
            } else if (this.f_19853_.m_8055_(this.m_142538_().m_7495_()).m_60713_(Blocks.f_50126_) && !this.m_27593_() && !this.isPregnant()) {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.penguin.slide", Boolean.valueOf(true)));
            } else {
                event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.penguin.waddle", Boolean.valueOf(true)));
            }
        } else {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("animation.penguin.idle", Boolean.valueOf(true)));
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.setResetSpeedInTicks(5.0);
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 5.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    static class PenguinPathNavigation
    extends WaterBoundPathNavigation {
        public PenguinPathNavigation(Penguin penguin, Level level) {
            super((Mob)penguin, level);
        }

        protected boolean m_7632_() {
            return true;
        }

        protected PathFinder m_5532_(int p_149222_) {
            this.f_26508_ = new AmphibiousNodeEvaluator(false);
            return new PathFinder(this.f_26508_, p_149222_);
        }

        public boolean m_6342_(BlockPos p_149224_) {
            return !this.f_26495_.m_8055_(p_149224_.m_7495_()).m_60795_();
        }
    }
}

