/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.event;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import samebutdifferent.ecologics.block.PotBlock;
import samebutdifferent.ecologics.block.PricklyPearBlock;
import samebutdifferent.ecologics.registry.ModBlocks;
import samebutdifferent.ecologics.registry.ModEntityTypes;
import samebutdifferent.ecologics.registry.ModPlacedFeatures;

@Mod.EventBusSubscriber(modid="ecologics")
public class CommonEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBiomeLoad(BiomeLoadingEvent event) {
        BiomeGenerationSettingsBuilder builder = event.getGeneration();
        ResourceLocation biomeName = event.getName();
        if (biomeName != null && biomeName.m_135815_().equals("beach")) {
            builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.TREES_BEACH).m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.SEASHELL);
        }
        if (event.getCategory() == Biome.BiomeCategory.DESERT) {
            event.getSpawns().m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)ModEntityTypes.CAMEL.get(), 1, 1, 1));
            builder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, ModPlacedFeatures.PRICKLY_PEAR).m_186664_(GenerationStep.Decoration.SURFACE_STRUCTURES, ModPlacedFeatures.DESERT_RUIN);
        }
    }

    @SubscribeEvent
    public static void onCropGrow(BlockEvent.CropGrowEvent.Post event) {
        BlockPos pos = event.getPos();
        LevelAccessor level = event.getWorld();
        BlockState state = event.getState();
        if (state.m_60713_(Blocks.f_50128_) && level.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_50128_) && level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50128_) && level.m_46859_(pos.m_6630_(2))) {
            level.m_7731_(pos.m_6630_(2), ((PricklyPearBlock)ModBlocks.PRICKLY_PEAR.get()).m_49966_(), 2);
            level.m_5594_(null, pos, SoundEvents.f_11967_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getWorld();
        Player player = event.getPlayer();
        BlockState state = level.m_8055_(event.getPos());
        if (state.m_60713_((Block)ModBlocks.POT.get()) && player.m_6047_()) {
            if (player.m_21205_().m_41720_() instanceof PickaxeItem && event.getHand().equals((Object)InteractionHand.MAIN_HAND)) {
                level.m_46597_(event.getPos(), (BlockState)state.m_61122_((Property)PotBlock.CHISEL));
                level.m_5594_(null, event.getPos(), SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, level.m_5822_().nextFloat() * 0.4f + 0.8f);
                player.m_6674_(InteractionHand.MAIN_HAND);
                player.m_21205_().m_41622_(1, (LivingEntity)player, plr -> plr.m_21190_(InteractionHand.MAIN_HAND));
            }
            if (player.m_21206_().m_41720_() instanceof PickaxeItem && !(player.m_21205_().m_41720_() instanceof PickaxeItem) && event.getHand().equals((Object)InteractionHand.OFF_HAND)) {
                level.m_46597_(event.getPos(), (BlockState)state.m_61122_((Property)PotBlock.CHISEL));
                level.m_5594_(null, event.getPos(), SoundEvents.f_12494_, SoundSource.BLOCKS, 1.0f, level.m_5822_().nextFloat() * 0.4f + 0.8f);
                player.m_6674_(InteractionHand.OFF_HAND);
                player.m_21206_().m_41622_(1, (LivingEntity)player, plr -> plr.m_21190_(InteractionHand.MAIN_HAND));
            }
        }
    }
}

