/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.worldgen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import samebutdifferent.ecologics.Ecologics;

public class DesertRuinFeature
extends Feature<NoneFeatureConfiguration> {
    private final BlockIgnoreProcessor IGNORE_STRUCTURE_VOID = new BlockIgnoreProcessor((List)ImmutableList.of((Object)Blocks.f_50454_));
    private final StructurePlaceSettings placementsettings = new StructurePlaceSettings().m_74377_(Mirror.NONE).m_74383_((StructureProcessor)this.IGNORE_STRUCTURE_VOID).m_74392_(false);
    private final ResourceLocation[] pieces = new ResourceLocation[]{new ResourceLocation("ecologics", "desert_ruin/chest_house"), new ResourceLocation("ecologics", "desert_ruin/pillars1"), new ResourceLocation("ecologics", "desert_ruin/pillars2"), new ResourceLocation("ecologics", "desert_ruin/wall1"), new ResourceLocation("ecologics", "desert_ruin/wall2"), new ResourceLocation("ecologics", "desert_ruin/pit")};

    public DesertRuinFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel level = pContext.m_159774_();
        BlockPos origin = pContext.m_159777_();
        Random random = pContext.m_159776_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().m_122190_((Vec3i)origin);
        mutable.m_122173_(Direction.UP);
        while (level.m_46859_((BlockPos)mutable) && mutable.m_123342_() > 2) {
            mutable.m_122173_(Direction.DOWN);
        }
        if (level.m_8055_((BlockPos)mutable).m_60795_() || level.m_46859_(mutable.m_7495_()) || level.m_46859_(mutable.m_6625_(2))) {
            return false;
        }
        mutable.m_122173_(Direction.DOWN);
        BlockPos.MutableBlockPos blockpos$Mutable = new BlockPos.MutableBlockPos();
        StructureManager templatemanager = level.m_6018_().m_142572_().m_129909_();
        ResourceLocation nbtRL = this.pieces[random.nextInt(this.pieces.length)];
        Optional template = templatemanager.m_163774_(nbtRL);
        if (template.isEmpty()) {
            Ecologics.LOGGER.warn(nbtRL + " NTB does not exist!");
            return false;
        }
        for (int x = 0; x < ((StructureTemplate)template.get()).m_163801_().m_123341_(); ++x) {
            for (int z = 0; z < ((StructureTemplate)template.get()).m_163801_().m_123343_(); ++z) {
                blockpos$Mutable.m_122190_((Vec3i)origin.m_7495_()).m_122184_(x, 0, z);
                if (level.m_8055_((BlockPos)blockpos$Mutable).m_60620_((Tag)BlockTags.f_13029_)) continue;
                return false;
            }
        }
        int radius = ((StructureTemplate)template.get()).m_163801_().m_123341_() / 2;
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                if (x * x + z * z >= radius * radius + 1) continue;
                blockpos$Mutable.m_122190_((Vec3i)origin).m_122184_(x, 0, z);
                if (!level.m_6425_((BlockPos)blockpos$Mutable).m_76178_()) {
                    return false;
                }
                if (level.m_8055_((BlockPos)blockpos$Mutable.m_122173_(Direction.UP)).m_60815_() || !level.m_8055_((BlockPos)blockpos$Mutable.m_122175_(Direction.DOWN, 3)).m_60815_()) {
                    return false;
                }
                if (level.m_8055_((BlockPos)blockpos$Mutable).m_60620_((Tag)BlockTags.f_13029_)) continue;
                return false;
            }
        }
        BlockPos halfLengths = new BlockPos(((StructureTemplate)template.get()).m_163801_().m_123341_() / 2, 0, ((StructureTemplate)template.get()).m_163801_().m_123343_() / 2);
        this.placementsettings.m_74379_(Rotation.m_55956_((Random)random)).m_74385_(halfLengths).m_74392_(false);
        blockpos$Mutable.m_122190_((Vec3i)origin);
        BlockPos offset = new BlockPos(-((StructureTemplate)template.get()).m_163801_().m_123341_() / 2, nbtRL.m_135815_().contains("pit") ? -2 : 0, -((StructureTemplate)template.get()).m_163801_().m_123343_() / 2);
        ((StructureTemplate)template.get()).m_74536_((ServerLevelAccessor)level, blockpos$Mutable.m_141952_((Vec3i)offset), blockpos$Mutable.m_141952_((Vec3i)offset), this.placementsettings, random, 2);
        return true;
    }
}

