/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.entities.grapplehook;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.yyon.grapplinghook.entities.grapplehook.GrapplehookEntity;
import com.yyon.grapplinghook.entities.grapplehook.SegmentHandler;
import com.yyon.grapplinghook.utils.Vec;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderGrapplehookEntity<T extends GrapplehookEntity>
extends EntityRenderer<T> {
    protected final Item item;
    private static final ResourceLocation HOOK_TEXTURES = new ResourceLocation("grapplemod", "textures/entity/hook.png");
    private static final RenderType HOOK_RENDER = RenderType.m_110443_((ResourceLocation)HOOK_TEXTURES, (boolean)false);
    private static final ResourceLocation ROPE_TEXTURES = new ResourceLocation("grapplemod", "textures/entity/rope.png");
    private static final RenderType ROPE_RENDER = RenderType.m_110446_((ResourceLocation)ROPE_TEXTURES);
    EntityRendererProvider.Context context;

    public RenderGrapplehookEntity(EntityRendererProvider.Context context, Item itemIn) {
        super(context);
        this.item = itemIn;
        this.context = context;
    }

    public void render(T hookEntity, float p_225623_2_, float partialTicks, PoseStack matrix, MultiBufferSource rendertype, int p_225623_6_) {
        Vec hand_offset;
        if (hookEntity == null || !hookEntity.m_6084_()) {
            return;
        }
        SegmentHandler segmenthandler = ((GrapplehookEntity)((Object)hookEntity)).segmentHandler;
        LivingEntity e = (LivingEntity)((GrapplehookEntity)((Object)hookEntity)).shootingEntity;
        if (e == null || !e.m_6084_()) {
            return;
        }
        LivingEntity playerentity = e;
        int hand_right = (playerentity.m_5737_() == HumanoidArm.RIGHT ? 1 : -1) * (((GrapplehookEntity)((Object)hookEntity)).rightHand ? 1 : -1);
        float f = playerentity.m_21324_(partialTicks);
        float f1 = Mth.m_14031_((float)(Mth.m_14116_((float)f) * (float)Math.PI));
        if ((this.f_114476_.f_114360_ == null || this.f_114476_.f_114360_.m_92176_().m_90612_()) && playerentity == Minecraft.m_91087_().f_91074_) {
            double d7 = this.f_114476_.f_114360_.f_92068_;
            hand_offset = new Vec((double)hand_right * -0.46 * (d7 /= 100.0), -0.18 * d7, 0.38);
            hand_offset = hand_offset.rotatePitch(-f1 * 0.7f);
            hand_offset = hand_offset.rotateYaw(-f1 * 0.5f);
            hand_offset = hand_offset.rotatePitch(-Vec.lerp(partialTicks, playerentity.f_19860_, playerentity.m_146909_()) * 0.01745329238474369);
            hand_offset = hand_offset.rotateYaw(Vec.lerp(partialTicks, playerentity.f_19859_, playerentity.m_146908_()) * 0.01745329238474369);
        } else {
            hand_offset = new Vec((double)hand_right * -0.36, -0.65 + (double)(playerentity.m_6047_() ? -0.1875f : 0.0f), 0.6);
            hand_offset = hand_offset.rotatePitch(f1 * 0.7f);
            hand_offset = hand_offset.rotateYaw(Vec.lerp(partialTicks, playerentity.f_20884_, playerentity.f_20883_) * 0.01745329238474369);
        }
        hand_offset.y += (double)playerentity.m_20192_();
        Vec hand_position = hand_offset.add(Vec.partialPositionVec((Entity)playerentity, partialTicks));
        Vec attach_dir = Vec.motionVec(hookEntity).mult(-1.0);
        if (attach_dir.length() == 0.0) {
            if (((GrapplehookEntity)((Object)hookEntity)).attach_dir != null) {
                attach_dir = ((GrapplehookEntity)((Object)hookEntity)).attach_dir;
            } else if (segmenthandler == null || segmenthandler.segments.size() <= 2) {
                attach_dir = this.getRelativeToEntity((GrapplehookEntity)((Object)hookEntity), new Vec(hand_position), partialTicks);
            } else {
                Vec from = segmenthandler.segments.get(1);
                Vec to = Vec.partialPositionVec(hookEntity, partialTicks);
                attach_dir = from.sub(to);
            }
        }
        attach_dir.normalize_ip();
        if (((GrapplehookEntity)((Object)hookEntity)).attached && ((GrapplehookEntity)((Object)hookEntity)).attach_dir != null) {
            attach_dir = ((GrapplehookEntity)((Object)hookEntity)).attach_dir;
        }
        ((GrapplehookEntity)((Object)hookEntity)).attach_dir = attach_dir;
        matrix.m_85836_();
        matrix.m_85841_(0.5f, 0.5f, 0.5f);
        matrix.m_85845_(new Quaternion(new Vec(0.0, 1.0, 0.0).toVector3f(), (float)(-attach_dir.getYaw()), true));
        matrix.m_85845_(new Quaternion(new Vec(1.0, 0.0, 0.0).toVector3f(), (float)(attach_dir.getPitch() - 90.0), true));
        matrix.m_85845_(new Quaternion(new Vec(0.0, 1.0, 0.0).toVector3f(), (float)(45 * hand_right), true));
        matrix.m_85845_(new Quaternion(new Vec(0.0, 0.0, 1.0).toVector3f(), -45.0f, true));
        ItemStack stack = this.getStackToRender(hookEntity);
        BakedModel bakedmodel = this.context.m_174025_().m_174264_(stack, ((GrapplehookEntity)((Object)hookEntity)).f_19853_, (LivingEntity)null, hookEntity.m_142049_());
        this.context.m_174025_().m_115143_(stack, ItemTransforms.TransformType.NONE, false, matrix, rendertype, p_225623_6_, OverlayTexture.f_118083_, bakedmodel);
        matrix.m_85849_();
        matrix.m_85836_();
        PoseStack.Pose matrixstack$entry = matrix.m_85850_();
        Matrix4f matrix4f1 = matrixstack$entry.m_85861_();
        Matrix3f matrix3f1 = matrixstack$entry.m_85864_();
        VertexConsumer vertexbuffer = rendertype.m_6299_(ROPE_RENDER);
        if (segmenthandler == null) {
            this.drawSegment(new Vec(0.0, 0.0, 0.0), this.getRelativeToEntity((GrapplehookEntity)((Object)hookEntity), new Vec(hand_position), partialTicks), 1.0, vertexbuffer, matrix4f1, matrix3f1, p_225623_6_);
        } else {
            for (int i = 0; i < segmenthandler.segments.size() - 1; ++i) {
                Vec from = segmenthandler.segments.get(i);
                Vec to = segmenthandler.segments.get(i + 1);
                if (i == 0) {
                    from = Vec.partialPositionVec(hookEntity, partialTicks);
                }
                if (i + 2 == segmenthandler.segments.size()) {
                    to = hand_position;
                }
                from = this.getRelativeToEntity((GrapplehookEntity)((Object)hookEntity), from, partialTicks);
                to = this.getRelativeToEntity((GrapplehookEntity)((Object)hookEntity), to, partialTicks);
                double taut = 1.0;
                if (i == segmenthandler.segments.size() - 2) {
                    // empty if block
                }
                this.drawSegment(from, to, taut, vertexbuffer, matrix4f1, matrix3f1, p_225623_6_);
            }
        }
        Vec hook_pos = Vec.partialPositionVec(hookEntity, partialTicks);
        Vec hand_closest = segmenthandler == null || segmenthandler.segments.size() <= 2 ? hook_pos : segmenthandler.segments.get(segmenthandler.segments.size() - 2);
        Vec diff = hand_closest.sub(hand_position);
        Vec forward = diff.changeLen(1.0);
        Vec up = forward.cross(new Vec(1.0, 0.0, 0.0));
        if (up.length() == 0.0) {
            up = forward.cross(new Vec(0.0, 0.0, 1.0));
        }
        up.changeLen_ip(0.025);
        Vec side = forward.cross(up);
        side.changeLen_ip(0.025);
        Vec[] corners = new Vec[]{up.mult(-1.0).add(side.mult(-1.0)), up.mult(-1.0).add(side), up.add(side), up.add(side.mult(-1.0))};
        float[][] uvs = new float[][]{{0.0f, 0.99f}, {0.0f, 1.0f}, {1.0f, 1.0f}, {1.0f, 0.99f}};
        for (int size = 0; size < 4; ++size) {
            Vec corner = corners[size];
            Vec normal = corner.normalize();
            Vec cornerpos = this.getRelativeToEntity((GrapplehookEntity)((Object)hookEntity), hand_position, partialTicks).add(corner);
            vertexbuffer.m_85982_(matrix4f1, (float)cornerpos.x, (float)cornerpos.y, (float)cornerpos.z).m_6122_(255, 255, 255, 255).m_7421_(uvs[size][0], uvs[size][1]).m_86008_(OverlayTexture.f_118083_).m_85969_(p_225623_6_).m_85977_(matrix3f1, (float)normal.x, (float)normal.y, (float)normal.z).m_5752_();
        }
        matrix.m_85849_();
        super.m_7392_(hookEntity, p_225623_2_, partialTicks, matrix, rendertype, p_225623_6_);
    }

    Vec getRelativeToEntity(GrapplehookEntity hookEntity, Vec inVec, float partialTicks) {
        return inVec.sub(Vec.partialPositionVec((Entity)hookEntity, partialTicks));
    }

    private static void vertex(VertexConsumer p_229106_0_, Matrix4f p_229106_1_, Matrix3f p_229106_2_, int p_229106_3_, float p_229106_4_, int p_229106_5_, int p_229106_6_, int p_229106_7_) {
        p_229106_0_.m_85982_(p_229106_1_, p_229106_4_ - 0.5f, (float)p_229106_5_ - 0.5f, 0.0f).m_6122_(255, 255, 255, 255).m_7421_((float)p_229106_6_, (float)p_229106_7_).m_86008_(OverlayTexture.f_118083_).m_85969_(p_229106_3_).m_85977_(p_229106_2_, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public void drawSegment(Vec start, Vec finish, double taut, VertexConsumer vertexbuffer, Matrix4f matrix, Matrix3f matrix3, int p_225623_6_) {
        Vec diff;
        Vec forward;
        Vec up;
        if (start.sub(finish).length() < 0.05) {
            return;
        }
        int number_squares = 16;
        if (taut == 1.0) {
            number_squares = 1;
        }
        if ((up = (forward = (diff = finish.sub(start)).changeLen(1.0)).cross(new Vec(1.0, 0.0, 0.0))).length() == 0.0) {
            up = forward.cross(new Vec(0.0, 0.0, 1.0));
        }
        up.changeLen_ip(0.025);
        Vec side = forward.cross(up);
        side.changeLen_ip(0.025);
        Vec[] corners = new Vec[]{up.mult(-1.0).add(side.mult(-1.0)), up.add(side.mult(-1.0)), up.add(side), up.mult(-1.0).add(side)};
        for (int size = 0; size < 4; ++size) {
            Vec corner1 = corners[size];
            Vec corner2 = corners[(size + 1) % 4];
            Vec normal1 = corner1.normalize();
            Vec normal2 = corner2.normalize();
            for (int square_num = 0; square_num < number_squares; ++square_num) {
                float squarefrac1 = (float)square_num / (float)number_squares;
                Vec pos1 = start.add(diff.mult(squarefrac1));
                pos1.y += -(1.0 - taut) * (0.25 - Math.pow((double)squarefrac1 - 0.5, 2.0)) * 1.5;
                float squarefrac2 = ((float)square_num + 1.0f) / (float)number_squares;
                Vec pos2 = start.add(diff.mult(squarefrac2));
                pos2.y += -(1.0 - taut) * (0.25 - Math.pow((double)squarefrac2 - 0.5, 2.0)) * 1.5;
                Vec corner1pos1 = pos1.add(corner1);
                Vec corner2pos1 = pos1.add(corner2);
                Vec corner1pos2 = pos2.add(corner1);
                Vec corner2pos2 = pos2.add(corner2);
                vertexbuffer.m_85982_(matrix, (float)corner1pos1.x, (float)corner1pos1.y, (float)corner1pos1.z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, squarefrac1).m_86008_(OverlayTexture.f_118083_).m_85969_(p_225623_6_).m_85977_(matrix3, (float)normal1.x, (float)normal1.y, (float)normal1.z).m_5752_();
                vertexbuffer.m_85982_(matrix, (float)corner2pos1.x, (float)corner2pos1.y, (float)corner2pos1.z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, squarefrac1).m_86008_(OverlayTexture.f_118083_).m_85969_(p_225623_6_).m_85977_(matrix3, (float)normal2.x, (float)normal2.y, (float)normal2.z).m_5752_();
                vertexbuffer.m_85982_(matrix, (float)corner2pos2.x, (float)corner2pos2.y, (float)corner2pos2.z).m_6122_(255, 255, 255, 255).m_7421_(1.0f, squarefrac2).m_86008_(OverlayTexture.f_118083_).m_85969_(p_225623_6_).m_85977_(matrix3, (float)normal2.x, (float)normal2.y, (float)normal2.z).m_5752_();
                vertexbuffer.m_85982_(matrix, (float)corner1pos2.x, (float)corner1pos2.y, (float)corner1pos2.z).m_6122_(255, 255, 255, 255).m_7421_(0.0f, squarefrac2).m_86008_(OverlayTexture.f_118083_).m_85969_(p_225623_6_).m_85977_(matrix3, (float)normal1.x, (float)normal1.y, (float)normal1.z).m_5752_();
            }
        }
    }

    public boolean shouldRender(T p_225626_1_, Frustum p_225626_2_, double p_225626_3_, double p_225626_5_, double p_225626_7_) {
        return true;
    }

    public ItemStack getStackToRender(T entityIn) {
        ItemStack stack = new ItemStack((ItemLike)this.item);
        CompoundTag tag = stack.m_41784_();
        tag.m_128379_("hook", true);
        stack.m_41751_(tag);
        return stack;
    }

    public ResourceLocation getTextureLocation(T entity) {
        return HOOK_TEXTURES;
    }
}

