/*
 * Decompiled with CFR 0.152.
 */
package com.github.justinwon777.humancompanions;

import com.github.justinwon777.humancompanions.core.Config;
import com.github.justinwon777.humancompanions.core.ConfiguredStructures;
import com.github.justinwon777.humancompanions.core.EntityInit;
import com.github.justinwon777.humancompanions.core.PacketHandler;
import com.github.justinwon777.humancompanions.core.StructureInit;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="humancompanions")
public class HumanCompanions {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "humancompanions";
    private static Method GETCODEC_METHOD;

    public HumanCompanions() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        EntityInit.ENTITIES.register(eventBus);
        StructureInit.DEFERRED_REGISTRY_STRUCTURE.register(eventBus);
        PacketHandler.register();
        Config.register();
        eventBus.addListener(this::setup);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            StructureInit.setupStructures();
            ConfiguredStructures.registerConfiguredStructures();
        });
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
            if (chunkGenerator instanceof FlatLevelSource && serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            StructureSettings worldStructureConfig = chunkGenerator.m_62205_();
            HashMap<StructureFeature, HashMultimap> StructureToMultiMap = new HashMap<StructureFeature, HashMultimap>();
            ImmutableSet oakBiomes = ImmutableSet.builder().add((Object)Biomes.f_48202_).add((Object)Biomes.f_48176_).add((Object)Biomes.f_186754_).add((Object)Biomes.f_48222_).add((Object)Biomes.f_186769_).add((Object)Biomes.f_48197_).build();
            ImmutableSet oakAndBirchBiomes = ImmutableSet.builder().add((Object)Biomes.f_48205_).add((Object)Biomes.f_48179_).build();
            ImmutableSet birchBiomes = ImmutableSet.builder().add((Object)Biomes.f_48149_).add((Object)Biomes.f_186762_).build();
            ImmutableSet sandstoneBiomes = ImmutableSet.builder().add((Object)Biomes.f_48203_).build();
            ImmutableSet acaciaBiomes = ImmutableSet.builder().add((Object)Biomes.f_48157_).add((Object)Biomes.f_48158_).add((Object)Biomes.f_186768_).build();
            ImmutableSet spruceBiomes = ImmutableSet.builder().add((Object)Biomes.f_186761_).add((Object)Biomes.f_48152_).add((Object)Biomes.f_186755_).add((Object)Biomes.f_186767_).add((Object)Biomes.f_48206_).add((Object)Biomes.f_186763_).add((Object)Biomes.f_186764_).build();
            ImmutableSet darkOakBiomes = ImmutableSet.builder().add((Object)Biomes.f_48151_).build();
            ImmutableSet terracottaBiomes = ImmutableSet.builder().add((Object)Biomes.f_48159_).add((Object)Biomes.f_48194_).add((Object)Biomes.f_186753_).build();
            oakBiomes.forEach(biomeKey -> HumanCompanions.associateBiomeToConfiguredStructure(StructureToMultiMap, ConfiguredStructures.Configured_Oak_House, (ResourceKey<Biome>)biomeKey));
            oakAndBirchBiomes.forEach(biomeKey -> HumanCompanions.associateBiomeToConfiguredStructure(StructureToMultiMap, ConfiguredStructures.Configured_Oak_Birch_House, (ResourceKey<Biome>)biomeKey));
            birchBiomes.forEach(biomeKey -> HumanCompanions.associateBiomeToConfiguredStructure(StructureToMultiMap, ConfiguredStructures.Configured_Birch_House, (ResourceKey<Biome>)biomeKey));
            acaciaBiomes.forEach(biomeKey -> HumanCompanions.associateBiomeToConfiguredStructure(StructureToMultiMap, ConfiguredStructures.Configured_Acacia_House, (ResourceKey<Biome>)biomeKey));
            spruceBiomes.forEach(biomeKey -> HumanCompanions.associateBiomeToConfiguredStructure(StructureToMultiMap, ConfiguredStructures.Configured_Spruce_House, (ResourceKey<Biome>)biomeKey));
            sandstoneBiomes.forEach(biomeKey -> HumanCompanions.associateBiomeToConfiguredStructure(StructureToMultiMap, ConfiguredStructures.Configured_Sandstone_House, (ResourceKey<Biome>)biomeKey));
            darkOakBiomes.forEach(biomeKey -> HumanCompanions.associateBiomeToConfiguredStructure(StructureToMultiMap, ConfiguredStructures.Configured_DarkOak_House, (ResourceKey<Biome>)biomeKey));
            terracottaBiomes.forEach(biomeKey -> HumanCompanions.associateBiomeToConfiguredStructure(StructureToMultiMap, ConfiguredStructures.Configured_Terracotta_House, (ResourceKey<Biome>)biomeKey));
            ImmutableMap.Builder tempStructureToMultiMap = ImmutableMap.builder();
            worldStructureConfig.f_189361_.entrySet().stream().filter(entry -> !StructureToMultiMap.containsKey(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)tempStructureToMultiMap).put(arg_0));
            StructureToMultiMap.forEach((key, value) -> tempStructureToMultiMap.put(key, (Object)ImmutableMultimap.copyOf((Multimap)value)));
            worldStructureConfig.f_189361_ = tempStructureToMultiMap.build();
            try {
                ResourceLocation cgRL;
                if (GETCODEC_METHOD == null) {
                    GETCODEC_METHOD = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"codec", (Class[])new Class[0]);
                }
                if ((cgRL = Registry.f_122890_.m_7981_((Object)((Codec)GETCODEC_METHOD.invoke((Object)chunkGenerator, new Object[0])))) != null && cgRL.m_135827_().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Was unable to check if " + serverLevel.m_46472_().m_135782_() + " is using Terraforged's ChunkGenerator.");
            }
            HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(worldStructureConfig.m_64590_());
            tempMap.putIfAbsent((StructureFeature)StructureInit.COMPANION_HOUSE.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)StructureInit.COMPANION_HOUSE.get()));
            worldStructureConfig.f_64582_ = tempMap;
        }
    }

    private static void associateBiomeToConfiguredStructure(Map<StructureFeature<?>, HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>>> StructureToMultiMap, ConfiguredStructureFeature<?, ?> configuredStructureFeature, ResourceKey<Biome> biomeRegistryKey) {
        StructureToMultiMap.putIfAbsent(configuredStructureFeature.f_65403_, HashMultimap.create());
        HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> configuredStructureToBiomeMultiMap = StructureToMultiMap.get(configuredStructureFeature.f_65403_);
        if (configuredStructureToBiomeMultiMap.containsValue(biomeRegistryKey)) {
            LOGGER.error("    Detected 2 ConfiguredStructureFeatures that share the same base StructureFeature trying to be added to same biome. One will be prevented from spawning.\n    This issue happens with vanilla too and is why a Snowy Village and Plains Village cannot spawn in the same biome because they both use the Village base structure.\n    The two conflicting ConfiguredStructures are: {}, {}\n    The biome that is attempting to be shared: {}\n", (Object)BuiltinRegistries.f_123862_.m_7447_(configuredStructureFeature), (Object)BuiltinRegistries.f_123862_.m_7447_((Object)((ConfiguredStructureFeature)configuredStructureToBiomeMultiMap.entries().stream().filter(e -> e.getValue() == biomeRegistryKey).findFirst().get().getKey())), biomeRegistryKey);
        } else {
            configuredStructureToBiomeMultiMap.put(configuredStructureFeature, biomeRegistryKey);
        }
    }
}

