/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGlobalGuiHandler;
import mezz.jei.api.gui.handlers.IGuiClickableArea;
import mezz.jei.api.gui.handlers.IGuiProperties;
import mezz.jei.api.gui.handlers.IScreenHandler;
import mezz.jei.gui.GuiContainerHandlers;
import mezz.jei.ingredients.IngredientManager;
import mezz.jei.input.ClickedIngredient;
import mezz.jei.input.IClickedIngredient;
import mezz.jei.util.MathUtil;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class GuiScreenHelper {
    private final IngredientManager ingredientManager;
    private final List<IGlobalGuiHandler> globalGuiHandlers;
    private final GuiContainerHandlers guiContainerHandlers;
    private final Map<Class<?>, IGhostIngredientHandler<?>> ghostIngredientHandlers;
    private final Map<Class<?>, IScreenHandler<?>> guiScreenHandlers;
    private Set<Rect2i> guiExclusionAreas = Collections.emptySet();

    public GuiScreenHelper(IngredientManager ingredientManager, List<IGlobalGuiHandler> globalGuiHandlers, GuiContainerHandlers guiContainerHandlers, Map<Class<?>, IGhostIngredientHandler<?>> ghostIngredientHandlers, Map<Class<?>, IScreenHandler<?>> guiScreenHandlers) {
        this.ingredientManager = ingredientManager;
        this.globalGuiHandlers = globalGuiHandlers;
        this.guiContainerHandlers = guiContainerHandlers;
        this.ghostIngredientHandlers = ghostIngredientHandlers;
        this.guiScreenHandlers = guiScreenHandlers;
    }

    @Nullable
    public <T extends Screen> IGuiProperties getGuiProperties(@Nullable T screen) {
        if (screen == null) {
            return null;
        }
        IScreenHandler<?> handler = this.guiScreenHandlers.get(screen.getClass());
        if (handler != null) {
            return handler.apply(screen);
        }
        for (Map.Entry<Class<?>, IScreenHandler<?>> entry : this.guiScreenHandlers.entrySet()) {
            IScreenHandler<?> handler2;
            Class<?> guiScreenClass = entry.getKey();
            if (!guiScreenClass.isInstance(screen) || (handler2 = entry.getValue()) == null) continue;
            return handler2.apply(screen);
        }
        return null;
    }

    public boolean updateGuiExclusionAreas(Screen screen) {
        Set<Rect2i> guiAreas = this.getPluginsExclusionAreas(screen);
        if (!MathUtil.equalRects(guiAreas, this.guiExclusionAreas)) {
            this.guiExclusionAreas = guiAreas.stream().map(MathUtil::copyRect).collect(Collectors.toUnmodifiableSet());
            return true;
        }
        return false;
    }

    public Set<Rect2i> getGuiExclusionAreas() {
        return this.guiExclusionAreas;
    }

    public boolean isInGuiExclusionArea(double mouseX, double mouseY) {
        return MathUtil.contains(this.guiExclusionAreas, mouseX, mouseY);
    }

    private Set<Rect2i> getPluginsExclusionAreas(Screen screen) {
        HashSet<Rect2i> allGuiExtraAreas = new HashSet<Rect2i>();
        if (screen instanceof AbstractContainerScreen) {
            AbstractContainerScreen guiContainer = (AbstractContainerScreen)screen;
            Collection<Rect2i> guiExtraAreas = this.guiContainerHandlers.getGuiExtraAreas(guiContainer);
            allGuiExtraAreas.addAll(guiExtraAreas);
        }
        for (IGlobalGuiHandler globalGuiHandler : this.globalGuiHandlers) {
            Collection<Rect2i> guiExtraAreas = globalGuiHandler.getGuiExtraAreas();
            allGuiExtraAreas.addAll(guiExtraAreas);
        }
        return allGuiExtraAreas;
    }

    @Nullable
    public <T extends AbstractContainerScreen<?>> IClickedIngredient<?> getPluginsIngredientUnderMouse(T guiContainer, double mouseX, double mouseY) {
        return this.getIngredientsUnderMouse(guiContainer, mouseX, mouseY).map(c -> this.createClickedIngredient(c, guiContainer)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private <T extends AbstractContainerScreen<?>> Stream<Object> getIngredientsUnderMouse(T guiContainer, double mouseX, double mouseY) {
        return Stream.concat(this.guiContainerHandlers.getActiveGuiHandlerStream(guiContainer).map(a -> a.getIngredientUnderMouse(guiContainer, mouseX, mouseY)), this.globalGuiHandlers.stream().map(a -> a.getIngredientUnderMouse(mouseX, mouseY)));
    }

    @Nullable
    public <T extends Screen> IGhostIngredientHandler<T> getGhostIngredientHandler(T guiScreen) {
        IGhostIngredientHandler<?> handler = this.ghostIngredientHandlers.get(guiScreen.getClass());
        if (handler != null) {
            return handler;
        }
        for (Map.Entry<Class<?>, IGhostIngredientHandler<?>> entry : this.ghostIngredientHandlers.entrySet()) {
            IGhostIngredientHandler<?> handler2;
            Class<?> guiScreenClass = entry.getKey();
            if (!guiScreenClass.isInstance(guiScreen) || (handler2 = entry.getValue()) == null) continue;
            return handler2;
        }
        return null;
    }

    @Nullable
    private <T> IClickedIngredient<T> createClickedIngredient(@Nullable T ingredient, AbstractContainerScreen<?> guiContainer) {
        if (ingredient == null) {
            return null;
        }
        if (!this.ingredientManager.isValidIngredient(ingredient)) {
            return null;
        }
        Rect2i area = null;
        Slot slotUnderMouse = guiContainer.getSlotUnderMouse();
        if (ingredient instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)ingredient;
            if (slotUnderMouse != null && ItemStack.m_41728_((ItemStack)slotUnderMouse.m_7993_(), (ItemStack)itemStack)) {
                area = new Rect2i(guiContainer.getGuiLeft() + slotUnderMouse.f_40220_, guiContainer.getGuiTop() + slotUnderMouse.f_40221_, 16, 16);
            }
        }
        return ClickedIngredient.create(ingredient, area);
    }

    @Nullable
    public IGuiClickableArea getGuiClickableArea(AbstractContainerScreen<?> guiContainer, double mouseX, double mouseY) {
        return this.guiContainerHandlers.getGuiClickableArea(guiContainer, mouseX, mouseY);
    }
}

