/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.overlay;

import java.util.List;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.config.IWorldConfig;
import mezz.jei.config.JEIClientConfig;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.elements.GuiIconToggleButton;
import mezz.jei.gui.overlay.IngredientListOverlay;
import mezz.jei.gui.textures.Textures;
import mezz.jei.input.UserInput;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class ConfigButton
extends GuiIconToggleButton {
    private final IngredientListOverlay parent;
    private final IWorldConfig worldConfig;

    public static ConfigButton create(IngredientListOverlay parent, IWorldConfig worldConfig) {
        Textures textures = Internal.getTextures();
        return new ConfigButton(textures.getConfigButtonIcon(), textures.getConfigButtonCheatIcon(), parent, worldConfig);
    }

    private ConfigButton(IDrawable disabledIcon, IDrawable enabledIcon, IngredientListOverlay parent, IWorldConfig worldConfig) {
        super(disabledIcon, enabledIcon);
        this.parent = parent;
        this.worldConfig = worldConfig;
    }

    @Override
    protected void getTooltips(List<Component> tooltip) {
        tooltip.add((Component)new TranslatableComponent("jei.tooltip.config"));
        if (!this.worldConfig.isOverlayEnabled()) {
            TranslatableComponent disabled = new TranslatableComponent("jei.tooltip.ingredient.list.disabled");
            TranslatableComponent disabledFix = new TranslatableComponent("jei.tooltip.ingredient.list.disabled.how.to.fix", new Object[]{KeyBindings.toggleOverlay.m_90863_()});
            tooltip.add((Component)disabled.m_130940_(ChatFormatting.GOLD));
            tooltip.add((Component)disabledFix.m_130940_(ChatFormatting.GOLD));
        } else if (!this.parent.isListDisplayed()) {
            TranslatableComponent notEnoughSpace = new TranslatableComponent("jei.tooltip.not.enough.space");
            tooltip.add((Component)notEnoughSpace.m_130940_(ChatFormatting.GOLD));
        }
        if (this.worldConfig.isCheatItemsEnabled()) {
            MutableComponent enabled = new TranslatableComponent("jei.tooltip.cheat.mode.button.enabled").m_130940_(ChatFormatting.RED);
            tooltip.add((Component)enabled);
            if (!KeyBindings.toggleCheatMode.m_90862_()) {
                component = new TranslatableComponent("jei.tooltip.cheat.mode.how.to.disable.hotkey", new Object[]{KeyBindings.toggleCheatMode.m_90863_()}).m_130940_(ChatFormatting.RED);
                tooltip.add((Component)component);
            } else if (!KeyBindings.toggleCheatModeConfigButton.m_90862_()) {
                component = new TranslatableComponent("jei.tooltip.cheat.mode.how.to.disable.hover.config.button.hotkey", new Object[]{KeyBindings.toggleCheatModeConfigButton.m_90863_()}).m_130940_(ChatFormatting.RED);
                tooltip.add((Component)component);
            }
        }
    }

    @Override
    protected boolean isIconToggledOn() {
        return this.worldConfig.isCheatItemsEnabled();
    }

    @Override
    protected boolean onMouseClicked(UserInput input) {
        if (this.worldConfig.isOverlayEnabled()) {
            if (!input.isSimulate()) {
                if (Screen.m_96637_()) {
                    this.worldConfig.toggleCheatItemsEnabled();
                } else {
                    JEIClientConfig.openSettings();
                }
            }
            return true;
        }
        return false;
    }
}

