/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network.packets;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.network.IPacketId;
import mezz.jei.network.PacketIdServer;
import mezz.jei.network.packets.PacketJei;
import mezz.jei.transfer.BasicRecipeTransferHandlerServer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public class PacketRecipeTransfer
extends PacketJei {
    public final Map<Integer, Integer> recipeMap;
    public final List<Integer> craftingSlots;
    public final List<Integer> inventorySlots;
    private final boolean maxTransfer;
    private final boolean requireCompleteSets;

    public PacketRecipeTransfer(Map<Integer, Integer> recipeMap, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer, boolean requireCompleteSets) {
        this.recipeMap = recipeMap;
        this.craftingSlots = craftingSlots;
        this.inventorySlots = inventorySlots;
        this.maxTransfer = maxTransfer;
        this.requireCompleteSets = requireCompleteSets;
    }

    @Override
    public IPacketId getPacketId() {
        return PacketIdServer.RECIPE_TRANSFER;
    }

    @Override
    public void writePacketData(FriendlyByteBuf buf) {
        buf.m_130130_(this.recipeMap.size());
        for (Map.Entry<Integer, Integer> recipeMapEntry : this.recipeMap.entrySet()) {
            buf.m_130130_(recipeMapEntry.getKey().intValue());
            buf.m_130130_(recipeMapEntry.getValue().intValue());
        }
        buf.m_130130_(this.craftingSlots.size());
        for (Integer craftingSlot : this.craftingSlots) {
            buf.m_130130_(craftingSlot.intValue());
        }
        buf.m_130130_(this.inventorySlots.size());
        for (Integer inventorySlot : this.inventorySlots) {
            buf.m_130130_(inventorySlot.intValue());
        }
        buf.writeBoolean(this.maxTransfer);
        buf.writeBoolean(this.requireCompleteSets);
    }

    public static void readPacketData(FriendlyByteBuf buf, Player player) {
        int recipeMapSize = buf.m_130242_();
        HashMap<Integer, Integer> recipeMap = new HashMap<Integer, Integer>();
        for (int i = 0; i < recipeMapSize; ++i) {
            int slotIndex = buf.m_130242_();
            int recipeItem = buf.m_130242_();
            recipeMap.put(slotIndex, recipeItem);
        }
        int craftingSlotsSize = buf.m_130242_();
        ArrayList<Integer> craftingSlots = new ArrayList<Integer>();
        for (int i = 0; i < craftingSlotsSize; ++i) {
            int slotIndex = buf.m_130242_();
            craftingSlots.add(slotIndex);
        }
        int inventorySlotsSize = buf.m_130242_();
        ArrayList<Integer> inventorySlots = new ArrayList<Integer>();
        for (int i = 0; i < inventorySlotsSize; ++i) {
            int slotIndex = buf.m_130242_();
            inventorySlots.add(slotIndex);
        }
        boolean maxTransfer = buf.readBoolean();
        boolean requireCompleteSets = buf.readBoolean();
        BasicRecipeTransferHandlerServer.setItems(player, recipeMap, craftingSlots, inventorySlots, maxTransfer, requireCompleteSets);
    }
}

