/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.recipes;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.collect.ListMultiMap;
import mezz.jei.collect.Table;
import mezz.jei.ingredients.IngredientInformationUtil;
import mezz.jei.ingredients.IngredientsForType;
import net.minecraft.resources.ResourceLocation;

public class RecipeMap {
    private final Table<IRecipeCategory<?>, String, List<Object>> recipeTable = Table.hashBasedTable();
    private final ListMultiMap<String, ResourceLocation> categoryUidMap = new ListMultiMap();
    private final Comparator<ResourceLocation> recipeCategoryUidComparator;
    private final IIngredientManager ingredientManager;

    public RecipeMap(Comparator<ResourceLocation> recipeCategoryUidComparator, IIngredientManager ingredientManager) {
        this.recipeCategoryUidComparator = recipeCategoryUidComparator;
        this.ingredientManager = ingredientManager;
    }

    public <V> ImmutableList<ResourceLocation> getRecipeCategories(V ingredient) {
        IIngredientHelper<V> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient);
        HashSet recipeCategories = new HashSet();
        for (String key : IngredientInformationUtil.getUniqueIdsWithWildcard(ingredientHelper, ingredient, UidContext.Recipe)) {
            recipeCategories.addAll(this.categoryUidMap.get(key));
        }
        return ImmutableList.sortedCopyOf(this.recipeCategoryUidComparator, recipeCategories);
    }

    public <V> void addRecipeCategory(IRecipeCategory<?> recipeCategory, V ingredient, IIngredientHelper<V> ingredientHelper) {
        ResourceLocation recipeCategoryUid;
        String key = ingredientHelper.getUniqueId(ingredient, UidContext.Recipe);
        List recipeCategories = (List)this.categoryUidMap.get(key);
        if (!recipeCategories.contains(recipeCategoryUid = recipeCategory.getUid())) {
            recipeCategories.add(recipeCategoryUid);
        }
    }

    public <T, V> ImmutableList<T> getRecipes(IRecipeCategory<T> recipeCategory, V ingredient) {
        IIngredientHelper<V> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredient);
        Map<String, List<Object>> recipesForType = this.recipeTable.getRow(recipeCategory);
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        for (String key : IngredientInformationUtil.getUniqueIdsWithWildcard(ingredientHelper, ingredient, UidContext.Recipe)) {
            List<Object> recipes = recipesForType.get(key);
            if (recipes == null) continue;
            listBuilder.addAll(recipes);
        }
        return listBuilder.build();
    }

    public <T> void addRecipe(T recipe, IRecipeCategory<T> recipeCategory, List<IngredientsForType<?>> ingredientsByType) {
        for (IngredientsForType<?> ingredientsForType : ingredientsByType) {
            this.addRecipe(recipe, recipeCategory, ingredientsForType);
        }
    }

    private <T, V> void addRecipe(T recipe, IRecipeCategory<T> recipeCategory, IngredientsForType<V> ingredientsForType) {
        IIngredientType<V> ingredientType = ingredientsForType.getIngredientType();
        IIngredientHelper<V> ingredientHelper = this.ingredientManager.getIngredientHelper(ingredientType);
        Map<String, List<Object>> recipesForType = this.recipeTable.getRow(recipeCategory);
        HashSet<String> uniqueIds = new HashSet<String>();
        List<List<V>> ingredients = ingredientsForType.getIngredients();
        for (List<V> slot : ingredients) {
            for (V ingredient : slot) {
                String key;
                if (ingredient == null || uniqueIds.contains(key = ingredientHelper.getUniqueId(ingredient, UidContext.Recipe))) continue;
                uniqueIds.add(key);
                List recipes = recipesForType.computeIfAbsent(key, k -> new ArrayList());
                recipes.add(recipe);
                this.addRecipeCategory(recipeCategory, ingredient, ingredientHelper);
            }
        }
    }
}

