/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import java.nio.file.Path;
import java.util.function.Supplier;
import mezz.jei.core.util.FileUtil;
import mezz.jei.core.util.ReflectionUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.network.Connection;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.jetbrains.annotations.Nullable;

public final class ServerConfigPathUtil {
    private static final Path worldDirPath = Path.of("world", new String[0]);
    private static final ReflectionUtil reflectionUtil = new ReflectionUtil();

    private ServerConfigPathUtil() {
    }

    @Nullable
    public static Path getWorldPath(Path basePath, Supplier<MinecraftServer> serverSupplier) {
        Path worldPath = ServerConfigPathUtil.getWorldPath(serverSupplier);
        if (worldPath == null) {
            return null;
        }
        return basePath.resolve(worldPath);
    }

    @Nullable
    private static Path getWorldPath(Supplier<MinecraftServer> serverSupplier) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientPacketListener clientPacketListener = minecraft.m_91403_();
        if (clientPacketListener == null) {
            return null;
        }
        Connection connection = clientPacketListener.m_6198_();
        if (connection.m_129531_()) {
            MinecraftServer minecraftServer = serverSupplier.get();
            if (minecraftServer != null) {
                return reflectionUtil.getFieldWithClass(minecraftServer, LevelStorageSource.LevelStorageAccess.class).findFirst().map(LevelStorageSource.LevelStorageAccess::m_78277_).map(FileUtil::sanitizePathName).map(name -> worldDirPath.resolve("local").resolve((String)name)).orElse(null);
            }
        } else {
            ServerData serverData = minecraft.m_91089_();
            if (serverData != null) {
                int ipHash = serverData.f_105363_.hashCode();
                String ipHashHex = Integer.toHexString(ipHash);
                String name2 = String.format("%s_%s", serverData.f_105362_, ipHashHex);
                name2 = FileUtil.sanitizePathName(name2);
                return worldDirPath.resolve("server").resolve(name2);
            }
        }
        return null;
    }
}

