/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.Internal;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.CycleTimer;
import mezz.jei.gui.ingredients.RendererOverrides;
import mezz.jei.ingredients.IngredientVisibility;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.render.IngredientRenderHelper;
import mezz.jei.util.ErrorUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class RecipeSlot
extends GuiComponent
implements IRecipeSlotView {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_DISPLAYED_INGREDIENTS = 100;
    private final RegisteredIngredients registeredIngredients;
    private final int legacyIngredientIndex;
    private final RecipeIngredientRole role;
    private final CycleTimer cycleTimer;
    private final List<IRecipeSlotTooltipCallback> tooltipCallbacks = new ArrayList<IRecipeSlotTooltipCallback>();
    private final RendererOverrides rendererOverrides;
    private @Unmodifiable List<Optional<ITypedIngredient<?>>> displayIngredients = List.of();
    private @Unmodifiable List<Optional<ITypedIngredient<?>>> allIngredients = List.of();
    private ImmutableRect2i rect;
    @Nullable
    private IDrawable background;
    @Nullable
    private IDrawable overlay;
    @Nullable
    private String slotName;

    public RecipeSlot(RegisteredIngredients registeredIngredients, RecipeIngredientRole role, int xPos, int yPos, int ingredientCycleOffset, int legacyIngredientIndex) {
        this.registeredIngredients = registeredIngredients;
        this.legacyIngredientIndex = legacyIngredientIndex;
        this.rendererOverrides = new RendererOverrides();
        this.role = role;
        this.rect = new ImmutableRect2i(xPos, yPos, 16, 16);
        this.cycleTimer = new CycleTimer(ingredientCycleOffset);
    }

    public int getLegacyIngredientIndex() {
        return this.legacyIngredientIndex;
    }

    @Override
    public @Unmodifiable Stream<ITypedIngredient<?>> getAllIngredients() {
        return this.allIngredients.stream().flatMap(Optional::stream);
    }

    @Override
    public boolean isEmpty() {
        return this.getAllIngredients().findAny().isEmpty();
    }

    @Override
    public <T> Stream<T> getIngredients(IIngredientType<T> ingredientType) {
        return this.getAllIngredients().map(i -> i.getIngredient(ingredientType)).flatMap(Optional::stream);
    }

    @Override
    public Optional<ITypedIngredient<?>> getDisplayedIngredient() {
        return this.cycleTimer.getCycledItem(this.displayIngredients);
    }

    @Override
    public <T> Optional<T> getDisplayedIngredient(IIngredientType<T> ingredientType) {
        return this.getDisplayedIngredient().flatMap(i -> i.getIngredient(ingredientType));
    }

    @Override
    public Optional<String> getSlotName() {
        return Optional.ofNullable(this.slotName);
    }

    @Override
    public RecipeIngredientRole getRole() {
        return this.role;
    }

    @Override
    public void drawHighlight(PoseStack poseStack, int color) {
        int x = this.rect.getX();
        int y = this.rect.getY();
        int width = this.rect.getWidth();
        int height = this.rect.getHeight();
        RenderSystem.m_69465_();
        RecipeSlot.m_93172_((PoseStack)poseStack, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)color);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private <T> void drawTooltip(PoseStack poseStack, int xOffset, int yOffset, int mouseX, int mouseY, ITypedIngredient<T> typedIngredient) {
        IIngredientType<T> ingredientType = typedIngredient.getType();
        T value = typedIngredient.getIngredient();
        poseStack.m_85836_();
        poseStack.m_85837_((double)xOffset, (double)yOffset, 0.0);
        this.drawHighlight(poseStack, -2130706433);
        poseStack.m_85849_();
        try {
            IIngredientRenderer<T> ingredientRenderer = this.getIngredientRenderer(ingredientType);
            List<Component> tooltip = this.getTooltip(value, ingredientType, ingredientRenderer);
            TooltipRenderer.drawHoveringText(poseStack, tooltip, xOffset + mouseX, yOffset + mouseY, value, ingredientRenderer);
            RenderSystem.m_69482_();
        }
        catch (RuntimeException e) {
            LOGGER.error("Exception when rendering tooltip on {}.", value, (Object)e);
        }
    }

    private <T> List<Component> getTooltip(T value, IIngredientType<T> ingredientType, IIngredientRenderer<T> ingredientRenderer) {
        IModIdHelper modIdHelper = Internal.getHelpers().getModIdHelper();
        IIngredientHelper<T> ingredientHelper = this.registeredIngredients.getIngredientHelper(ingredientType);
        List<Component> tooltip = IngredientRenderHelper.getIngredientTooltipSafe(value, ingredientRenderer, ingredientHelper, modIdHelper);
        for (IRecipeSlotTooltipCallback tooltipCallback : this.tooltipCallbacks) {
            tooltipCallback.onTooltip(this, tooltip);
        }
        List<T> ingredients = this.getIngredients(ingredientType).toList();
        ingredientHelper.getTagEquivalent(ingredients).ifPresent(tagEquivalent -> {
            TranslatableComponent acceptsAny = new TranslatableComponent("jei.tooltip.recipe.tag", new Object[]{tagEquivalent});
            tooltip.add((Component)acceptsAny.m_130940_(ChatFormatting.GRAY));
        });
        return tooltip;
    }

    public void setBackground(IDrawable background) {
        this.background = background;
    }

    public void setOverlay(IDrawable overlay) {
        this.overlay = overlay;
    }

    public void set(List<Optional<ITypedIngredient<?>>> ingredients, IntSet focusMatches) {
        this.allIngredients = List.copyOf(ingredients);
        if (!focusMatches.isEmpty()) {
            this.displayIngredients = focusMatches.intStream().filter(i -> i < this.allIngredients.size()).mapToObj(i -> this.allIngredients.get(i)).toList();
        } else {
            IngredientVisibility ingredientVisibility = Internal.getIngredientVisibility();
            this.displayIngredients = this.allIngredients.stream().filter(i -> i.isEmpty() || ingredientVisibility.isIngredientVisible((ITypedIngredient)i.get())).limit(100L).toList();
            if (this.displayIngredients.isEmpty()) {
                this.displayIngredients = this.allIngredients.stream().limit(100L).toList();
            }
        }
    }

    public boolean isMouseOver(double recipeMouseX, double recipeMouseY) {
        return this.rect.contains(recipeMouseX, recipeMouseY);
    }

    public void addTooltipCallback(IRecipeSlotTooltipCallback tooltipCallback) {
        this.tooltipCallbacks.add(tooltipCallback);
    }

    public <T> void addRenderOverride(IIngredientType<T> ingredientType, IIngredientRenderer<T> ingredientRenderer) {
        this.rendererOverrides.addOverride(ingredientType, ingredientRenderer);
        this.rect = new ImmutableRect2i(this.rect.getX(), this.rect.getY(), this.rendererOverrides.getIngredientWidth(), this.rendererOverrides.getIngredientHeight());
    }

    private <T> IIngredientRenderer<T> getIngredientRenderer(IIngredientType<T> ingredientType) {
        return Optional.of(this.rendererOverrides).flatMap(r -> r.getIngredientRenderer(ingredientType)).orElseGet(() -> this.registeredIngredients.getIngredientRenderer(ingredientType));
    }

    public void draw(PoseStack poseStack) {
        this.cycleTimer.onDraw();
        int x = this.rect.getX();
        int y = this.rect.getY();
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 0.0);
        if (this.background != null) {
            this.background.draw(poseStack);
        }
        RenderSystem.m_69478_();
        this.getDisplayedIngredient().ifPresent(ingredient -> this.drawIngredient(poseStack, (ITypedIngredient)ingredient));
        if (this.overlay != null) {
            RenderSystem.m_69478_();
            poseStack.m_85836_();
            poseStack.m_85837_(0.0, 0.0, 200.0);
            this.overlay.draw(poseStack);
            poseStack.m_85849_();
        }
        RenderSystem.m_69461_();
        poseStack.m_85849_();
    }

    private <T> void drawIngredient(PoseStack poseStack, ITypedIngredient<T> typedIngredient) {
        IIngredientType<T> ingredientType = typedIngredient.getType();
        T ingredient = typedIngredient.getIngredient();
        IIngredientRenderer<T> ingredientRenderer = this.getIngredientRenderer(ingredientType);
        try {
            ingredientRenderer.render(poseStack, ingredient);
        }
        catch (LinkageError | RuntimeException e) {
            throw ErrorUtil.createRenderIngredientException(e, ingredient);
        }
    }

    public void drawOverlays(PoseStack poseStack, int xOffset, int yOffset, int mouseX, int mouseY) {
        this.getDisplayedIngredient().ifPresent(typedIngredient -> this.drawTooltip(poseStack, xOffset, yOffset, mouseX, mouseY, (ITypedIngredient)typedIngredient));
    }

    public ImmutableRect2i getRect() {
        return this.rect;
    }

    public void setSlotName(String slotName) {
        this.slotName = slotName;
    }
}

