/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network.packets;

import mezz.jei.common.network.IPacketId;
import mezz.jei.common.network.PacketIdServer;
import mezz.jei.common.network.ServerPacketData;
import mezz.jei.common.network.packets.PacketJei;
import mezz.jei.core.config.IServerConfig;
import mezz.jei.util.ServerCommandUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PacketDeletePlayerItem
extends PacketJei {
    private final ItemStack itemStack;

    public PacketDeletePlayerItem(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public IPacketId getPacketId() {
        return PacketIdServer.DELETE_ITEM;
    }

    @Override
    public void writePacketData(FriendlyByteBuf buf) {
        buf.writeRegistryIdUnsafe(ForgeRegistries.ITEMS, (IForgeRegistryEntry)this.itemStack.m_41720_());
    }

    public static void readPacketData(ServerPacketData data) {
        ItemStack playerItem;
        FriendlyByteBuf buf = data.buf();
        ServerPlayer player = data.player();
        IServerConfig serverConfig = data.serverConfig();
        Item item = (Item)buf.readRegistryIdUnsafe(ForgeRegistries.ITEMS);
        if (ServerCommandUtil.hasPermissionForCheatMode(player, serverConfig) && (playerItem = player.f_36096_.m_142621_()).m_41720_() == item) {
            player.f_36096_.m_142503_(ItemStack.f_41583_);
        }
    }
}

