/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.anvil;

import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.util.ErrorUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class AnvilRecipeMaker {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ItemStack ENCHANTED_BOOK = new ItemStack((ItemLike)Items.f_42690_);

    private AnvilRecipeMaker() {
    }

    public static List<IJeiAnvilRecipe> getAnvilRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        return Stream.concat(AnvilRecipeMaker.getRepairRecipes(vanillaRecipeFactory), AnvilRecipeMaker.getBookEnchantmentRecipes(vanillaRecipeFactory, ingredientManager)).toList();
    }

    private static Stream<IJeiAnvilRecipe> getBookEnchantmentRecipes(IVanillaRecipeFactory vanillaRecipeFactory, IIngredientManager ingredientManager) {
        List<EnchantmentData> enchantmentDatas = ForgeRegistries.ENCHANTMENTS.getValues().stream().map(EnchantmentData::new).toList();
        return ingredientManager.getAllIngredients(VanillaTypes.ITEM).stream().filter(ItemStack::m_41792_).flatMap(ingredient -> AnvilRecipeMaker.getBookEnchantmentRecipes(vanillaRecipeFactory, enchantmentDatas, ingredient));
    }

    private static Stream<IJeiAnvilRecipe> getBookEnchantmentRecipes(IVanillaRecipeFactory vanillaRecipeFactory, List<EnchantmentData> enchantmentDatas, ItemStack ingredient) {
        return enchantmentDatas.stream().filter(data -> data.canEnchant(ingredient)).map(data -> data.getEnchantedBooks(ingredient)).filter(enchantedBooks -> !enchantedBooks.isEmpty()).map(enchantedBooks -> {
            List<ItemStack> outputs = AnvilRecipeMaker.getEnchantedIngredients(ingredient, enchantedBooks);
            return vanillaRecipeFactory.createAnvilRecipe(ingredient, (List<ItemStack>)enchantedBooks, outputs);
        });
    }

    private static List<ItemStack> getEnchantedIngredients(ItemStack ingredient, List<ItemStack> enchantedBooks) {
        return enchantedBooks.stream().map(enchantedBook -> AnvilRecipeMaker.getEnchantedIngredient(ingredient, enchantedBook)).toList();
    }

    private static ItemStack getEnchantedIngredient(ItemStack ingredient, ItemStack enchantedBook) {
        ItemStack enchantedIngredient = ingredient.m_41777_();
        Map bookEnchantments = EnchantmentHelper.m_44831_((ItemStack)enchantedBook);
        EnchantmentHelper.m_44865_((Map)bookEnchantments, (ItemStack)enchantedIngredient);
        return enchantedIngredient;
    }

    private static Stream<RepairData> getRepairData() {
        return Stream.of(new RepairData(Tiers.WOOD.m_6282_(), new ItemStack((ItemLike)Items.f_42420_), new ItemStack((ItemLike)Items.f_42422_), new ItemStack((ItemLike)Items.f_42423_), new ItemStack((ItemLike)Items.f_42421_), new ItemStack((ItemLike)Items.f_42424_)), new RepairData(Ingredient.m_204132_((TagKey)ItemTags.f_13168_), new ItemStack((ItemLike)Items.f_42740_)), new RepairData(Tiers.STONE.m_6282_(), new ItemStack((ItemLike)Items.f_42425_), new ItemStack((ItemLike)Items.f_42427_), new ItemStack((ItemLike)Items.f_42428_), new ItemStack((ItemLike)Items.f_42426_), new ItemStack((ItemLike)Items.f_42429_)), new RepairData(ArmorMaterials.LEATHER.m_6230_(), new ItemStack((ItemLike)Items.f_42407_), new ItemStack((ItemLike)Items.f_42408_), new ItemStack((ItemLike)Items.f_42462_), new ItemStack((ItemLike)Items.f_42463_)), new RepairData(Tiers.IRON.m_6282_(), new ItemStack((ItemLike)Items.f_42383_), new ItemStack((ItemLike)Items.f_42385_), new ItemStack((ItemLike)Items.f_42386_), new ItemStack((ItemLike)Items.f_42384_), new ItemStack((ItemLike)Items.f_42387_)), new RepairData(ArmorMaterials.IRON.m_6230_(), new ItemStack((ItemLike)Items.f_42468_), new ItemStack((ItemLike)Items.f_42469_), new ItemStack((ItemLike)Items.f_42470_), new ItemStack((ItemLike)Items.f_42471_)), new RepairData(ArmorMaterials.CHAIN.m_6230_(), new ItemStack((ItemLike)Items.f_42464_), new ItemStack((ItemLike)Items.f_42465_), new ItemStack((ItemLike)Items.f_42466_), new ItemStack((ItemLike)Items.f_42467_)), new RepairData(Tiers.GOLD.m_6282_(), new ItemStack((ItemLike)Items.f_42430_), new ItemStack((ItemLike)Items.f_42432_), new ItemStack((ItemLike)Items.f_42433_), new ItemStack((ItemLike)Items.f_42431_), new ItemStack((ItemLike)Items.f_42434_)), new RepairData(ArmorMaterials.GOLD.m_6230_(), new ItemStack((ItemLike)Items.f_42476_), new ItemStack((ItemLike)Items.f_42477_), new ItemStack((ItemLike)Items.f_42478_), new ItemStack((ItemLike)Items.f_42479_)), new RepairData(Tiers.DIAMOND.m_6282_(), new ItemStack((ItemLike)Items.f_42388_), new ItemStack((ItemLike)Items.f_42390_), new ItemStack((ItemLike)Items.f_42391_), new ItemStack((ItemLike)Items.f_42389_), new ItemStack((ItemLike)Items.f_42392_)), new RepairData(ArmorMaterials.DIAMOND.m_6230_(), new ItemStack((ItemLike)Items.f_42472_), new ItemStack((ItemLike)Items.f_42473_), new ItemStack((ItemLike)Items.f_42474_), new ItemStack((ItemLike)Items.f_42475_)), new RepairData(Tiers.NETHERITE.m_6282_(), new ItemStack((ItemLike)Items.f_42393_), new ItemStack((ItemLike)Items.f_42396_), new ItemStack((ItemLike)Items.f_42397_), new ItemStack((ItemLike)Items.f_42394_), new ItemStack((ItemLike)Items.f_42395_)), new RepairData(ArmorMaterials.NETHERITE.m_6230_(), new ItemStack((ItemLike)Items.f_42483_), new ItemStack((ItemLike)Items.f_42480_), new ItemStack((ItemLike)Items.f_42482_), new ItemStack((ItemLike)Items.f_42481_)), new RepairData(Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42714_}), new ItemStack((ItemLike)Items.f_42741_)), new RepairData(ArmorMaterials.TURTLE.m_6230_(), new ItemStack((ItemLike)Items.f_42354_)));
    }

    private static Stream<IJeiAnvilRecipe> getRepairRecipes(IVanillaRecipeFactory vanillaRecipeFactory) {
        return AnvilRecipeMaker.getRepairData().flatMap(repairData -> AnvilRecipeMaker.getRepairRecipes(repairData, vanillaRecipeFactory));
    }

    private static Stream<IJeiAnvilRecipe> getRepairRecipes(RepairData repairData, IVanillaRecipeFactory vanillaRecipeFactory) {
        Ingredient repairIngredient = repairData.getRepairIngredient();
        List<ItemStack> repairables = repairData.getRepairables();
        List<ItemStack> repairMaterials = List.of(repairIngredient.m_43908_());
        return repairables.stream().mapMulti((itemStack, consumer) -> {
            ItemStack damagedThreeQuarters = itemStack.m_41777_();
            damagedThreeQuarters.m_41721_(damagedThreeQuarters.m_41776_() * 3 / 4);
            ItemStack damagedHalf = itemStack.m_41777_();
            damagedHalf.m_41721_(damagedHalf.m_41776_() / 2);
            IJeiAnvilRecipe repairWithSame = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedThreeQuarters), List.of(damagedThreeQuarters), List.of(damagedHalf));
            consumer.accept(repairWithSame);
            if (!repairMaterials.isEmpty()) {
                ItemStack damagedFully = itemStack.m_41777_();
                damagedFully.m_41721_(damagedFully.m_41776_());
                IJeiAnvilRecipe repairWithMaterial = vanillaRecipeFactory.createAnvilRecipe(List.of(damagedFully), repairMaterials, List.of(damagedThreeQuarters));
                consumer.accept(repairWithMaterial);
            }
        });
    }

    public static int findLevelsCost(ItemStack leftStack, ItemStack rightStack) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return -1;
        }
        Inventory fakeInventory = new Inventory((Player)player);
        try {
            AnvilMenu repair = new AnvilMenu(0, fakeInventory);
            ((Slot)repair.f_38839_.get(0)).m_5852_(leftStack);
            ((Slot)repair.f_38839_.get(1)).m_5852_(rightStack);
            return repair.m_39028_();
        }
        catch (RuntimeException e) {
            String left = ErrorUtil.getItemStackInfo(leftStack);
            String right = ErrorUtil.getItemStackInfo(rightStack);
            LOGGER.error("Could not get anvil level cost for: ({} and {}).", (Object)left, (Object)right, (Object)e);
            return -1;
        }
    }

    private static class RepairData {
        private final Ingredient repairIngredient;
        private final List<ItemStack> repairables;

        public RepairData(Ingredient repairIngredient, ItemStack ... repairables) {
            this.repairIngredient = repairIngredient;
            this.repairables = List.of(repairables);
        }

        public Ingredient getRepairIngredient() {
            return this.repairIngredient;
        }

        public List<ItemStack> getRepairables() {
            return this.repairables;
        }
    }

    private static final class EnchantmentData {
        private final Enchantment enchantment;
        private final List<ItemStack> enchantedBooks;

        private EnchantmentData(Enchantment enchantment) {
            this.enchantment = enchantment;
            this.enchantedBooks = EnchantmentData.getEnchantedBooks(enchantment);
        }

        public List<ItemStack> getEnchantedBooks(ItemStack ingredient) {
            Item item = ingredient.m_41720_();
            return this.enchantedBooks.stream().filter(enchantedBook -> item.isBookEnchantable(ingredient, enchantedBook)).toList();
        }

        private boolean canEnchant(ItemStack ingredient) {
            try {
                return this.enchantment.m_6081_(ingredient);
            }
            catch (RuntimeException e) {
                String stackInfo = ErrorUtil.getItemStackInfo(ingredient);
                LOGGER.error("Failed to check if ingredient can be enchanted: {}", (Object)stackInfo, (Object)e);
                return false;
            }
        }

        private static List<ItemStack> getEnchantedBooks(Enchantment enchantment) {
            return IntStream.rangeClosed(1, enchantment.m_6586_()).mapToObj(level -> {
                ItemStack bookEnchant = ENCHANTED_BOOK.m_41777_();
                EnchantmentHelper.m_44865_(Map.of(enchantment, level), (ItemStack)bookEnchant);
                return bookEnchant;
            }).toList();
        }
    }
}

